/**
 * @file	user_scheduling.cpp
 * @author  XXX
 * @version 1.0
 * @date	XXX
 *
 * @section DESCRIPTION
 *
 * User-defined Scheduling/Mapping-Allocation schemes
 */

#include "user_scheduling.h"

/*
 * Steps :
 * 1) Choose Scheduling : DEFAULT_SCHEDULING_ALGORITHM or SCHEDULING_ALGORITHM, but not both (delete or comment the unused choice)
 * 2) Choose Mapping/Allocation : DEFAULT_MAPPING_ALGORITHM or MAPPING_ALGORITHM, but not both (delete or comment the unused choice)
 * 3) Replace NewStrategyName by your own strategy name declared in FoRTReSS Preference
 *
 * Help : go to FoRTReSS Menu : Help => FoRTReSS API => Scheduler API => Scheduler
 *        The instance name is "scheduler"
 *        Example : to get waiting queue size of tasks
 *            int Qsize = scheduler.Scheduler_get_waiting_queue_size();
 */

/* Default Scheduling Algorithm */
DEFAULT_SCHEDULING_ALGORITHM(NewStrategyName)

/* User Scheduling Algorithm */
SCHEDULING_ALGORITHM(NewStrategyName) {
	/* ToDo */
}

/* Default Mapping/Allocation Algorithm */
DEFAULT_MAPPING_ALGORITHM(NewStrategyName)

/* User Mapping/Allocation Algorithm */
MAPPING_ALGORITHM(NewStrategyName) {
	/* ToDo */
}
