/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    reconfiguration_manager.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-07-01
 * @section DESCRIPTION
 *			The reconfiguration manager
 */

#ifndef RECONFIGURATION_MANAGER_H
#define RECONFIGURATION_MANAGER_H

#define SC_INCLUDE_DYNAMIC_PROCESSES

#include <systemc.h>
#include "tlm.h"
#include "tlm_utils/peq_with_cb_and_phase.h"
#include "tlm_utils/multi_passthrough_initiator_socket.h"
#include "tlm_utils/multi_passthrough_target_socket.h"
#include "tlm_utils/simple_target_socket.h"
#include "tlm_utils/simple_initiator_socket.h"

#include "memory_manager.h"
#include "trace.h"
#include "utils.h"
#include "manager_interface.h"
#include "reconfigurable_zone.h"
#include "task_priority_comparator.h"
#include "my_priority_queue.h"
#include "simulation_controller.h"
#include "fpga.h"
#include "task.h"
#include "application.h"
#include "scheduler_interface.h"
#include "scheduling.h"
#include "user_scheduling.h"
#include "reconfiguration_unit.h"
#include "scheduler_request.h"
#include "configuration_request.h"
#include "reconfiguration_manager_base.h"

#include <map>
#include <vector>
#include <list>

using namespace sc_core;
using namespace sc_dt;
using namespace std;
using namespace tlm;
using namespace tlm_utils;

//#define GENERATE_RZ_STATE_FILE
//#define GENERATE_TASK_STATE_FILE

class Reconfiguration_manager : public Reconfiguration_manager_base {

private:
	// Priority queue to handle waiting tasks (by ID)
	MyPriorityQueue<SchedulerRequest, PRIORITY_QUEUE_STRATEGY> waiting_queue;

public:


	
	Reconfiguration_manager(sc_module_name instname, vector<RZ *> rzs, vector<Task> tasks, void (*handler)(Scheduler_interface &), FPGA* device, ofstream& logfile, sc_trace_file* mtf, map<string, RZ_config*>& table) :
		Reconfiguration_manager_base(instname, rzs, tasks, handler, device, logfile, mtf, table) {
		
	}

	~Reconfiguration_manager() {
		
	}
	
	// TLM transport methods
	virtual void b_transport_module(int id, tlm_generic_payload& trans, sc_time& delay);
	virtual void b_transport_testbench(int id, tlm_generic_payload& trans, sc_time& delay);

	void Scheduler_display_waiting_queue(void) const;

	
	// ===== Scheduler interface =====
	bool Scheduler_are_tasks_waiting(void) const;
	//SchedulerRequest Scheduler_get_top_request(void);
	//void Scheduler_pop_request(void);
	int Scheduler_get_waiting_queue_size(void);
	int Scheduler_position_of_current_element(void);
	SchedulerRequest& Scheduler_get_element(int position);
	void Scheduler_update_queue(void);
	
	bool Scheduler_last_task_waiting(void) const;	
	void Scheduler_erase_current_task_waiting();
	SchedulerRequest& Scheduler_current_task_waiting();
	SchedulerRequest Scheduler_next_task_waiting();
	void Scheduler_reset_current_position_in_waiting_queue();

	void display_waiting_queue(void) const;
};

#endif
