/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    reconf_threads.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-07-01
 * @section DESCRIPTION
 *			All reconfigurable threads
 */

#ifndef RECONF_THREADS_H
#define RECONF_THREADS_H

#include "reconf_thread_interface.h"
#include "user_algorithm_interface.h"
#include "utils.h"

template<int Ni, int No> void reconf_thread_standard(Reconf_thread_interface &reconf_interface, User_algorithm_interface<Ni, No> &user_algo_interface) {

	sc_process_handle p_handle;

	while(true) {
		wait(reconf_interface.configuration_updated());

		if(p_handle.valid()) {
			// Kill thread
#ifdef GENERATE_LOG_FILE
			Simulation_controller::get_logfile() << reconf_interface.get_name() << ": Waiting for the end of previous user algorithm..." << endl;
#endif
			if(!p_handle.terminated()) wait(p_handle.terminated_event());
#ifdef GENERATE_LOG_FILE
			Simulation_controller::get_logfile() << reconf_interface.get_name() << ": Previous user algorithm terminated successfully!" << endl;
#endif
		}

		void *user_interface_ptr = &user_algo_interface;

#ifdef GENERATE_LOG_FILE
		Simulation_controller::get_logfile() << reconf_interface.get_name() << ": Configuration update: Algorithm " << reconf_interface.get_current_implementation_id() 
			<< " (" << reconf_interface.get_implementation_vector().at(reconf_interface.get_current_implementation_id()).get_name() << ")" << endl;
#endif
		p_handle = sc_spawn(sc_bind(reconf_interface.get_implementation_vector().at(reconf_interface.get_current_implementation_id()).get_algorithm_thread_ptr(), user_interface_ptr));

		reconf_interface.finish_configuration();
	}
}

#endif
