/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    reconf_thread_interface.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-07-01
 * @section DESCRIPTION
 *			Interface to be passed as a parameter for the reconf thread
 */

#ifndef RECONF_THREAD_INTERFACE_H
#define RECONF_THREAD_INTERFACE_H

#ifdef RECOSIM_PART
	#include <systemc.h>
#endif

#ifdef MIDDLEWARE_GEN
	#include "rs_event.h"
#endif

#include "utils.h"
#include "module_implementation.h"

struct Reconf_thread_interface : public sc_interface {
	
	virtual const char* get_name() const = 0;
	virtual const sc_event& configuration_updated() const = 0;

	virtual void finish_configuration(void) = 0;

	virtual int get_current_implementation_id(void) = 0;
	virtual vector<ModuleImplementation> get_implementation_vector(void) = 0;

};

#endif
