/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    memory_manager.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2010-05-20
 * @section DESCRIPTION
 *			This class defines a memory manager used to maintain
 *			a pool of transactions.
 */

#ifndef MEMORY_MANAGER_H
#define MEMORY_MANAGER_H

#include "tlm.h"
#include "utils.h"


class Memory_manager: public tlm::tlm_mm_interface {

	typedef tlm::tlm_generic_payload gp_t;
	
public:
	Memory_manager() : free_list(0), empties(0)
		#ifdef DEBUG
			, count(0)
		#endif
	{}

	~Memory_manager() {
		/*while(empties != 0) {
			delete empties->trans;
			access *current = empties;
			empties = empties->next;
			delete current;
		}*/
	}

	gp_t* allocate();
	void  free(gp_t* trans);
	
private:
	struct access {
		gp_t* trans;
		access* next;
		access* prev;
	};
	
	access* free_list;
	access* empties;

#ifdef DEBUG
	int count;
#endif
};

#endif
