/**
 * UNS - CNRS
 * Copyright 2013 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit� de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: licensing@sattse.com
 *
 * @file    fortress_parameters.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0-build:2014/06/04
 * @date    January 24, 2016 3:10:00 PM CET
 * @section DESCRIPTION
 *
 *          Fortress parameters for xc6vlx240t device (Virtex6)
*/

#define FORTRESS_CONFIGURATION Config_1


#include "simulation.h"
#include "user_parameters.h"

// STEP 0: Environment
PlanAheadVersion Simulation::planAheadVersion	= PLANAHEAD_14_X;
string Simulation::planAheadPath				= "C:/Xilinx/14.5/ISE_DS/PlanAhead/bin";
bool Simulation::VERBOSE_MODE					= true;

// STEP 1: RZ determination per task
bool Simulation::USE_RZ_SET_DESCRIPTION_FILE = false;
string Simulation::RZ_SET_DESCRIPTION_FILENAME = "../../../constraints/.rrd";
bool Simulation::PURELY_RECONFIGURABLE_RZ = false;
bool Simulation::ALLOW_NON_RECTANGULAR_RZ = true;
double Simulation::OVERSIZED_RZ_TRIGGER = 10.0;
double Simulation::RESOURCES_MARGIN = 5;
bool Simulation::IGNORE_RZ_POSITION_CONSTRAINTS = true;

// STEP 2: RZ sort
double Simulation::COST_SHAPE_WEIGHT		= 1.0; 
double Simulation::COST_COMPLIANCE_WEIGHT	= 1.0; 
double Simulation::COST_INTERNAL_FRAGMENTATION_WEIGHT	= 1.0;
bool Simulation::CHECK_RZ_REDUNDANCY		= false; 

// STEP 3: RZ selection for simulation
ImplementationMetric Simulation::IMPLEMENTATION_METRIC	= EXTERNAL_FRAGMENTATION; 
double Simulation::TRIGGER_FACTOR_UNACCEPTABLE			= 33;
double Simulation::TRIGGER_FACTOR_OPTIMUM				= 66;
int Simulation::MINIMUM_DISTANCE_BETWEEN_RZS			= 0;

// STEP 4: Allocation
AllocationStrategy Simulation::ALLOCATION_STRATEGY = NO_OPTIMIZATION; /* Allocation optimization strategy */
ProcessorAllocationStrategy Simulation::PROCESSOR_ALLOCATION_STRATEGY = SOFT_NO_OPTIMIZATION; /* Allocation optimization strategy for processors */

// STEP 5: PR cost model
BitstreamGeneration Simulation::BITSTREAM_GENERATION = NONE;	/* Bistream generation for compression estimation */
float Simulation::MEAN_COMPRESSION_RATIO	= (float)((26.7)/100.0f);	/* Mean compression ratio */
float Simulation::Tbus						= (float)(10);	/* Bus period in nanoseconds */
float Simulation::Ticap						= (float)(10);	/* ICAP period in nanoseconds */
float Simulation::Nburst					= (float)(16);	/* Burst length */
float Simulation::tburst					= (float)(48.2);	/* Time spent on a burst, in cycles of Tbus */
float Simulation::latency					= (float)(10);	/* Latency to initiate a transaction on the bus, in cycles of Tbus */
float Simulation::fifoDepth					= (float)(1024);	/* FaRM FIFO depth in 32-bit words */

// Step 6 : Simulation
bool Simulation::RUN_SIMULATION_UNTIL_STATIC_SOLUTION	= false; 

