/**
 * UNS - CNRS
 * Copyright 2013 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit� de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: licensing@sattse.com
 *
 * @file    fortress_main.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0-build:2014/06/04
 * @date    January 24, 2016 3:10:00 PM CET
 * @section DESCRIPTION
 *
 *          Main class for the RZ Generator (xc6vlx240t device ,Virtex6)
*/

#define FORTRESS_CONFIGURATION Config_1


#include <iostream>
#include <sstream>
#include <string>
#include <vector>
using namespace std;

#include "task.h"
#include "simulation.h"
#include "user_parameters.h"

int main(void) {

	cout << "=================================" << endl;
	cout << "=======   FoRTReSS Flow   =======" << endl;
	cout << "=================================" << endl << endl;

	Simulation simulation;
	simulation.displayParameters();

	vector<InterfaceLocation> interfacesVector;
	vector<HwTask> hwTasks;
	vector<SwTask> swTasks;
	set<string> modules;
	vector<Processor> processors;
	
	/* Generate Module name */
	modules.insert("T1");
	modules.insert("T2");
	modules.insert("T3");

	
	/* Interface(s) on FPGA */

	/* Application : app1, repeat : 1 */
	hwTasks.push_back(HwTask("T2.Hw1", "", "../../../tasks/HwImpl_2.tsk", 0.0, false));
	hwTasks.back().setPossibleInterfaceLocations(interfacesVector);

	simulation.setHwTaskVector(hwTasks);
	simulation.setInterfaceVector(interfacesVector);
	simulation.setModuleSet(modules);
	
	/* Sw Nodes */
	swTasks.push_back(SwTask("T1.Sw1", 0.0, false, "Microblaze"));
	swTasks.push_back(SwTask("T2.Sw1", 0.0, false, "Microblaze"));
	swTasks.push_back(SwTask("T3.Sw1", 0.0, false, "Microblaze"));

	simulation.setSwTaskVector(swTasks);
	
	/* Processor List */
	processors.push_back(Processor("Core_0", "Microblaze", 0.0));
	
	simulation.setProcessorVector(processors);
	
	simulation.setLogDirectory("../../solutions/");
	simulation.setTraceDirectory("../../solutions/");
	simulation.setCSVDirectory("../../solutions/");
	simulation.setUCFDirectory("../../solutions/");
	simulation.setXMLDirectory("../../solutions/");
	
	/* Run Simulation */
	int flowReturnValue = simulation.launchArchGenFlow();
	
	if(flowReturnValue != 0)
		cerr << "ERROR: ArchGen flow exited abnormally !" << endl;

	return flowReturnValue;
}
