/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    synthesisReport.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-04-19
 * @section DESCRIPTION
 *			Class representing a synthesis report, used for task description
 */

#ifndef SYNTHESIS_REPORT_H
#define SYNTHESIS_REPORT_H

#include <iostream>
#include <string>
#include <vector>
using namespace std;

#include "taskResourceFile.h"

class SynthesisReport : public TaskResourceFile {

private:

	/* Constant strings used for parsing */
	static const string STRING_SELECTED_DEVICE;
	static const string STRING_NB_SLICE_REGISTERS;
	static const string STRING_NB_SLICE_LUTS;
	static const string STRING_NB_SLICE_LUTS_MEM;
	static const string STRING_NB_DSP48;
	static const string STRING_NB_RAMB36;
	static const string STRING_NB_IOB;

public:
	SynthesisReport(string n) : TaskResourceFile(n) {}
	SynthesisReport(SynthesisReport& other) : TaskResourceFile(other) {}
	SynthesisReport() {}

	~SynthesisReport() {}

	// Inherited methods
	int readResourceFile(void);

private:
	int readSynthesisReport(void);
	
};

#endif
