/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    softwareTask.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2011-08-12
 * @section DESCRIPTION
 *			Representation of a SW task
 */

#ifndef SOFTWARE_TASK_H
#define SOFTWARE_TASK_H

#include <string>
using namespace std;

#include "task.h"
#include "processor.h"

class SwTask : public Task {
	
private:
	static const string ANY_CORE_STRING;
	string type;
	double binaryLoadingTime;	// Time in us

public:
	/* Constructor */
	SwTask(string n, double loadingTime, string t = ANY_CORE_STRING) : Task(n), type(t), binaryLoadingTime(loadingTime) {}
	SwTask(string n, double loadingTime, bool static_mod, string t = ANY_CORE_STRING) : Task(n, static_mod), type(t), binaryLoadingTime(loadingTime) {}
	SwTask(){}

	/* Misc */
	bool fitsProcessor(Processor *p);

	double getBinaryLoadingTime(void);

};

#endif
