/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    processor.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-06-05
 * @section DESCRIPTION
 *			Processor description
 */

#ifndef PROCESSOR_H
#define PROCESSOR_H

#include <iostream>
#include <string>
#include <vector>
#include <set>

using namespace std;

class Processor {

private:
	string name;					/*< Processor name */
	string type;					/*< Processor type (e.g. ARM, PowerPC, MicroBlaze) */
	double contextSwitchTime;		/*< Context switch time in us, considered equal over tasks */
	vector<string> compatibleTasks;	/*< List of compatible tasks */

	multiset<string> processorInterfaces;

public:
	Processor(string n, string _type, double t) : name(n), type(_type), contextSwitchTime(t) {}

	string getName(void);
	string getType(void);
	double getContextSwitchTime(void);

	void addCompatibleTask(string task);
	vector<string> getCompatibleTaskVector(void);
	void clearCompatibleTasks(void);

	void addInterface(string s, int n = 1);
	int getInterfaceCount(string s);
	multiset<string> getProcessorInterfaces(void);

};

#endif
