/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    coordinates.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-06-05
 * @section DESCRIPTION
 *			Simple cartesian coordinates describing constraints
 */

#ifndef COORDINATES_H
#define COORDINATES_H

class Coordinates {

private:
	int x;
	int y;

public:
	Coordinates(int _x, int _y) : x(_x), y(_y) {}

	int getX(void);
	int getY(void);

	bool operator== (const Coordinates &other) const;

};

#endif
