/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    cell.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2013-01-14
 * @section DESCRIPTION
 *			FPGA cell
 */

#ifndef CELL_H
#define CELL_H

#include <string>

class Cell {

	std::string name;
	int nbCellsPerColumn;
	int cost;
	bool reconfigurable;
	int bitstreamSizePerColumn; // in bytes
	bool sensitiveToResourceMargin;

public:

	Cell(std::string _name, bool _reconfigurable, int _nbCellsPerColumn = 1 , int _cost = 0, int _bitstreamSizerPerColumn = 0, bool _sensitive = false) : 
	  name(_name), nbCellsPerColumn(_nbCellsPerColumn), cost(_cost), reconfigurable(_reconfigurable), bitstreamSizePerColumn(_bitstreamSizerPerColumn), sensitiveToResourceMargin(_sensitive) {}

	Cell() : name(""), nbCellsPerColumn(0), cost(0), reconfigurable(false), bitstreamSizePerColumn(0), sensitiveToResourceMargin(false) {}

	std::string getName(void) const;
	int getNbCellsPerColumn(void) const;
	int getCellCost(void) const;
	bool isReconfigurable(void) const;
	int getBitstreamSizePerColumn(void) const;
	bool isSentitiveToResourceMargin(void) const;

};

#endif
