/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    XMLTaskDescription.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2013-01-10
 * @section DESCRIPTION
 *			XML representation of task resource needs
 */

#ifndef XML_TASK_DESCRIPTION_H
#define XML_TASK_DESCRIPTION_H

#include "XMLFile.h"
#include "taskResourceFile.h"
#include <string>

class XMLTaskDescription : public XMLFile, public TaskResourceFile {

	// XML tags
	XMLCh* TAG_Device_name;
	XMLCh* TAG_Device_package;
	XMLCh* TAG_Speed_grade;
	XMLCh* TAG_DP;
	XMLCh* TAG_SG;
	XMLCh* TAG_Cell;

	// Cell description attributes
	XMLCh* ATTR_name;
	XMLCh* ATTR_value;

public:

	XMLTaskDescription(std::string filename) : XMLFile(filename), TaskResourceFile(filename) {

		// Tags and attributes used in XML file.
		TAG_Device_name		= XMLString::transcode("DeviceName");
		TAG_Device_package	= XMLString::transcode("DevicePackage");
		TAG_Speed_grade		= XMLString::transcode("SpeedGrade");
		TAG_DP				= XMLString::transcode("DP");
		TAG_SG				= XMLString::transcode("SG");
		TAG_Cell			= XMLString::transcode("Cell");

		ATTR_name			= XMLString::transcode("name");
		ATTR_value			= XMLString::transcode("value");
	}

	XMLTaskDescription(XMLTaskDescription& other) : XMLFile(other.filename), TaskResourceFile(other) {

		// Tags and attributes used in XML file.
		TAG_Device_name		= XMLString::transcode("DeviceName");
		TAG_Device_package	= XMLString::transcode("DevicePackage");
		TAG_Speed_grade		= XMLString::transcode("SpeedGrade");
		TAG_DP				= XMLString::transcode("DP");
		TAG_SG				= XMLString::transcode("SG");
		TAG_Cell			= XMLString::transcode("Cell");

		ATTR_name			= XMLString::transcode("name");
		ATTR_value			= XMLString::transcode("value");
	}

	~XMLTaskDescription() {
		try {
			XMLString::release(&TAG_Device_name);
			XMLString::release(&TAG_Device_package);
			XMLString::release(&TAG_Speed_grade);
			XMLString::release(&TAG_DP);
			XMLString::release(&TAG_SG);
			XMLString::release(&TAG_Cell);
			XMLString::release(&ATTR_name);
			XMLString::release(&ATTR_value);
		} catch(...) {
			cerr << "Unknown exception encountered in TagNamesdtor" << endl;
		}
	}

	int readResourceFile(void);
};

#endif
