/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    XMLFile.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-12-18
 * @section DESCRIPTION
 *			Generic XML handler using Xerces-C
 */

#ifndef XML_FILE_H
#define XML_FILE_H

#include <string>
#include <iostream>
using namespace std;

#include <xercesc/dom/DOM.hpp>
#include <xercesc/util/PlatformUtils.hpp>
#include <xercesc/parsers/XercesDOMParser.hpp>
using namespace xercesc;

class XMLFile {

protected:
	string filename;
	XercesDOMParser *m_ConfigFileParser;

public:
	XMLFile(string _filename) : filename(_filename) {
		try {
			XMLPlatformUtils::Initialize();  // Initialize Xerces infrastructure
		} catch( XMLException& e ) {
			char* message = XMLString::transcode( e.getMessage() );
			cerr << "XML toolkit initialization error: " << message << endl;
			XMLString::release( &message );
			// throw exception here to return ERROR_XERCES_INIT
		}

		m_ConfigFileParser = new XercesDOMParser();
	}

	~XMLFile() {
		// Free memory
		delete m_ConfigFileParser;

		// Terminate Xerces
		try {
			XMLPlatformUtils::Terminate();  // Terminate after release of memory
		} catch( xercesc::XMLException& e ) {
			char* message = xercesc::XMLString::transcode( e.getMessage() );
			cerr << "XML toolkit teardown error: " << message << endl;
			XMLString::release( &message );
		}
	}
	
};

#endif
