/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    RZSetDescriptionFile.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-12-18
 * @section DESCRIPTION
 *			RZ set description file
 */

#ifndef RZ_SET_DESCRIPTION_FILE_H
#define RZ_SET_DESCRIPTION_FILE_H

#include "XMLFile.h"
#include <vector>
#include "RZ.h"

enum {
   ERROR_ARGS = 1, 
   ERROR_XERCES_INIT,
   ERROR_PARSE,
   ERROR_EMPTY_DOCUMENT
};

class RZSetDescriptionFile : public XMLFile {

	// XML tags
	XMLCh* TAG_Device_name;
	XMLCh* TAG_Device_package;
	XMLCh* TAG_Speed_grade;
	XMLCh* TAG_DP;
	XMLCh* TAG_SG;
	XMLCh* TAG_RZ_description;
	XMLCh* TAG_Column;

	// RZ description attributes
	XMLCh* ATTR_RZ_ID;
	XMLCh* ATTR_Column_number;
	XMLCh* ATTR_Line_number;
	XMLCh* ATTR_Height;
	XMLCh* ATTR_Reverse;
	XMLCh* ATTR_Value;

	// Column description attributes
	XMLCh* ATTR_Column_all;
	XMLCh* ATTR_Column_repeat;

public:
	RZSetDescriptionFile(string filename, Device* _device) : XMLFile(filename) {
	
		// Tags and attributes used in XML file.
		TAG_Device_name		= XMLString::transcode("DeviceName");
		TAG_Device_package	= XMLString::transcode("DevicePackage");
		TAG_Speed_grade		= XMLString::transcode("SpeedGrade");
		TAG_DP				= XMLString::transcode("DP");
		TAG_SG				= XMLString::transcode("SG");
		TAG_RZ_description	= XMLString::transcode("Description");
		TAG_Column			= XMLString::transcode("CN");

		ATTR_RZ_ID			= XMLString::transcode("RZ_ID");
		ATTR_Column_number	= XMLString::transcode("Column");
		ATTR_Line_number	= XMLString::transcode("Line");
		ATTR_Height			= XMLString::transcode("Height");
		ATTR_Reverse		= XMLString::transcode("Reverse");
		ATTR_Value			= XMLString::transcode("value");

		ATTR_Column_all		= XMLString::transcode("ALL");
		ATTR_Column_repeat	= XMLString::transcode("REPEAT");
	}

	~RZSetDescriptionFile() {

		try {
			XMLString::release(&TAG_Device_name);
			XMLString::release(&TAG_Device_package);
			XMLString::release(&TAG_Speed_grade);
			XMLString::release(&TAG_DP);
			XMLString::release(&TAG_SG);
			XMLString::release(&TAG_RZ_description);
			XMLString::release(&TAG_Column);
			XMLString::release(&ATTR_RZ_ID);
			XMLString::release(&ATTR_Column_number);
			XMLString::release(&ATTR_Line_number);
			XMLString::release(&ATTR_Height);
			XMLString::release(&ATTR_Reverse);
			XMLString::release(&ATTR_Value);
			XMLString::release(&ATTR_Column_all);
			XMLString::release(&ATTR_Column_repeat);
		} catch(...) {
			cerr << "Unknown exception encountered in TagNamesdtor" << endl;
		}
	}

	int readConfigFile(Device *device, vector<RZ> &);
	void createDOMDocument(DOMDocument *doc, Device *device, vector<RZ> &);
	void writeConfigFile(Device *device, vector<RZ> &);

private:
	void readRZDescription(DOMDocument*, DOMElement*, Device* device, vector<RZ> &);

};

#endif
