/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    RZFinderManager.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-04-24
 * @section DESCRIPTION
 *			A static class to manage synthesis reports
 */

#ifndef RZ_FINDER_MANAGER_H
#define RZ_FINDER_MANAGER_H

#include <vector>
#include <map>
using namespace std;

#include "resourceRequirements.h"
#include "RZ.h"

class RZFinderManager {

private:
	static map<ResourceRequirements, vector<RZ> > resourceRequirementsRZSetMap;

public:
	static vector<RZ> retrieveRZSet(ResourceRequirements &);

};

#endif
