#include "rs_time.h"


rs_time rs_time_stamp()
{
  struct timeval tv;
  gettimeofday(&tv, NULL);
  return rs_time(((uint64_t)tv.tv_sec*1000000+(uint64_t)tv.tv_usec)&0xFFFF);
}


void 
rs_time::print(::std::ostream& os) const
{
  os << m_value << "us";
}


// IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII

// constructors


rs_time::rs_time()
: m_value( 0 )
{}

rs_time::~rs_time()
{}

rs_time::rs_time( const rs_time& t )
: m_value( t.m_value )
{}


rs_time::rs_time( double d )
:m_value((uint64_t)d)
{}

rs_time::rs_time( double d , rs_time_uint r)
:m_value(((uint64_t)d)*r)
{}

rs_time::rs_time( uint64_t i )
:m_value(i)
{}

rs_time::rs_time( uint64_t i , rs_time_uint r)
:m_value(i*r)
{}

rs_time::rs_time( int i)
:m_value((uint64_t)i)
{}

rs_time::rs_time( int i , rs_time_uint r)
:m_value(((uint64_t)i)*r)
{}

// assignment operator


rs_time&
rs_time::operator = ( const rs_time& t )
{
    m_value = t.m_value;
    return *this;
}


// conversion functions


uint64_t
rs_time::value() const  // relative to the time resolution
{
    return m_value;
}



double
rs_time::to_double() const  // relative to the time resolution
{
    return (double)m_value;
}


// relational operators


bool
rs_time::operator == ( const rs_time& t ) const
{
    return ( m_value == t.m_value );
}


bool
rs_time::operator != ( const rs_time& t ) const
{
    return ( m_value != t.m_value );
}


bool
rs_time::operator < ( const rs_time& t ) const
{
    return ( m_value < t.m_value );
}


bool
rs_time::operator <= ( const rs_time& t ) const
{
    return ( m_value <= t.m_value );
}


bool
rs_time::operator > ( const rs_time& t ) const
{
    return ( m_value > t.m_value );
}


bool
rs_time::operator >= ( const rs_time& t ) const
{
    return ( m_value >= t.m_value );
}


// arithmetic operators


rs_time&
rs_time::operator += ( const rs_time& t )
{
    m_value += t.m_value;
    return *this;
}


rs_time&
rs_time::operator -= ( const rs_time& t )
{
    m_value -= t.m_value;
    return *this;
}



const rs_time
operator + ( const rs_time& t1, const rs_time& t2 )
{
    return rs_time( t1 ) += t2;
}


const rs_time
operator - ( const rs_time& t1, const rs_time& t2 )
{
    return rs_time( t1 ) -= t2;
}



rs_time&
rs_time::operator *= ( double d )
{
    // linux bug workaround; don't change next two lines
    m_value *= d;
    return *this;
}


rs_time&
rs_time::operator /= ( double d )
{
    // linux bug workaround; don't change next two lines
    m_value /= d;
    return *this;
}



const rs_time
operator * ( const rs_time& t, double d )
{
    rs_time tmp( t );
    return tmp *= d;
}


const rs_time
operator * ( double d, const rs_time& t )
{
    rs_time tmp( t );
    return tmp *= d;
}


const rs_time
operator / ( const rs_time& t, double d )
{
    rs_time tmp( t );
    return tmp /= d;
}


double
operator / ( const rs_time& t1, const rs_time& t2 )
{
    return ( t1.to_double() / t2.to_double() );
}


// print operator


::std::ostream&
operator << ( ::std::ostream& os, const rs_time& t )
{
    t.print( os );
    return os;
}
