/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    resources.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-06-20
 * @section DESCRIPTION
 *			Resources representation
 */

#include "resources.h"

int Resources::getResourceCount(string resource_name) const {
	if(resourceMap.find(resource_name) != resourceMap.end()) return resourceMap.find(resource_name)->second;
	else return 0;
}

map<string, int> &Resources::getResourceMap(void) {
	return resourceMap;
}
