/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    configuration_request.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2013-03-01
 * @section DESCRIPTION
 *			A configuration request
 */

#include "configuration_request.h"

int ConfigurationRequest::getTaskID(void) const {
	return taskID;
}

pid_t ConfigurationRequest::getTaskTID(void) const {
	return taskTID;
}

int ConfigurationRequest::getTaskImplementationID(void) const {
	return taskImplementationID;
}

RZ* ConfigurationRequest::getHostingRZ(void) const {
	return hostingRZ;
}

const bool ConfigurationRequest::operator==(const ConfigurationRequest& other) {
	return (taskID == other.taskID
		&& taskImplementationID == other.taskImplementationID
		&& hostingRZ == other.hostingRZ);
}

std::ostream& operator<<(std::ostream& stream, const ConfigurationRequest& obj) {
	stream << "Request(" << obj.getTaskID() << ", " << obj.getTaskImplementationID() << ", " << obj.getHostingRZ() << ")";
	return stream;
}
