/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    module_interface.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-10-16
 * @section DESCRIPTION
 *			Module interface, directly related to the DAG connections.
 */

#ifndef MODULE_INTERFACE_H
#define MODULE_INTERFACE_H

#include <string>
using namespace std;

class ModuleInterface {

private:
	string name;
	string type;
	bool priority_channel;
	bool transient;

public:
	ModuleInterface(string _name, string _type, bool _priority, bool _transient = false) : name(_name), type(_type), priority_channel(_priority), transient(_transient) {}
	ModuleInterface() : name(""), type(""), priority_channel(false), transient(false) {}
	
	string get_name(void) const;
	string get_type(void) const;
	bool is_priority_channel(void) const;
	bool is_transient(void) const;

};

#endif
