/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    application.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-08-30
 * @section DESCRIPTION
 *			Application representation
 */

#ifndef APPLICATION_H
#define APPLICATION_H

#define SC_INCLUDE_DYNAMIC_PROCESSES

//#include <systemc.h>
#include <string>
#include <vector>
#include "rs_time.h"
#include "manager_interface.h"
#include "application_interface.h"
//#include <list>

//using namespace std;
//using namespace sc_core;
//using namespace sc_dt;

class Application : public Application_interface {

private:
	string name;
	string prefix;

	double qosFactor;
	int firstTaskID;
	int lastTaskID;
	int instanceID;

	int nbPassedDeadlines;
	int nbMissedDeadlines;
	int nbPassedDeadlinesOnHyperperiod;
	int nbMissedDeadlinesOnHyperperiod;

	rs_time achievedSimulationTime;

	rs_time offset;
	rs_time hyperperiod;

	bool status;

	vector<pair<string, rs_time> > missed_deadlines;
	vector<pair<string, rs_time> > missed_deadlines_last_hyperperiod;

	bool qosFailure;

	static rs_time minimumSimulationTime;
	static rs_time globalOffset;
	static rs_time globalHyperperiod;

	static rs_time userOffset;
	static rs_time userHyperperiod;
	static bool overrideOffset;
	static bool overrideHyperperiod;

	double minimalInstantQoS;

public:
	Application(string _name, string _prefix, int _instanceID, double qos, int start, int stop) :  name(_name), prefix(_prefix), instanceID(_instanceID), qosFactor(qos), firstTaskID(start), lastTaskID(stop) {
		nbPassedDeadlines = 0;
		nbMissedDeadlines = 0;
		nbPassedDeadlinesOnHyperperiod = 0;
		nbMissedDeadlinesOnHyperperiod = 0;
		offset = RS_ZERO_TIME;
		hyperperiod = RS_ZERO_TIME;
		status = false;
		qosFailure = false;

		minimalInstantQoS = 100.0;
	}

	Application(void) {}

	// Application_interface

	string getName(void);
	bool containsTask(int taskID);
	int getFirstTaskID();
	int getTaskNumber();
	



	//double getQoSFactor(void);
	double getAchievedQoS(void);
	double getMinimalQoS(void);

	string getFullModuleName(string moduleName);

	void incrementPassedDeadlines(void);
	void incrementMissedDeadlines(string taskname);

	void computeMinimumSimulationTime(vector<Manager_interface *>& table);

	void setAchievedSimulationTime(rs_time t);
	rs_time getAchievedSimulationTime(void);
	bool isSimulationTimeEnough(void);

	bool getStatus(void);
	void setStatus(bool);

	bool isQoSSatisfied(void);

	void checkQoSOnHyperperiod(void);

	

	vector<pair<string, rs_time> >& getMissedDeadlinesVector(void);
	bool hasMissedDeadlines(void);

	

	// Static members
	static rs_time getGlobalHypeperiod(void);
	static rs_time getGlobalOffset(void);
	static rs_time getMinimumSimulationTime(void);
	static void computeMinimumSimulationTime(vector<Application>&);

	static void setOffset(rs_time);
	static void setHyperperiod(rs_time);

private:
	rs_time getOffset(void);
	rs_time getHyperperiod(void);

	static void computeGlobalHypeperiod(vector<Application>&);
	static void computeGlobalOffset(vector<Application>&);

};

#endif
