/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    task_implementation.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-08-22
 * @section DESCRIPTION
 *			Represents the immplementation of a task
 */

#include "task_implementation.h"

string TaskImplementation::getFullName(void) {
	return full_name;
}

string TaskImplementation::getTaskName(void) {
	return task_name;
}

string TaskImplementation::getImplementationName(void) {
	return implementation_name;
}

string TaskImplementation::getNetlistName(void) {
	return netlist_name;
}

string TaskImplementation::getAlgorithmName(void) {
	return algorithm_name;
}

bool TaskImplementation::hasSameNetlist(TaskImplementation &ti) const {

	if (ti.netlist_name.size() == 0 || netlist_name.size() == 0)
		return false;
	else
		return netlist_name.compare(ti.netlist_name) == 0;
}

rs_time TaskImplementation::getCompressedReconfigurationTime(void) {
	return compressedReconfigurationTime;
}

//rs_time TaskImplementation::getPreloadReconfigurationTime(void) {
//	return preloadReconfigurationTime;
//}

//rs_time TaskImplementation::getContextSwitchTime(void) {
//	return contextSwitchTime;
//}

void TaskImplementation::addOccupationTime(RZState state, rs_time t) {
	occupationTimes[state] += t;
}

rs_time TaskImplementation::getOccupationTime(RZState state) {
	return occupationTimes[state];
}

bool TaskImplementation::isValid(void) {
	return valid;
}


//
// Mod impl stuff
//
rs_time TaskImplementation::getWorstCaseExecutionTime(void) const {
	return worst_case_execution_time;
}

rs_time TaskImplementation::getBestCaseExecutionTime(void) const {
	return best_case_execution_time;
}

double TaskImplementation::getFrequency(void) const {
	return frequency;
}

double TaskImplementation::getEnergyConsumption(void) const {
	return energy_consumption;
}

double TaskImplementation::getPidle(void) const {
	return p_idle;
}

double TaskImplementation::getPrun(void) const {
	return p_run;
}

void TaskImplementation::setWorstCaseExecutionTime(rs_time t) {
	worst_case_execution_time = t;
}

void TaskImplementation::setBestCaseExecutionTime(rs_time t) {
	best_case_execution_time = t;
}

void TaskImplementation::setFrequency(double f) {
	frequency = f;
}

void TaskImplementation::setEnergyConsumption(double e) {
	energy_consumption = e;
}

void TaskImplementation::setPidle(double e) {
	p_idle = e;
}

void TaskImplementation::setPrun(double e) {
	p_run = e;
}

void TaskImplementation::setNetlistName(string nm) {
	netlist_name = nm;
}

void TaskImplementation::setAlgorithmName(string nm) {
	algorithm_name = nm;
}
