/**
 * UNS - CNRS
 * Copyright 2013 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: licensing@sattse.com
 *
 * @file    rz_config.h
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0-build:2014/06/04
 * @date    November 6, 2015 11:59:55 AM CET
 * @section DESCRIPTION
 *
 *          RZ Properties
*/



#ifndef RZ_CONFIG_H
#define RZ_CONFIG_H

#include <string>
#include <set>
#include <map>

#include "config_param_group.h"
#include "config_processor.h"

using namespace std;

class RZ_config {

private:
	Config_param_group *param_group;
	Config_processor *cfg_processor;

public:

	RZ_config(Config_param_group *param_group_, Config_processor *cfg_processor_) {
		param_group = param_group_;
		cfg_processor = cfg_processor_;
	}
	
	RZ_config(Config_param_group *param_group_) {
		param_group = param_group_;
		cfg_processor = NULL;
	}

	RZ_config(Config_processor *cfg_processor_) {
		param_group = NULL;
		cfg_processor = cfg_processor_;
	}
	
	RZ_config(RZ_config& val) {
		param_group = val.param_group;
		cfg_processor = val.cfg_processor;
	}	

	Config_param_group* getConfigDomain() {
		return param_group;
	}

	Config_processor* getConfigProcessor() {
		return cfg_processor;
	}
	
	bool hasConfigDomain() {
		return param_group != NULL;
	}

	bool hasConfigProcessor() {
		return cfg_processor != NULL;
	}
	
	/* Static Part */

	static void initRZConfigTable(map<string, RZ_config*>& table) {

	}

};

#endif
