#ifndef __SHARED_LISTE__
#define __SHARED_LISTE__

#include <list>
#include <mutex>

template<typename T>
class SharedListe {
	private :
		mutex mtx;
		list<T> m_list;
	public :
		bool getElement(T* elem){
			int ret = false;
			mtx.lock();
			if (!m_list.empty()){
				ret = true;
				*elem = m_list.front();
				m_list.pop_front();
			}
			mtx.unlock();
			return ret;
		}
		void pushElement(T elem){
			mtx.lock();
			m_list.push_back(elem);
			mtx.unlock();
		}
};

#endif
