FORTRESS_HEADER

#ifndef RZ_CONFIG_H
#define RZ_CONFIG_H

#include <string>
#include <set>
#include <map>

#include "config_param_group.h"
#include "config_processor.h"

using namespace std;

class RZ_config {

private:
	Config_param_group *param_group;
	Config_processor *cfg_processor;

public:

	RZ_config(Config_param_group *param_group_, Config_processor *cfg_processor_) {
		param_group = param_group_;
		cfg_processor = cfg_processor_;
	}
	
	RZ_config(Config_param_group *param_group_) {
		param_group = param_group_;
		cfg_processor = NULL;
	}

	RZ_config(Config_processor *cfg_processor_) {
		param_group = NULL;
		cfg_processor = cfg_processor_;
	}
	
	RZ_config(RZ_config& val) {
		param_group = val.param_group;
		cfg_processor = val.cfg_processor;
	}	

	Config_param_group* getConfigDomain() {
		return param_group;
	}

	Config_processor* getConfigProcessor() {
		return cfg_processor;
	}
	
	bool hasConfigDomain() {
		return param_group != NULL;
	}

	bool hasConfigProcessor() {
		return cfg_processor != NULL;
	}
	
	/* Static Part */

	static void initRZConfigTable(map<string, RZ_config*>& table) {
FORTRESS_ADD_RZ_CONFIG_TABLE
	}

};

#endif
