FORTRESS_HEADER

#include <iostream>
#include <sstream>
#include <string>
#include <vector>
using namespace std;

#include "task.h"
#include "simulation.h"
#include "user_parameters.h"

int main(void) {

	cout << "=================================" << endl;
	cout << "=======   FoRTReSS Flow   =======" << endl;
	cout << "=================================" << endl << endl;

	Simulation simulation;
	simulation.displayParameters();

	vector<InterfaceLocation> interfacesVector;
	vector<HwTask> hwTasks;
	vector<SwTask> swTasks;
	set<string> modules;
	vector<Processor> processors;
	
	/* Generate Module name */
FORTRESS_ADD_MODULE
	
	/* Interface(s) on FPGA */
FORTRESS_INTERFACE_TYPES
FORTRESS_ADD_HW_NODE
	simulation.setHwTaskVector(hwTasks);
	simulation.setInterfaceVector(interfacesVector);
	simulation.setModuleSet(modules);
	
	/* Sw Nodes */
FORTRESS_ADD_SW_NODE
	simulation.setSwTaskVector(swTasks);
	
	/* Processor List */
FORTRESS_ADD_PROCESSORS	
	simulation.setProcessorVector(processors);
	
FORTRESS_ADD_PATH	
	/* Run Simulation */
	int flowReturnValue = simulation.launchArchGenFlow();
	
	if(flowReturnValue != 0)
		cerr << "ERROR: ArchGen flow exited abnormally !" << endl;

	return flowReturnValue;
}
