FORTRESS_HEADER

#ifndef DEVICE_H
#define DEVICE_H

#include <string>
#include <iostream>
#include <set>
#include <map>
#include <vector>

#include "coordinates.h"
#include "cell.h"

using namespace std;

/** Enumeration of the supported devices */
enum DeviceClass{UNDEF, Virtex5, Virtex6, Virtex7, Kintex7, Zynq7, Artix7, CUSTOM};
enum PositionConstraint{BEGIN, END, BOTH};

FORTRESS_ENUM_REF_CELL
FORTRESS_DECLARE_REF_CELL
FORTRESS_LINES_COLUMNS_DEVICE
FORTRESS_DEVICE_MODEL
FORTRESS_X_COORDINATE_MODEL
FORTRESS_POSITION_CONSTRAINT_MODEL
FORTRESS_DEVICE_RESSOURCE_CONSTANTS

class Device {

private:
	/* Device identification */
	string deviceID;
	string package;
	string speedGrade;
	DeviceClass deviceClass;

	/* Device description */
	RBType **RBTable;
	int nb_lines;
	int nb_columns;

	/* Map to retrieve a Cell from a RBType */
	map<RBType, Cell> deviceCellMap;
	
	/* Location restrictions */
	vector<Coordinates> restrictedColumns;

	/* Ressources: TO BE REMOVED LATER */
	int nb_LUT_Slice;
	int nb_FF_Slice;
	
public:
	/**
	 * Device Constructor. RBTable is an array of pointers, each
	 * pointing to the corresponding row in the FPGA representation
	 * array 
	 */
	Device() {
		FORTRESS_DEVICE_TYPE
		
		nb_lines = NB_LINES_DEVICE;
		nb_columns = NB_COLUMNS_DEVICE;
		RBTable = new RBType*[nb_lines];
		for(int i = 0; i < nb_lines; i++) RBTable[i] = (RBType *) fpga_device[i];
		/* Cell map init */
FORTRESS_CELL_MAP_INIT
		
		/* Ressources: TO BE REMOVED LATER */
		nb_LUT_Slice = NB_LUT_SLICE;
		nb_FF_Slice = NB_FF_SLICE;
		
		/* FPGA Static Constraints */
		FORTRESS_STATIC_CONSTRAINTS
	};

	~Device() {
		delete[] RBTable;
	}

	/* Getters */
	int getNbLines(void);
	int getNbColumns(void);
	string getDeviceID(void);
	string getDevicePackage(void);
	string getDeviceSpeedGrade(void);
	DeviceClass getDeviceClass(void);

	/* Cost getter */
	int getResourceCost(RBType rbtype);
	int getResourceCount(RBType rbt);

	/* RB/Cell methods */
	RBType getRB(int line, int column) const;
	RBType getColumnRBType(int column);
	bool isRBReconfigurable(RBType rbt);
	Cell getCell(RBType);
	string getCellName(RBType);
	RBType getRBType(string) const;
	map<RBType, Cell> getDeviceCellMap(void);

	/* LOC constraints */
	bool isColumnUsable(int line, int column);
	bool canColumnBeginRZ(int column);
	bool canColumnEndRZ(int column);

	/* UCF generation */
	int getPhysicalXCoordinate(int line, int column);

	/* Misc */
	void printDevice(void);


	/* TO BE REMOVED LATER: Techno-dependent stuff */
	int getNbLUTInSlice(void);
	int getNbFFInSlice(void);
};

#endif
