/**
 * UNS - CNRS
 * Copyright 2012 All Rights Reserved.
 *
 * These computer program listings and specifications, herein, are
 * the property of Universit de Nice Sophia-Antipolis (UNS) and Centre National
 * de la Recherche Scientifique (CNRS), and shall not be reproduced or
 * copied or used in whole or in part as the basis for manufacture
 * or sale of items without written permission.
 * For a license agreement, please contact: contact@sattse.com
 *
 * @file    generation_helper.cpp
 * @author  Francois Duhem (Francois.Duhem@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)
 *          University of Nice-Sophia Antipolis - LEAT/CNRS
 * @version 1.0
 * @date    2012-07-24
 * @section DESCRIPTION
 *			Some useful functions to ease code generation
 */

#include "generation_helper.h"

int get_module_position_in_vector(Manager_interface *mod, vector<Manager_interface *> &vec) {
	
	for(int i = 0; i < (int) vec.size(); i++) {
		if(vec.at(i) == mod) return i;
	}

	cerr << "ERROR: Cannot find module position in vector!" << endl;
	return -2;
}
