/*
 * Decompiled with CFR 0.152.
 */
package jfb.gmf.modulesystem.diagram.edit.commands;

import jfb.gmf.modulesystem.Connection;
import jfb.gmf.modulesystem.InterfaceBlock;
import jfb.gmf.modulesystem.diagram.edit.policies.ModulesystemBaseItemSemanticEditPolicy;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;

public class ConnectionReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;

    public ConnectionReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Connection)) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.oldEnd instanceof InterfaceBlock) || !(this.newEnd instanceof InterfaceBlock)) {
            return false;
        }
        InterfaceBlock target = this.getLink().getTarget_Block();
        return ModulesystemBaseItemSemanticEditPolicy.getLinkConstraints().canExistConnection_4001(this.getLink(), this.getNewSource(), target);
    }

    protected boolean canReorientTarget() {
        if (!(this.oldEnd instanceof InterfaceBlock) || !(this.newEnd instanceof InterfaceBlock)) {
            return false;
        }
        if (!(this.getLink().eContainer() instanceof InterfaceBlock)) {
            return false;
        }
        InterfaceBlock source = (InterfaceBlock)this.getLink().eContainer();
        return ModulesystemBaseItemSemanticEditPolicy.getLinkConstraints().canExistConnection_4001(this.getLink(), source, this.getNewTarget());
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        this.getOldSource().getTargetConnection().remove((Object)this.getLink());
        this.getNewSource().getTargetConnection().add((Object)this.getLink());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        this.getLink().setTarget_Block(this.getNewTarget());
        return CommandResult.newOKCommandResult((Object)this.getLink());
    }

    protected Connection getLink() {
        return (Connection)this.getElementToEdit();
    }

    protected InterfaceBlock getOldSource() {
        return (InterfaceBlock)this.oldEnd;
    }

    protected InterfaceBlock getNewSource() {
        return (InterfaceBlock)this.newEnd;
    }

    protected InterfaceBlock getOldTarget() {
        return (InterfaceBlock)this.oldEnd;
    }

    protected InterfaceBlock getNewTarget() {
        return (InterfaceBlock)this.newEnd;
    }
}

