/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.env.FortressEnv;
import fortress.xml.DevicePackage;
import fortress.xml.FortressDevice;
import fortress.xml.FortressDeviceLibrary;
import fortress.xml.TaskCellDescription;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

public class TaskDescription
extends FortressDevice {
    String DeviceName;
    String[] SpeedGrade;
    String[] DevicePackage;
    Vector<TaskCellDescription> TaskCellDescriptionList;

    public TaskDescription(FortressDeviceLibrary deviceLibrary, String filename) throws JDOMException, IOException {
        this.sxb = new SAXBuilder();
        if (FortressEnv.isSYRExtension(filename)) {
            this.loadSyrFormatFile(deviceLibrary, filename);
        } else {
            this.loadTaskCellDescription(filename);
        }
    }

    public String getDeviceName() {
        return this.DeviceName;
    }

    public String[] getSpeedGrade() {
        return this.SpeedGrade;
    }

    public String[] getDevicePackage() {
        return this.DevicePackage;
    }

    public Vector<TaskCellDescription> getTaskCellDescriptionList() {
        return this.TaskCellDescriptionList;
    }

    /*
     * Unable to fully structure code
     */
    void loadTaskCellDescription(String filename) throws JDOMException, IOException {
        root = this.loadFile(filename);
        this.DeviceName = this.getDeviceName(root);
        this.SpeedGrade = this.getSpeedGrade(root);
        this.DevicePackage = this.getDevicePackage(root);
        this.TaskCellDescriptionList = new Vector<E>();
        config_list = root.getChildren("Cell");
        i = config_list.iterator();
        if (i.hasNext()) ** GOTO lbl20
        throw new JDOMException("Error: No Cell Resource Found !");
lbl-1000:
        // 1 sources

        {
            el = (Element)i.next();
            cellName = el.getAttributeValue("name");
            if (cellName == null) {
                throw new JDOMException("Error: cell name not found !");
            }
            cellNumber = el.getAttributeValue("value");
            if (cellNumber == null) {
                throw new JDOMException("Error: value not found for " + cellName + " !");
            }
            cellNameInt = Integer.parseInt(cellNumber);
            this.TaskCellDescriptionList.add(new TaskCellDescription(cellName, cellNameInt));
lbl20:
            // 2 sources

            ** while (i.hasNext())
        }
lbl21:
        // 1 sources

    }

    public void loadSyrFormatFile(FortressDeviceLibrary deviceLibrary, String filename) throws JDOMException, FileNotFoundException, IOException {
        String read_line;
        FileInputStream ips = new FileInputStream(filename);
        InputStreamReader ipsr = new InputStreamReader(ips);
        BufferedReader br = new BufferedReader(ipsr);
        int SliceReg = 0;
        int SliceLut = 0;
        int SliceM = 0;
        int DSP = 0;
        int BRAM = 0;
        int IOB = 0;
        while ((read_line = br.readLine()) != null) {
            if (read_line.contains("Target Device")) {
                String[] word = read_line.split(":");
                String fullDeviceName = word[1].trim();
                word = fullDeviceName.split("-");
                this.DeviceName = word[0].trim();
                this.SpeedGrade = new String[1];
                this.SpeedGrade[0] = word[1].trim();
                this.DevicePackage = new String[1];
                this.DevicePackage[0] = word[2].trim();
                continue;
            }
            if (read_line.contains("Number of Slice Registers:")) {
                SliceReg += this.getTaskCellNumber(read_line);
                continue;
            }
            if (read_line.contains("Number of Slice LUTs:")) {
                SliceLut += this.getTaskCellNumber(read_line);
                continue;
            }
            if (read_line.contains("Number used as Memory:")) {
                SliceM += this.getTaskCellNumber(read_line);
                continue;
            }
            if (read_line.contains("Number of DSP48E1s:")) {
                DSP += this.getTaskCellNumber(read_line);
                continue;
            }
            if (read_line.contains("Number of Block RAM/FIFO:")) {
                BRAM += this.getTaskCellNumber(read_line);
                continue;
            }
            if (!read_line.contains("Number of bonded IOBs:")) continue;
            IOB += this.getTaskCellNumber(read_line);
        }
        this.TaskCellDescriptionList = new Vector();
        DevicePackage dp = deviceLibrary.getDevicePackage(this.DeviceName);
        if (dp == null) {
            throw new JDOMException("No Device Found : " + this.DeviceName);
        }
        int Slice = Math.max(SliceReg /= dp.getFFSliceNumber(), SliceLut /= dp.getLutSliceNumber());
        if (Slice != 0) {
            this.TaskCellDescriptionList.add(new TaskCellDescription("Slice", Slice));
        }
        if (SliceM != 0) {
            this.TaskCellDescriptionList.add(new TaskCellDescription("SliceM", SliceM));
        }
        if (DSP != 0) {
            this.TaskCellDescriptionList.add(new TaskCellDescription("DSP", DSP));
        }
        if (BRAM != 0) {
            this.TaskCellDescriptionList.add(new TaskCellDescription("BRAM", BRAM));
        }
        if (IOB != 0) {
            this.TaskCellDescriptionList.add(new TaskCellDescription("IOB", IOB));
        }
    }

    private int getTaskCellNumber(String read_line) {
        String[] word = read_line.split(":");
        String value = word[1].trim();
        word = value.split(" ");
        return Integer.parseInt(word[0].trim());
    }

    public String toString() {
        String buf = String.valueOf(this.DeviceName) + " [";
        int i = 0;
        while (i < this.TaskCellDescriptionList.size()) {
            TaskCellDescription tcd = this.TaskCellDescriptionList.elementAt(i);
            buf = i == 0 ? String.valueOf(buf) + tcd.toString() : String.valueOf(buf) + ", " + tcd.toString();
            ++i;
        }
        return String.valueOf(buf) + "]";
    }
}

