/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.env.FortressEnv;
import fortress.xml.FortressXMLBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class FortressProject
extends FortressXMLBuilder {
    final int MAX_RECENT_PROJECT = 10;

    public FortressProject() throws JDOMException, IOException {
        this.loadFile();
    }

    public void loadFile() throws JDOMException, IOException {
        File f = new File(FortressEnv.getProjectFile());
        if (!f.exists()) {
            f = new File(FortressEnv.getDefaultProjectFile());
        }
        this.doc = this.sxb.build(f);
        this.root = this.doc.getRootElement();
    }

    public void loadDefaultFile() throws JDOMException, IOException {
        File f = new File(FortressEnv.getDefaultProjectFile());
        this.doc = this.sxb.build(f);
        this.root = this.doc.getRootElement();
    }

    public void saveFile() throws JDOMException, IOException {
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        xmlOutput.output(this.doc, (Writer)new FileWriter(FortressEnv.getProjectFile()));
    }

    public String getCurrentProjectPath() throws JDOMException {
        Vector<String> v = this.getProjectPath();
        if (v.size() > 0) {
            return v.elementAt(v.size() - 1);
        }
        return "";
    }

    public Vector<String> getProjectPath() throws JDOMException {
        Vector<String> list = new Vector<String>();
        List path_list = this.root.getChildren("Projects");
        Iterator i = path_list.iterator();
        if (!i.hasNext()) {
            return list;
        }
        Element el2 = (Element)i.next();
        path_list = el2.getChildren("PRJ");
        for (Element el2 : path_list) {
            String val = el2.getAttributeValue("path");
            list.add(new String(val));
        }
        return list;
    }

    public void addProjectPath(String path) throws JDOMException {
        Vector<String> actual_list = this.getProjectPath();
        List path_list = this.root.getChildren("Projects");
        Iterator i = path_list.iterator();
        if (!i.hasNext()) {
            Element elp = new Element("Projects");
            path_list.add(elp);
            path_list = this.root.getChildren("Projects");
            i = path_list.iterator();
        }
        Element el = (Element)i.next();
        path_list = el.getChildren("PRJ");
        while (!path_list.isEmpty()) {
            path_list.remove(0);
        }
        actual_list.remove(path);
        actual_list.add(path);
        while (actual_list.size() > 10) {
            actual_list.remove(0);
        }
        path_list = this.root.getChildren("Projects");
        i = path_list.iterator();
        el = (Element)i.next();
        path_list = el.getChildren("PRJ");
        int j = 0;
        while (j < actual_list.size()) {
            path_list.add(new Element("PRJ").setAttribute("path", actual_list.elementAt(j)));
            ++j;
        }
    }
}

