/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.env.FortressEnv;
import fortress.xml.ConfigApplication;
import fortress.xml.ConfigProcessor;
import fortress.xml.DevicePackage;
import fortress.xml.FPGAConstraints;
import fortress.xml.FPGAInterfaceConstraints;
import fortress.xml.FPGAStaticConstraints;
import fortress.xml.FortressDeviceLibrary;
import fortress.xml.FortressSystem;
import fortress.xml.FortressXMLBuilder;
import fortress.xml.RessourceCost;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class FortressConfiguration
extends FortressXMLBuilder {
    public static String PLANAHEAD_IMPLEMENTATION = "PlanAhead implementation";
    public static String FINAL_PLANAHEAD_VERIFICATION = "Final PlanAhead verification";
    public static String NONE = "None";
    public static String FPGA_INTERFACE_POSITION_DONT_CARE = "DONT_CARE";
    public static String FPGA_INTERFACE_POSITION_NORTH = "NORTH";
    public static String FPGA_INTERFACE_POSITION_NORTHEAST = "NORTHEAST";
    public static String FPGA_INTERFACE_POSITION_EAST = "EAST";
    public static String FPGA_INTERFACE_POSITION_SOUTHEAST = "SOUTHEAST";
    public static String FPGA_INTERFACE_POSITION_SOUTH = "SOUTH";
    public static String FPGA_INTERFACE_POSITION_WEST = "WEST";
    public static String FPGA_INTERFACE_POSITION_NORTHWEST = "NORTHWEST";
    public static String FPGA_STATIC_CONSTRAINTS = "Static";
    public static String FPGA_INTERFACE_CONSTRAINTS = "Interface";

    public void loadFile(String config) throws JDOMException, IOException {
        File f = new File(FortressEnv.getConfigurationFile(config));
        if (!f.exists()) {
            f = new File(FortressEnv.getDefaultConfigurationFile());
        }
        this.doc = this.sxb.build(f);
        this.root = this.doc.getRootElement();
    }

    public void loadDefaultFile() throws JDOMException, IOException {
        File f = new File(FortressEnv.getDefaultConfigurationFile());
        this.doc = this.sxb.build(f);
        this.root = this.doc.getRootElement();
    }

    public void saveFile(String config) throws JDOMException, IOException {
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        FortressEnv.createConfigurationPath(config);
        FileWriter fw = new FileWriter(FortressEnv.getConfigurationFile(config));
        xmlOutput.output(this.doc, (Writer)fw);
        fw.close();
    }

    public boolean equals(FortressConfiguration conf) throws JDOMException {
        boolean eq = this.getSelectedDevice().equals(conf.getSelectedDevice());
        eq &= this.getSelectedDevicePackage().equals(conf.getSelectedDevicePackage());
        eq &= this.getSelectedSpeedGrade().equals(conf.getSelectedSpeedGrade());
        eq &= this.isDefaultCost() == conf.isDefaultCost();
        eq &= this.ressourceCostEquals(conf);
        eq &= this.useRZSet() == conf.useRZSet();
        eq &= this.getRZSetDescriptionFilename().equals(conf.getRZSetDescriptionFilename());
        eq &= this.getAllowPurelyReconfigurableRZ() == conf.getAllowPurelyReconfigurableRZ();
        eq &= this.getAllowRectangularRZ() == conf.getAllowRectangularRZ();
        eq &= this.getOversizedRzTrigger().equals(conf.getOversizedRzTrigger());
        eq &= this.getResourcesMargin().equals(conf.getResourcesMargin());
        eq &= this.getShapeWeight().equals(conf.getShapeWeight());
        eq &= this.getComplianceWeight().equals(conf.getComplianceWeight());
        eq &= this.getInternalFragmentationWeight().equals(conf.getInternalFragmentationWeight());
        eq &= this.getCheckRZRedundancy() == conf.getCheckRZRedundancy();
        eq &= this.getImplementationMetric().equals(conf.getImplementationMetric());
        eq &= this.getTriggerFactorUnacceptable().equals(conf.getTriggerFactorUnacceptable());
        eq &= this.getTriggerFactorOptimum().equals(conf.getTriggerFactorOptimum());
        eq &= this.getMarginBetweenRZ().equals(conf.getMarginBetweenRZ());
        eq &= this.getPlanAheadImplementation().equals(conf.getPlanAheadImplementation());
        eq &= this.getCompressionRate().equals(conf.getCompressionRate());
        eq &= this.getTbus().equals(conf.getTbus());
        eq &= this.getTicap().equals(conf.getTicap());
        eq &= this.getNburst().equals(conf.getNburst());
        eq &= this.getTburst().equals(conf.getTburst());
        eq &= this.getLatency().equals(conf.getLatency());
        eq &= this.getFIFODepth().equals(conf.getFIFODepth());
        eq &= this.hasAllDependenciesRequiredBeforeRequest() == conf.hasAllDependenciesRequiredBeforeRequest();
        eq &= this.getSchedulerQueueStrategy().equals(conf.getSchedulerQueueStrategy());
        eq &= this.getSchedulerStrategy().equals(conf.getSchedulerStrategy());
        eq &= this.getSchedulerExecutionTime().equals(conf.getSchedulerExecutionTime());
        eq &= this.getSchedulerPerformanceEffort() == conf.getSchedulerPerformanceEffort();
        eq &= this.getSchedulerAreaEffort() == conf.getSchedulerAreaEffort();
        eq &= this.getSchedulerEnergyEffort() == conf.getSchedulerEnergyEffort();
        eq &= this.getSchedulerEnergyConsumption().equals(conf.getSchedulerEnergyConsumption());
        eq &= this.getEnergyConsumptionLimit().equals(conf.getEnergyConsumptionLimit());
        eq &= this.getHwReconfigurationUnits() == conf.getHwReconfigurationUnits();
        eq &= this.getSwReconfigurationUnits() == conf.getSwReconfigurationUnits();
        eq &= Double.parseDouble(this.getMaximumSimulationTime()) == Double.parseDouble(conf.getMaximumSimulationTime());
        eq &= this.getTraceWindowFunctionLength() == conf.getTraceWindowFunctionLength();
        eq &= this.hasHyperperiodAutomaticComputation() == conf.hasHyperperiodAutomaticComputation();
        eq &= this.getOffsetTime() == conf.getOffsetTime();
        eq &= this.getHyperperiodTime() == conf.getHyperperiodTime();
        eq &= this.getGenerateZeroFilledLineInCSV() == conf.getGenerateZeroFilledLineInCSV();
        eq &= this.isDebugTrace() == conf.isDebugTrace();
        eq &= this.isModuleModeSignalTrace() == conf.isModuleModeSignalTrace();
        eq &= this.isRunSimulationUntilStaticSolution() == conf.isRunSimulationUntilStaticSolution();
        eq &= this.configProcessorListEquals(conf);
        eq &= this.configApplicationListEquals(conf);
        return eq &= this.tableFPGAConstraintsEquals(conf);
    }

    public boolean tableFPGAConstraintsEquals(FortressConfiguration conf) throws JDOMException {
        FPGAConstraints[][] own = conf.getTableFPGAConstraints();
        FPGAConstraints[][] list = this.getTableFPGAConstraints();
        if (list.length != own.length) {
            return false;
        }
        int i = 0;
        while (i < list.length) {
            if (list[i].length != own[i].length) {
                return false;
            }
            int j = 0;
            while (j < list[i].length) {
                FPGAConstraints el = list[i][j];
                if (el != null || own[i][j] != null) {
                    if (el != null && own[i][j] == null) {
                        return false;
                    }
                    if (el == null && own[i][j] != null) {
                        return false;
                    }
                    if (el != null && own[i][j] != null && !el.equals(own[i][j])) {
                        return false;
                    }
                }
                ++j;
            }
            ++i;
        }
        return true;
    }

    public boolean configApplicationListEquals(FortressConfiguration conf) throws JDOMException {
        Vector<ConfigApplication> own = conf.getConfigApplicationList();
        Vector<ConfigApplication> list = this.getConfigApplicationList();
        if (list.size() != own.size()) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            ConfigApplication cfgApp = list.elementAt(i);
            if (!cfgApp.identical(own.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean configProcessorListEquals(FortressConfiguration conf) throws JDOMException {
        Vector<ConfigProcessor> own = conf.getConfigProcessorList();
        Vector<ConfigProcessor> list = this.getConfigProcessorList();
        if (list.size() != own.size()) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            ConfigProcessor cfgProc = list.elementAt(i);
            if (!cfgProc.identical(own.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean ressourceCostEquals(FortressConfiguration conf) throws JDOMException {
        Vector<RessourceCost> rc = conf.getRessourceCostList();
        Vector<RessourceCost> own = this.getRessourceCostList();
        if (rc.size() != own.size()) {
            return false;
        }
        int i = 0;
        while (i < rc.size()) {
            if (!own.elementAt(i).equals(rc.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void duplicateConfigurationFile(String current_config, String new_config) throws JDOMException, IOException {
        FortressConfiguration fc = new FortressConfiguration();
        fc.loadFile(current_config);
        fc.saveFile(new_config);
    }

    public static Vector<String> parseFPGAInterfaceType(String type_if) {
        Vector<String> v = new Vector<String>();
        if (type_if.trim().length() == 0) {
            return v;
        }
        String[] word_if = type_if.split("&");
        int i = 0;
        while (i < word_if.length) {
            String bus = word_if[i].trim();
            if (bus.isEmpty()) {
                return null;
            }
            v.add(word_if[i].trim());
            ++i;
        }
        return v;
    }

    public static Vector<String> getFPGAInterfacePositionList() {
        Vector<String> v = new Vector<String>();
        v.add(FPGA_INTERFACE_POSITION_DONT_CARE);
        v.add(FPGA_INTERFACE_POSITION_NORTH);
        v.add(FPGA_INTERFACE_POSITION_NORTHEAST);
        v.add(FPGA_INTERFACE_POSITION_EAST);
        v.add(FPGA_INTERFACE_POSITION_SOUTHEAST);
        v.add(FPGA_INTERFACE_POSITION_SOUTH);
        v.add(FPGA_INTERFACE_POSITION_WEST);
        v.add(FPGA_INTERFACE_POSITION_NORTHWEST);
        return v;
    }

    public Vector<FPGAConstraints> getFPGAInterfaceConstraints() throws JDOMException {
        return this.getFPGAConstraints(FPGA_INTERFACE_CONSTRAINTS);
    }

    public Vector<FPGAConstraints> getFPGAStaticConstraints() throws JDOMException {
        return this.getFPGAConstraints(FPGA_STATIC_CONSTRAINTS);
    }

    private Vector<FPGAConstraints> getFPGAConstraints(String fpgaConstraints) throws JDOMException {
        String row;
        Vector<FPGAConstraints> list = new Vector<FPGAConstraints>();
        List lc_List = this.root.getChildren("FPGAConstraints");
        Iterator i = lc_List.iterator();
        if (!i.hasNext()) {
            return list;
        }
        Element all = (Element)i.next();
        lc_List = all.getChildren(String.valueOf(fpgaConstraints) + "_RB");
        for (Element el : lc_List) {
            row = el.getAttributeValue("Row");
            String col = el.getAttributeValue("Col");
            if (fpgaConstraints.equals(FPGA_STATIC_CONSTRAINTS)) {
                list.add(new FPGAStaticConstraints(row, col));
                continue;
            }
            String type = el.getAttributeValue("Type");
            String pos = el.getAttributeValue("Pos");
            list.add(new FPGAInterfaceConstraints(row, col, type, pos));
        }
        lc_List = all.getChildren(String.valueOf(fpgaConstraints) + "_Range_RB");
        for (Element el : lc_List) {
            row = el.getAttributeValue("Row");
            String colMin = el.getAttributeValue("ColMin");
            String colMax = el.getAttributeValue("ColMax");
            if (fpgaConstraints.equals(FPGA_STATIC_CONSTRAINTS)) {
                list.add(new FPGAStaticConstraints(row, colMin, colMax));
                continue;
            }
            String type = el.getAttributeValue("Type");
            String pos = el.getAttributeValue("Pos");
            list.add(new FPGAInterfaceConstraints(row, colMin, colMax, type, pos));
        }
        return list;
    }

    public FPGAConstraints[][] getTableFPGAConstraints() throws JDOMException {
        int j;
        FPGAConstraints fc;
        FortressDeviceLibrary lib = FortressEnv.getFortressDeviceLibrary();
        DevicePackage devicePkg = lib.getDevicePackage(this.getSelectedDevice());
        if (devicePkg == null) {
            throw new JDOMException("No Device Found : " + this.getSelectedDevice());
        }
        FPGAConstraints[][] area = new FPGAConstraints[devicePkg.getLineNumber()][devicePkg.getColumnNumber()];
        int i = 0;
        while (i < devicePkg.getLineNumber()) {
            int j2 = 0;
            while (j2 < devicePkg.getColumnNumber()) {
                area[i][j2] = null;
                ++j2;
            }
            ++i;
        }
        Vector<FPGAConstraints> fpga_constraints = this.getFPGAStaticConstraints();
        int i2 = 0;
        while (i2 < fpga_constraints.size()) {
            fc = (FPGAStaticConstraints)fpga_constraints.elementAt(i2);
            if (fc.isRB()) {
                area[fc.getRow()][fc.getColumn()] = new FPGAStaticConstraints(fc);
            } else {
                j = fc.getColumn();
                while (j < fc.getColumnMax()) {
                    area[fc.getRow()][j] = new FPGAStaticConstraints(fc.getRow(), j);
                    ++j;
                }
            }
            ++i2;
        }
        fpga_constraints = this.getFPGAInterfaceConstraints();
        i2 = 0;
        while (i2 < fpga_constraints.size()) {
            fc = (FPGAInterfaceConstraints)fpga_constraints.elementAt(i2);
            if (fc.isRB()) {
                area[fc.getRow()][fc.getColumn()] = new FPGAInterfaceConstraints((FPGAInterfaceConstraints)fc);
            } else {
                j = fc.getColumn();
                while (j < fc.getColumnMax()) {
                    area[fc.getRow()][j] = new FPGAInterfaceConstraints(fc.getRow(), j, ((FPGAInterfaceConstraints)fc).getInterfaceType(), ((FPGAInterfaceConstraints)fc).getPosition());
                    ++j;
                }
            }
            ++i2;
        }
        return area;
    }

    public void setFPGAConstraints(FPGAConstraints[][] area) throws JDOMException {
        this.removeAllFPGAConstraints();
        int row = 0;
        while (row < area.length) {
            int col = 0;
            int max = area[row].length;
            while (col < max) {
                if (area[row][col] instanceof FPGAStaticConstraints) {
                    int diff;
                    int colmax = col + 1;
                    while (colmax < max) {
                        if (!(area[row][colmax] instanceof FPGAStaticConstraints)) break;
                        ++colmax;
                    }
                    FPGAStaticConstraints lc = (diff = colmax - col) == 1 ? new FPGAStaticConstraints(row, col) : new FPGAStaticConstraints(row, col, colmax);
                    col += diff;
                    this.addFPGAStaticConstraints(lc);
                    continue;
                }
                if (area[row][col] instanceof FPGAInterfaceConstraints) {
                    int diff;
                    FPGAInterfaceConstraints fic_col = (FPGAInterfaceConstraints)area[row][col];
                    int colmax = col + 1;
                    while (colmax < max) {
                        FPGAInterfaceConstraints fic_max;
                        if (!(area[row][colmax] instanceof FPGAInterfaceConstraints) || !fic_col.equals_Pos_TypeIf(fic_max = (FPGAInterfaceConstraints)area[row][colmax])) break;
                        ++colmax;
                    }
                    FPGAInterfaceConstraints lc = (diff = colmax - col) == 1 ? new FPGAInterfaceConstraints(fic_col) : new FPGAInterfaceConstraints(row, col, colmax, fic_col.getInterfaceType(), fic_col.getPosition());
                    col += diff;
                    this.addFPGAInterfaceConstraints(lc);
                    continue;
                }
                ++col;
            }
            ++row;
        }
    }

    public void addFPGAInterfaceConstraints(int col, int row) throws JDOMException {
        this.addFPGAInterfaceConstraints(new FPGAConstraints(col, row));
    }

    public void addFPGAInterfaceConstraints(FPGAConstraints lc) throws JDOMException {
        this.addFPGAConstraints(lc, FPGA_INTERFACE_CONSTRAINTS);
    }

    public void addFPGAStaticConstraints(int col, int row) throws JDOMException {
        this.addFPGAStaticConstraints(new FPGAConstraints(col, row));
    }

    public void addFPGAStaticConstraints(FPGAConstraints lc) throws JDOMException {
        this.addFPGAConstraints(lc, FPGA_STATIC_CONSTRAINTS);
    }

    private void addFPGAConstraints(FPGAConstraints lc, String fpgaConstraints) throws JDOMException {
        List lc_List = this.root.getChildren("FPGAConstraints");
        Iterator i = lc_List.iterator();
        if (!i.hasNext()) {
            Element elp = new Element("FPGAConstraints");
            lc_List.add(elp);
            lc_List = this.root.getChildren("FPGAConstraints");
            i = lc_List.iterator();
        }
        Element all = (Element)i.next();
        if (lc.isRB()) {
            lc_List = all.getChildren(String.valueOf(fpgaConstraints) + "_RB");
            if (!this.existsFPGAConstraints(lc)) {
                if (lc instanceof FPGAStaticConstraints) {
                    lc_List.add(new Element(String.valueOf(fpgaConstraints) + "_RB").setAttribute("Row", lc.getRowString()).setAttribute("Col", lc.getColumnString()));
                } else {
                    lc_List.add(new Element(String.valueOf(fpgaConstraints) + "_RB").setAttribute("Row", lc.getRowString()).setAttribute("Col", lc.getColumnString()).setAttribute("Pos", ((FPGAInterfaceConstraints)lc).getPosition()).setAttribute("Type", ((FPGAInterfaceConstraints)lc).getInterfaceType()));
                }
            }
        } else {
            lc_List = all.getChildren(String.valueOf(fpgaConstraints) + "_Range_RB");
            if (!this.existsFPGAConstraints(lc)) {
                if (lc instanceof FPGAStaticConstraints) {
                    lc_List.add(new Element(String.valueOf(fpgaConstraints) + "_Range_RB").setAttribute("Row", lc.getRowString()).setAttribute("ColMin", lc.getColumnString()).setAttribute("ColMax", lc.getColumnMaxString()));
                } else {
                    lc_List.add(new Element(String.valueOf(fpgaConstraints) + "_Range_RB").setAttribute("Row", lc.getRowString()).setAttribute("ColMin", lc.getColumnString()).setAttribute("ColMax", lc.getColumnMaxString()).setAttribute("Pos", ((FPGAInterfaceConstraints)lc).getPosition()).setAttribute("Type", ((FPGAInterfaceConstraints)lc).getInterfaceType()));
                }
            }
        }
    }

    public boolean removeFPGAInterfaceConstraints(int col, int row) throws JDOMException {
        return this.removeFPGAStaticConstraints(new FPGAConstraints(col, row));
    }

    public boolean removeFPGAInterfaceConstraints(FPGAConstraints lc) throws JDOMException {
        return this.removeFPGAConstraints(lc, FPGA_INTERFACE_CONSTRAINTS);
    }

    public boolean removeFPGAStaticConstraints(int col, int row) throws JDOMException {
        return this.removeFPGAStaticConstraints(new FPGAConstraints(col, row));
    }

    public boolean removeFPGAStaticConstraints(FPGAConstraints lc) throws JDOMException {
        return this.removeFPGAConstraints(lc, FPGA_STATIC_CONSTRAINTS);
    }

    private boolean removeFPGAConstraints(FPGAConstraints lc, String fpgaConstraints) throws JDOMException {
        List lc_List = this.root.getChildren("FPGAConstraints");
        Iterator i = lc_List.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element all = (Element)i.next();
        if (lc.isRB()) {
            lc_List = all.getChildren(String.valueOf(fpgaConstraints) + "_RB");
            i = lc_List.iterator();
            int cpt = 0;
            while (i.hasNext()) {
                String col;
                Element el = (Element)i.next();
                String row = el.getAttributeValue("Row");
                if (lc.equals(new FPGAConstraints(row, col = el.getAttributeValue("Col")))) {
                    lc_List.remove(cpt);
                    return true;
                }
                ++cpt;
            }
        } else {
            lc_List = all.getChildren(String.valueOf(fpgaConstraints) + "_Range_RB");
            i = lc_List.iterator();
            int cpt = 0;
            while (i.hasNext()) {
                String colMax;
                String colMin;
                Element el = (Element)i.next();
                String row = el.getAttributeValue("Row");
                if (lc.equals(new FPGAConstraints(row, colMin = el.getAttributeValue("ColMin"), colMax = el.getAttributeValue("ColMax")))) {
                    lc_List.remove(cpt);
                    return true;
                }
                ++cpt;
            }
        }
        return false;
    }

    public void removeAllFPGAConstraints() throws JDOMException {
        List lc_List = this.root.getChildren("FPGAConstraints");
        Iterator i = lc_List.iterator();
        if (!i.hasNext()) {
            return;
        }
        Element all = (Element)i.next();
        lc_List = all.getChildren(String.valueOf(FPGA_STATIC_CONSTRAINTS) + "_RB");
        while (!lc_List.isEmpty()) {
            lc_List.remove(0);
        }
        lc_List = all.getChildren(String.valueOf(FPGA_STATIC_CONSTRAINTS) + "_Range_RB");
        while (!lc_List.isEmpty()) {
            lc_List.remove(0);
        }
        lc_List = all.getChildren(String.valueOf(FPGA_INTERFACE_CONSTRAINTS) + "_RB");
        while (!lc_List.isEmpty()) {
            lc_List.remove(0);
        }
        lc_List = all.getChildren(String.valueOf(FPGA_INTERFACE_CONSTRAINTS) + "_Range_RB");
        while (!lc_List.isEmpty()) {
            lc_List.remove(0);
        }
    }

    public boolean existsFPGAConstraints(int col, int row) throws JDOMException {
        return this.existsFPGAConstraints(new FPGAConstraints(col, row));
    }

    public boolean existsFPGAConstraints(FPGAConstraints lc) throws JDOMException {
        boolean result = this.existsFPGAConstraints(lc, FPGA_STATIC_CONSTRAINTS);
        if (!result) {
            result = this.existsFPGAConstraints(lc, FPGA_INTERFACE_CONSTRAINTS);
        }
        return result;
    }

    private boolean existsFPGAConstraints(FPGAConstraints lc, String fpgaConstraints) throws JDOMException {
        List taskList = this.root.getChildren("FPGAConstraints");
        Iterator i = taskList.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element all = (Element)i.next();
        if (lc.isRB()) {
            taskList = all.getChildren(String.valueOf(fpgaConstraints) + "_RB");
            for (Element el : taskList) {
                String row = el.getAttributeValue("Row");
                String col = el.getAttributeValue("Col");
                if (!lc.equals(new FPGAConstraints(col, row))) continue;
                return true;
            }
        } else {
            taskList = all.getChildren(String.valueOf(fpgaConstraints) + "_Range_RB");
            for (Element el : taskList) {
                String colMax;
                String colMin;
                String row = el.getAttributeValue("Row");
                if (!lc.equals(new FPGAConstraints(row, colMin = el.getAttributeValue("ColMin"), colMax = el.getAttributeValue("ColMax")))) continue;
                return true;
            }
        }
        return false;
    }

    public boolean useRZSet() throws JDOMException {
        return Boolean.parseBoolean(this.getValueWithDefaultValue("UseRZSet", "value", "false"));
    }

    public void setUseRZSet(boolean value) throws JDOMException {
        this.setValue("UseRZSet", "value", String.valueOf(value));
    }

    public String getRZSetDescriptionFilename() throws JDOMException {
        return this.getValueWithDefaultValue("RZSetDescriptionFilename", "value", "");
    }

    public void setRZSetDescriptionFilename(String value) throws JDOMException {
        this.setValue("RZSetDescriptionFilename", "value", value);
    }

    public String getSelectedFullDeviceName() throws JDOMException {
        return String.valueOf(this.getSelectedDevice()) + this.getSelectedDevicePackage() + this.getSelectedSpeedGrade();
    }

    public String getSelectedDevice() throws JDOMException {
        return this.getValue("SelectedDevice", "value");
    }

    public void setSelectedDevice(String value) throws JDOMException {
        this.setValue("SelectedDevice", "value", value);
    }

    public String getSelectedSpeedGrade() throws JDOMException {
        return this.getValue("SpeedGrade", "value");
    }

    public void setSpeedGrade(String value) throws JDOMException {
        this.setValue("SpeedGrade", "value", value);
    }

    public String getSelectedDevicePackage() throws JDOMException {
        return this.getValue("DevicePackage", "value");
    }

    public void setSelectedDevicePackage(String value) throws JDOMException {
        this.setValue("DevicePackage", "value", value);
    }

    public String getShapeWeight() throws JDOMException {
        return this.getValue("ShapeWeight", "value");
    }

    public void setShapeWeight(String value) throws JDOMException {
        this.setValue("ShapeWeight", "value", value);
    }

    public String getComplianceWeight() throws JDOMException {
        return this.getValue("ComplianceWeight", "value");
    }

    public void setComplianceWeight(String value) throws JDOMException {
        this.setValue("ComplianceWeight", "value", value);
    }

    public String getOversizedRzTrigger() throws JDOMException {
        return this.getValue("OversizedRzTrigger", "value");
    }

    public void setOversizedRzTrigger(String value) throws JDOMException {
        this.setValue("OversizedRzTrigger", "value", value);
    }

    public String getInternalFragmentationWeight() throws JDOMException {
        return this.getValue("InternalFragmentationWeight", "value");
    }

    public void setInternalFragmentationWeight(String value) throws JDOMException {
        this.setValue("InternalFragmentationWeight", "value", value);
    }

    public boolean getAllowRectangularRZ() throws JDOMException {
        return Boolean.parseBoolean(this.getValue("AllowRectangularRZ", "value"));
    }

    public void setAllowRectangularRZ(boolean value) throws JDOMException {
        this.setValue("AllowRectangularRZ", "value", String.valueOf(value));
    }

    public boolean getIgnoreRzPositionConstraints() throws JDOMException {
        return Boolean.parseBoolean(this.getValueWithDefaultValue("IgnoreRzPositionConstraints", "value", "true"));
    }

    public void setIgnoreRzPositionConstraints(boolean value) throws JDOMException {
        this.setValue("IgnoreRzPositionConstraints", "value", String.valueOf(value));
    }

    public boolean getAllowPurelyReconfigurableRZ() throws JDOMException {
        return Boolean.parseBoolean(this.getValueWithDefaultValue("AllowPurelyReconfigurableRZ", "value", "false"));
    }

    public void setAllowPurelyReconfigurableRZ(boolean value) throws JDOMException {
        this.setValue("AllowPurelyReconfigurableRZ", "value", String.valueOf(value));
    }

    public String getResourcesMargin() throws JDOMException {
        return this.getValueWithDefaultValue("ResourcesMargin", "value", "0");
    }

    public void setResourcesMargin(String value) throws JDOMException {
        this.setValue("ResourcesMargin", "value", value);
    }

    public boolean getCheckRZRedundancy() throws JDOMException {
        return Boolean.parseBoolean(this.getValue("CheckRZRedundancy", "value"));
    }

    public void setCheckRZRedundancy(boolean value) throws JDOMException {
        this.setValue("CheckRZRedundancy", "value", String.valueOf(value));
    }

    public String getImplementationMetric() throws JDOMException {
        return this.getValue("ImplementationMetric", "value");
    }

    public void setImplementationMetric(String value) throws JDOMException {
        this.setValue("ImplementationMetric", "value", value);
    }

    public static Vector<String> getImplementationMetricList() {
        Vector<String> v = new Vector<String>();
        v.add("EXTERNAL FRAGMENTATION");
        return v;
    }

    public String getTriggerFactorUnacceptable() throws JDOMException {
        return this.getValue("TriggerFactorUnacceptable", "value");
    }

    public void setTriggerFactorUnacceptable(String value) throws JDOMException {
        this.setValue("TriggerFactorUnacceptable", "value", value);
    }

    public String getTriggerFactorOptimum() throws JDOMException {
        return this.getValue("TriggerFactorOptimum", "value");
    }

    public void setTriggerFactorOptimum(String value) throws JDOMException {
        this.setValue("TriggerFactorOptimum", "value", value);
    }

    public String getMarginBetweenRZ() throws JDOMException {
        return this.getValue("MarginBetweenRZ", "value");
    }

    public void setMarginBetweenRZ(String value) throws JDOMException {
        this.setValue("MarginBetweenRZ", "value", value);
    }

    public String getRZAllocationStrategy() throws JDOMException {
        return this.getValue("AllocationStrategy", "value");
    }

    public void setRZAllocationStrategy(String value) throws JDOMException {
        this.setValue("AllocationStrategy", "value", value);
    }

    public static Vector<String> getRZAllocationStrategyList() {
        Vector<String> v = new Vector<String>();
        v.add("NO OPTIMIZATION");
        v.add("HIGHEST FRAGMENTATION");
        v.add("HIGHEST MEMORY COST");
        v.add("SHORTEST RUNTIME");
        return v;
    }

    public String getProcessorAllocationStrategy() throws JDOMException {
        return this.getValue("ProcessorAllocationStrategy", "value");
    }

    public static Vector<String> getProcessorAllocationStrategyList() {
        Vector<String> v = new Vector<String>();
        v.add("SOFT NO OPTIMIZATION");
        v.add("SOFT SHORTEST RUNTIME");
        return v;
    }

    public void setProcessorAllocationStrategy(String value) throws JDOMException {
        this.setValue("ProcessorAllocationStrategy", "value", value);
    }

    public String getPlanAheadImplementation() throws JDOMException {
        return this.getValueWithDefaultValue("PlanAheadImplementation", "value", NONE);
    }

    public void setPlanAheadImplementation(String value) throws JDOMException {
        this.setValue("PlanAheadImplementation", "value", value);
    }

    public static Vector<String> getPlanAheadImplementationList() {
        Vector<String> v = new Vector<String>();
        v.add(PLANAHEAD_IMPLEMENTATION);
        v.add(FINAL_PLANAHEAD_VERIFICATION);
        v.add(NONE);
        return v;
    }

    public String getCompressionRate() throws JDOMException {
        return this.getValueWithDefaultValue("CompressionRate", "value", "26.7");
    }

    public void setCompressionRate(String value) throws JDOMException {
        this.setValue("CompressionRate", "value", value);
    }

    public String getTbus() throws JDOMException {
        return this.getValueWithDefaultValue("Tbus", "value", "10");
    }

    public void setTbus(String value) throws JDOMException {
        this.setValue("Tbus", "value", value);
    }

    public String getTicap() throws JDOMException {
        return this.getValueWithDefaultValue("Ticap", "value", "10");
    }

    public void setTicap(String value) throws JDOMException {
        this.setValue("Ticap", "value", value);
    }

    public String getNburst() throws JDOMException {
        return this.getValueWithDefaultValue("Nburst", "value", "16");
    }

    public void setNburst(String value) throws JDOMException {
        this.setValue("Nburst", "value", value);
    }

    public String getTburst() throws JDOMException {
        return this.getValueWithDefaultValue("Tburst", "value", "48.2");
    }

    public void setTburst(String value) throws JDOMException {
        this.setValue("Tburst", "value", value);
    }

    public String getLatency() throws JDOMException {
        return this.getValueWithDefaultValue("Latency", "value", "10");
    }

    public void setLatency(String value) throws JDOMException {
        this.setValue("Latency", "value", value);
    }

    public String getFIFODepth() throws JDOMException {
        return this.getValueWithDefaultValue("FIFODepth", "value", "1024");
    }

    public void setFIFODepth(String value) throws JDOMException {
        this.setValue("FIFODepth", "value", value);
    }

    public String getSchedulerExecutionTime() throws JDOMException {
        return this.getValue("SchedulerExecutionTime", "value");
    }

    public void setSchedulerExecutionTime(String value) throws JDOMException {
        this.setValue("SchedulerExecutionTime", "value", value);
    }

    public String getEnergyConsumptionLimit() throws JDOMException {
        return this.getValue("EnergyConsumptionLimit", "value");
    }

    public void setEnergyConsumptionLimit(String value) throws JDOMException {
        this.setValue("EnergyConsumptionLimit", "value", value);
    }

    public boolean getGenerateZeroFilledLineInCSV() throws JDOMException {
        return Boolean.parseBoolean(this.getValue("GenerateZeroFilledLineInCSV", "value"));
    }

    public void setGenerateZeroFilledLineInCSV(boolean value) throws JDOMException {
        this.setValue("GenerateZeroFilledLineInCSV", "value", String.valueOf(value));
    }

    public boolean getGenerateAnalogSignalsInCSV() throws JDOMException {
        return Boolean.parseBoolean(this.getValueWithDefaultValue("GenerateAnalogSignalsInCSV", "value", "true"));
    }

    public void setGenerateAnalogSignalsInCSV(boolean value) throws JDOMException {
        this.setValue("GenerateAnalogSignalsInCSV", "value", String.valueOf(value));
    }

    public boolean getGenerateCommunicationsInCSV() throws JDOMException {
        return Boolean.parseBoolean(this.getValueWithDefaultValue("GenerateCommunicationsInCSV", "value", "true"));
    }

    public void setGenerateCommunicationsInCSV(boolean value) throws JDOMException {
        this.setValue("GenerateCommunicationsInCSV", "value", String.valueOf(value));
    }

    public boolean hasAllDependenciesRequiredBeforeRequest() throws JDOMException {
        return Boolean.parseBoolean(this.getValueWithDefaultValue("AllDependenciesRequiredBeforeRequest", "value", "false"));
    }

    public boolean isRunSimulationUntilStaticSolution() throws JDOMException {
        return Boolean.parseBoolean(this.getValueWithDefaultValue("RunSimulationUntilStaticSolution", "value", "false"));
    }

    public void setAllDependenciesRequiredBeforeRequest(boolean value) throws JDOMException {
        this.setValue("AllDependenciesRequiredBeforeRequest", "value", String.valueOf(value));
    }

    public void setRunSimulationUntilStaticSolution(boolean value) throws JDOMException {
        this.setValue("RunSimulationUntilStaticSolution", "value", String.valueOf(value));
    }

    public double getTraceWindowFunctionLength() throws JDOMException {
        return Double.parseDouble(this.getValueWithDefaultValue("TraceWindowFunctionLength", "value", "10000"));
    }

    public void setTraceWindowFunctionLength(double value) throws JDOMException {
        this.setValue("TraceWindowFunctionLength", "value", String.valueOf(value));
    }

    public boolean isDefaultCost() throws JDOMException {
        return Boolean.parseBoolean(this.getValue("Cost", "DefaultCost", "value"));
    }

    public void setDefaultCost(boolean value) throws JDOMException {
        this.setValue("Cost", "DefaultCost", "value", String.valueOf(value));
    }

    public String getCellCost(String cellName) throws JDOMException {
        return this.getValue("Cost", cellName, "value");
    }

    public void setCellCost(String cellName, String value) throws JDOMException {
        this.setValue("Cost", cellName, "value", value);
    }

    public boolean isDebugTrace() throws JDOMException {
        return Boolean.parseBoolean(this.getValue("DebugTrace", "value"));
    }

    public void setDebugTrace(boolean value) throws JDOMException {
        this.setValue("DebugTrace", "value", String.valueOf(value));
    }

    public boolean isModuleModeSignalTrace() throws JDOMException {
        return Boolean.parseBoolean(this.getValueWithDefaultValue("ModuleModeSignalSignalTrace", "value", "false"));
    }

    public void setModuleModeSignalTrace(boolean value) throws JDOMException {
        this.setValue("ModuleModeSignalSignalTrace", "value", String.valueOf(value));
    }

    public String getSchedulerEnergyConsumption() throws JDOMException {
        return this.getValue("SchedulerEnergyConsumption", "value");
    }

    public void setSchedulerEnergyConsumption(String value) throws JDOMException {
        this.setValue("SchedulerEnergyConsumption", "value", value);
    }

    public String getMaximumSimulationTime() throws JDOMException {
        return this.getValueWithDefaultValue("MaximumSimulationTime", "value", "120");
    }

    public void setMaximumSimulationTime(String value) throws JDOMException {
        this.setValue("MaximumSimulationTime", "value", value);
    }

    public int getHyperperiodNumberDisplayed() throws JDOMException {
        return Integer.parseInt(this.getValueWithDefaultValue("HyperperiodNumberDisplayed", "value", "3"));
    }

    public void setHyperperiodNumberDisplayed(int value) throws JDOMException {
        this.setValue("HyperperiodNumberDisplayed", "value", String.valueOf(value));
    }

    public String getSchedulerQueueStrategy() throws JDOMException {
        FortressSystem system = FortressEnv.getFortressSystem();
        return this.getValueWithDefaultValue("SchedulerQueueStrategy", "value", system.getDefaultSchedulerQueueStrategy());
    }

    public void setSchedulerQueueStrategy(String value) throws JDOMException {
        this.setValue("SchedulerQueueStrategy", "value", value);
    }

    public String getSchedulerStrategy() throws JDOMException {
        FortressSystem system = FortressEnv.getFortressSystem();
        return this.getValueWithDefaultValue("SchedulerStrategy", "value", system.getDefaultSchedulerStrategy());
    }

    public void setSchedulerStrategy(String value) throws JDOMException {
        this.setValue("SchedulerStrategy", "value", value);
    }

    public int getSchedulerPerformanceEffort() throws JDOMException {
        return Integer.parseInt(this.getValueWithDefaultValue("SchedulerPerformanceEffort", "value", "100"));
    }

    public void setSchedulerPerformanceEffort(int value) throws JDOMException {
        this.setValue("SchedulerPerformanceEffort", "value", String.valueOf(value));
    }

    public int getSchedulerEnergyEffort() throws JDOMException {
        return Integer.parseInt(this.getValueWithDefaultValue("SchedulerEnergyEffort", "value", "0"));
    }

    public void setSchedulerEnergyEffort(int value) throws JDOMException {
        this.setValue("SchedulerEnergyEffort", "value", String.valueOf(value));
    }

    public double getOffsetTime() throws JDOMException {
        return Double.parseDouble(this.getValueWithDefaultValue("OffsetTime", "value", "0"));
    }

    public void setHyperperiodAutomaticComputation(boolean value) throws JDOMException {
        this.setValue("HyperperiodAutomaticComputation", "value", String.valueOf(value));
    }

    public boolean hasHyperperiodAutomaticComputation() throws JDOMException {
        return Boolean.parseBoolean(this.getValueWithDefaultValue("HyperperiodAutomaticComputation", "value", "true"));
    }

    public void setOffsetTime(double value) throws JDOMException {
        this.setValue("OffsetTime", "value", String.valueOf(value));
    }

    public double getHyperperiodTime() throws JDOMException {
        return Double.parseDouble(this.getValueWithDefaultValue("HyperperiodTime", "value", "0"));
    }

    public void setHyperperiodTime(double value) throws JDOMException {
        this.setValue("HyperperiodTime", "value", String.valueOf(value));
    }

    public int getSchedulerAreaEffort() throws JDOMException {
        return Integer.parseInt(this.getValueWithDefaultValue("SchedulerAreaEffort", "value", "0"));
    }

    public void setSchedulerAreaEffort(int value) throws JDOMException {
        this.setValue("SchedulerAreaEffort", "value", String.valueOf(value));
    }

    public int getHwReconfigurationUnits() throws JDOMException {
        return Integer.parseInt(this.getValueWithDefaultValue("HwReconfigurationUnits", "value", "1"));
    }

    public void setHwReconfigurationUnits(int value) throws JDOMException {
        this.setValue("HwReconfigurationUnits", "value", String.valueOf(value));
    }

    public int getSwReconfigurationUnits() throws JDOMException {
        return Integer.parseInt(this.getValueWithDefaultValue("SwReconfigurationUnits", "value", "1"));
    }

    public void setSwReconfigurationUnits(int value) throws JDOMException {
        this.setValue("SwReconfigurationUnits", "value", String.valueOf(value));
    }

    public Vector<ConfigProcessor> getActiveConfigProcessorList() throws JDOMException {
        Vector<ConfigProcessor> procList = this.getConfigProcessorList();
        Vector<ConfigProcessor> actProcList = new Vector<ConfigProcessor>();
        int i = 0;
        while (i < procList.size()) {
            ConfigProcessor cfgProc = procList.elementAt(i);
            if (cfgProc.isActive()) {
                actProcList.add(cfgProc);
            }
            ++i;
        }
        Collections.sort(actProcList);
        return actProcList;
    }

    public Vector<RessourceCost> getRessourceCostList() throws JDOMException {
        Vector<RessourceCost> list = new Vector<RessourceCost>();
        List config_list = this.root.getChildren("Cost");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return list;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren();
        for (Element el2 : config_list) {
            String name = el2.getName();
            if (name.equals("DefaultCost")) continue;
            list.add(new RessourceCost(name, Integer.parseInt(el2.getAttributeValue("value"))));
        }
        Collections.sort(list);
        return list;
    }

    public Vector<ConfigProcessor> getConfigProcessorList() throws JDOMException {
        Vector<ConfigProcessor> list = new Vector<ConfigProcessor>();
        List config_list = this.root.getChildren("Processors");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return list;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("PR");
        for (Element el2 : config_list) {
            String name = el2.getAttributeValue("InstanceName");
            String type = el2.getAttributeValue("Type");
            String powerGroup = el2.getAttributeValue("PowerGroupName");
            if (powerGroup == null) {
                powerGroup = "";
            }
            String contextSwitchTime = el2.getAttributeValue("ContextSwitchTime");
            String interfaces = el2.getAttributeValue("Interfaces");
            boolean active = Boolean.parseBoolean(el2.getAttributeValue("Active"));
            list.add(new ConfigProcessor(name, type, contextSwitchTime, interfaces, active, powerGroup));
        }
        Collections.sort(list);
        return list;
    }

    public void addConfigProcessor(ConfigProcessor cp) throws JDOMException {
        List config_list = this.root.getChildren("Processors");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            Element elp = new Element("Processors");
            config_list.add(elp);
            config_list = this.root.getChildren("Processors");
            i = config_list.iterator();
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("PR");
        if (!this.existsConfigProcessor(cp)) {
            el = new Element("PR");
            el.setAttribute("InstanceName", cp.getInstanceName());
            el.setAttribute("Type", cp.getType());
            el.setAttribute("PowerGroupName", cp.getPowerGroupName());
            el.setAttribute("ContextSwitchTime", cp.getContextSwitchTime());
            el.setAttribute("Interfaces", cp.getInterfaces());
            el.setAttribute("Active", String.valueOf(cp.isActive()));
            config_list.add(el);
        }
    }

    public boolean updateConfigProcessor(String searchInstName, ConfigProcessor new_cp) throws JDOMException {
        List config_list = this.root.getChildren("Processors");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("PR");
        for (Element el2 : config_list) {
            String val = el2.getAttributeValue("InstanceName");
            if (!searchInstName.equals(val)) continue;
            el2.setAttribute("InstanceName", new_cp.getInstanceName());
            el2.setAttribute("Type", new_cp.getType());
            el2.setAttribute("PowerGroupName", new_cp.getPowerGroupName());
            el2.setAttribute("ContextSwitchTime", new_cp.getContextSwitchTime());
            el2.setAttribute("Interfaces", new_cp.getInterfaces());
            el2.setAttribute("Active", String.valueOf(new_cp.isActive()));
            return true;
        }
        return false;
    }

    public boolean removeConfigProcessor(ConfigProcessor cp) throws JDOMException {
        List config_list = this.root.getChildren("Processors");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("PR");
        i = config_list.iterator();
        int cpt = 0;
        while (i.hasNext()) {
            el = (Element)i.next();
            String val = el.getAttributeValue("InstanceName");
            if (val.equals(cp.getInstanceName())) {
                config_list.remove(cpt);
                return true;
            }
            ++cpt;
        }
        return false;
    }

    public boolean existsConfigProcessor(ConfigProcessor cp) throws JDOMException {
        Vector<ConfigProcessor> list = this.getConfigProcessorList();
        int i = 0;
        while (i < list.size()) {
            if (cp.equals(list.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean existsConfigProcessorInstanceName(String instName) throws JDOMException {
        Vector<ConfigProcessor> list = this.getConfigProcessorList();
        int i = 0;
        while (i < list.size()) {
            if (instName.equals(list.elementAt(i).getInstanceName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector<ConfigApplication> getConfigApplicationList() throws JDOMException {
        Vector<ConfigApplication> list = new Vector<ConfigApplication>();
        List config_list = this.root.getChildren("Applications");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return list;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("APP");
        for (Element el2 : config_list) {
            String file = el2.getAttributeValue("file");
            boolean local = Boolean.parseBoolean(el2.getAttributeValue("local"));
            String InstName = el2.getAttributeValue("InstanceName");
            boolean active = Boolean.parseBoolean(el2.getAttributeValue("active"));
            int QoS = Integer.parseInt(el2.getAttributeValue("QoS"));
            int EnergyConsumptionLimit = Integer.parseInt(el2.getAttributeValue("EnergyConsumptionLimit"));
            list.add(new ConfigApplication(file, local, InstName, active, QoS, EnergyConsumptionLimit));
        }
        Collections.sort(list);
        return list;
    }

    public Vector<ConfigApplication> getActiveConfigApplicationSchematicNameList() throws JDOMException {
        Vector<ConfigApplication> activeAppList = new Vector<ConfigApplication>();
        Vector<ConfigApplication> appList = this.getConfigApplicationList();
        int i = 0;
        while (i < appList.size()) {
            ConfigApplication cfgApp = appList.elementAt(i);
            if (cfgApp.isActive() && !cfgApp.isOnActiveFileList(activeAppList)) {
                activeAppList.add(cfgApp);
            }
            ++i;
        }
        return activeAppList;
    }

    public ConfigApplication getConfigApplication(String searchInstName) throws JDOMException {
        List config_list = this.root.getChildren("Applications");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return null;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("APP");
        for (Element el2 : config_list) {
            String instName = el2.getAttributeValue("InstanceName");
            if (!searchInstName.equals(instName)) continue;
            String file = el2.getAttributeValue("file");
            boolean local = Boolean.parseBoolean(el2.getAttributeValue("local"));
            boolean active = Boolean.parseBoolean(el2.getAttributeValue("active"));
            int QoS = Integer.parseInt(el2.getAttributeValue("QoS"));
            int EnergyConsumptionLimit = Integer.parseInt(el2.getAttributeValue("EnergyConsumptionLimit"));
            return new ConfigApplication(file, local, instName, active, QoS, EnergyConsumptionLimit);
        }
        return null;
    }

    public void addConfigApplication(ConfigApplication cp) throws JDOMException {
        List config_list = this.root.getChildren("Applications");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            Element elp = new Element("Applications");
            config_list.add(elp);
            config_list = this.root.getChildren("Applications");
            i = config_list.iterator();
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("APP");
        if (!this.existsConfigApplication(cp)) {
            el = new Element("APP");
            el.setAttribute("file", cp.getFile());
            el.setAttribute("active", String.valueOf(cp.isActive()));
            el.setAttribute("InstanceName", cp.getInstanceName());
            el.setAttribute("local", String.valueOf(cp.isLocal()));
            el.setAttribute("QoS", String.valueOf(cp.getQoS()));
            el.setAttribute("EnergyConsumptionLimit", String.valueOf(cp.getEnergyConsumptionLimit()));
            config_list.add(el);
        }
    }

    public boolean updateConfigApplication(String searchInstName, ConfigApplication new_cp) throws JDOMException {
        List config_list = this.root.getChildren("Applications");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("APP");
        for (Element el2 : config_list) {
            String val = el2.getAttributeValue("InstanceName");
            if (!searchInstName.equals(val)) continue;
            el2.setAttribute("file", new_cp.getFile());
            el2.setAttribute("active", String.valueOf(new_cp.isActive()));
            el2.setAttribute("InstanceName", new_cp.getInstanceName());
            el2.setAttribute("local", String.valueOf(new_cp.isLocal()));
            el2.setAttribute("QoS", String.valueOf(new_cp.getQoS()));
            el2.setAttribute("EnergyConsumptionLimit", String.valueOf(new_cp.getEnergyConsumptionLimit()));
            return true;
        }
        return false;
    }

    public String getFileName(String path) {
        int k = path.lastIndexOf(File.separator);
        String fdest = k == -1 ? path : path.substring(k + 1);
        return fdest.substring(0, fdest.lastIndexOf("."));
    }

    public boolean removeConfigApplication(String searchInstName) throws JDOMException {
        List config_list = this.root.getChildren("Applications");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("APP");
        i = config_list.iterator();
        int cpt = 0;
        while (i.hasNext()) {
            el = (Element)i.next();
            String val = el.getAttributeValue("InstanceName");
            if (searchInstName.equals(val)) {
                config_list.remove(cpt);
                return true;
            }
            ++cpt;
        }
        return false;
    }

    public boolean removeConfigApplication(ConfigApplication cp) throws JDOMException {
        return this.removeConfigApplication(cp.getInstanceName());
    }

    public boolean existsConfigApplication(ConfigApplication cp) throws JDOMException {
        Vector<ConfigApplication> list = this.getConfigApplicationList();
        int i = 0;
        while (i < list.size()) {
            if (cp.equals(list.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean existsConfigApplicationInstanceName(String instName) throws JDOMException {
        Vector<ConfigApplication> list = this.getConfigApplicationList();
        int i = 0;
        while (i < list.size()) {
            if (instName.equals(list.elementAt(i).getInstanceName())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public double computeReconfigurationTime(long bitstream_length_in_bytes) throws JDOMException {
        long bitstream_length = bitstream_length_in_bytes / 4L;
        double basic_latency = Double.parseDouble(this.getLatency());
        double Tbus = Double.parseDouble(this.getTbus());
        double burst_duration = Double.parseDouble(this.getTburst());
        double word_per_burst = Double.parseDouble(this.getNburst());
        double compress_ratio_g = 1.0 - Double.parseDouble(this.getCompressionRate()) / 100.0;
        double Twrite_icap = Double.parseDouble(this.getTicap());
        double Twrite_uncompress_max = basic_latency * Tbus + burst_duration * Tbus * Math.floor((double)bitstream_length * compress_ratio_g / word_per_burst) + (burst_duration - Math.IEEEremainder((double)bitstream_length * compress_ratio_g, word_per_burst)) * Tbus + (double)bitstream_length * (1.0 - compress_ratio_g) * Twrite_icap;
        return Twrite_uncompress_max / 1000.0;
    }

    public String getRZDefaultGroupName() throws JDOMException {
        return this.getValue("RZDefaultGroupName", "value");
    }

    public void setRZDefaultGroupName(String value) throws JDOMException {
        this.setValue("RZDefaultGroupName", "value", value);
    }
}

