/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import java.awt.Color;

public class DeviceCell {
    public static final String POSITION_CONSTRAINT_BOTH = "BOTH";
    public static final String POSITION_CONSTRAINT_BEGIN = "BEGIN";
    public static final String POSITION_CONSTRAINT_END = "END";
    String name;
    String description;
    boolean reconfigurable;
    int cost;
    int nbCellsPerColumn;
    int bitstreamSizePerColumn;
    int defaultIncrement;
    String group;
    boolean virtual;
    boolean marginSensitive;
    Color f_color;
    String positionConstraint;
    int X;
    int Y;

    public DeviceCell(String name, String description, boolean reconfigurable, int cost, int nbCellsPerColumn, int bitstreamSizePerColumn, int defaultIncrement, String group, Color f_color, boolean virtual, boolean marginSensitive) {
        this.name = name;
        this.description = description;
        this.reconfigurable = reconfigurable;
        this.cost = cost;
        this.nbCellsPerColumn = nbCellsPerColumn;
        this.bitstreamSizePerColumn = bitstreamSizePerColumn;
        this.defaultIncrement = defaultIncrement;
        this.group = group;
        this.f_color = f_color;
        this.virtual = virtual;
        this.marginSensitive = marginSensitive;
        this.positionConstraint = POSITION_CONSTRAINT_BOTH;
        this.X = -1;
        this.Y = -1;
    }

    public DeviceCell(DeviceCell cell) {
        this.name = cell.name;
        this.description = cell.description;
        this.reconfigurable = cell.reconfigurable;
        this.cost = cell.cost;
        this.nbCellsPerColumn = cell.nbCellsPerColumn;
        this.bitstreamSizePerColumn = cell.bitstreamSizePerColumn;
        this.defaultIncrement = cell.defaultIncrement;
        this.group = cell.group;
        this.f_color = cell.f_color;
        this.virtual = cell.virtual;
        this.marginSensitive = cell.marginSensitive;
        this.positionConstraint = cell.positionConstraint;
        this.X = cell.X;
        this.Y = cell.Y;
    }

    public boolean isMarginSensitive() {
        return this.marginSensitive;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public String getPositionConstraint() {
        return this.positionConstraint;
    }

    public void setPositionConstraint(String positionConstraint) {
        this.positionConstraint = positionConstraint;
    }

    public void setCoordonnate(int X, int Y) {
        this.X = X;
        this.Y = Y;
    }

    public Color getForegroundColor() {
        return this.f_color;
    }

    public int getX() {
        return this.X;
    }

    public int getY() {
        return this.Y;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        if (this.description == null) {
            return this.name;
        }
        return this.description;
    }

    public boolean isReconfigurable() {
        return this.reconfigurable;
    }

    public int getCost() {
        return this.cost;
    }

    public int getNbCellsPerColumn() {
        return this.nbCellsPerColumn;
    }

    public int getBitstreamSizePerColumn() {
        return this.bitstreamSizePerColumn;
    }

    public int getDefaultIncrement() {
        return this.defaultIncrement;
    }

    public boolean hasGroup() {
        return this.group != null;
    }

    public String getGroup() {
        return this.group;
    }

    public long computeBitstreamSize(int cellNumber, double margin) {
        double val = Math.ceil((double)cellNumber / (double)this.nbCellsPerColumn) * (double)this.bitstreamSizePerColumn;
        if (this.marginSensitive) {
            val += val * (margin / 100.0);
        }
        return (long)Math.ceil(val);
    }
}

