/*
 * Decompiled with CFR 0.152.
 */
package fortress.generation;

import fortress.env.FortressEnv;
import fortress.generation.CSVParser;
import fortress.xml.ConfigApplication;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressPreferences;
import fortress.xml.FortressSystem;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.jdom.JDOMException;

public class LatexTraceGeneration {
    FortressSystem system;
    String configuration;
    static double userScale = 10.0;
    static double constConvertTimeMS = 1.0E9;
    static double tikzScaleMS = 1.0 / userScale;
    static double constConvertTimeUS = constConvertTimeMS / 1000.0;
    static double tikzScaleUS = tikzScaleMS * 1000.0;
    static double constConvertTimeTikz = constConvertTimeMS * tikzScaleMS;
    static double xSteps = 50000.0 / userScale;

    public LatexTraceGeneration(String configuration) {
        this.configuration = configuration;
        this.system = FortressEnv.getFortressSystem();
    }

    public void Generate(OutputStream console) throws Exception {
        PrintStream out = new PrintStream(console);
        out.print("Loading Preferences ... ");
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        out.println("done");
        out.print("Loading Configuration ... ");
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(this.configuration);
        out.println("done");
        int hyperperiodNumberDisplayed = conf.getHyperperiodNumberDisplayed();
        userScale = 2000000.0 / ((double)conf.getHyperperiodNumberDisplayed() * conf.getHyperperiodTime());
        constConvertTimeMS = 1.0E9;
        tikzScaleMS = 1.0 / userScale;
        constConvertTimeUS = constConvertTimeMS / 1000.0;
        tikzScaleUS = tikzScaleMS * 1000.0;
        constConvertTimeTikz = constConvertTimeMS * tikzScaleMS;
        xSteps = 50000.0 / userScale;
        String csvPath = FortressEnv.getStatisticReportFilePath(this.configuration);
        Vector<String> csvfileList = FortressEnv.getFileListWithoutExtension(csvPath, ".csv");
        if (csvfileList.size() == 0) {
            out.println("Generating Latex Trace Report File : No Results");
        } else {
            out.println("Generating Latex Trace Report File(s) ...");
        }
        int i = 0;
        while (i < csvfileList.size()) {
            String csvfile = String.valueOf(csvPath) + csvfileList.elementAt(i) + ".csv";
            try {
                String[] parts;
                CSVParser csvparser = new CSVParser(csvfile);
                if (pref.isVerboseMode()) {
                    out.print("Generating Latex Trace Report File : " + csvfileList.elementAt(i) + "_trace.tex ... ");
                }
                String reportFile = FortressEnv.getLatexTraceReportFile(this.configuration, csvfileList.elementAt(i));
                FileOutputStream ops = new FileOutputStream(reportFile);
                Vector<String> RZList = csvparser.getRZList();
                Vector<String> coreList = csvparser.getProcessorList();
                String vcdFileName = String.valueOf(csvPath) + csvfileList.elementAt(i) + ".vcd";
                double HyperPeriod = csvparser.getApplicationHyperperiodInUs();
                double Offset = csvparser.getApplicationOffsetInUs();
                String schedulerStrategy = conf.getSchedulerQueueStrategy();
                String mapperStrategy = conf.getSchedulerStrategy();
                int procNumber = csvparser.getProcessorNumber();
                int RZNumber = csvparser.getRZNumber();
                Vector<ConfigApplication> listOfApplications = conf.getConfigApplicationList();
                String slicesNumber = "";
                if (RZNumber > 0 && (parts = csvparser.ImplStaticVersurPR.elementAt(1).toString().split(",")).length > 2) {
                    slicesNumber = parts[1];
                }
                double maxTime = 0.0;
                LatexTraceGeneration.addLatexFileHeader(ops);
                LatexTraceGeneration.addLatexSchedulerImageHeader(ops);
                int j = 0;
                while (j < RZList.size()) {
                    double currentTime = this.read(ops, RZList.elementAt(j), j, 0, vcdFileName, Offset + (double)hyperperiodNumberDisplayed * HyperPeriod);
                    if (currentTime > maxTime) {
                        maxTime = currentTime;
                    }
                    ++j;
                }
                j = 0;
                while (j < coreList.size()) {
                    double currentTime = this.read(ops, coreList.elementAt(j), j + RZList.size(), 1, vcdFileName, Offset + (double)hyperperiodNumberDisplayed * HyperPeriod);
                    if (currentTime > maxTime) {
                        maxTime = currentTime;
                    }
                    ++j;
                }
                out.print("maxtime: ");
                out.println(maxTime);
                LatexTraceGeneration.addLatexSchedulerImageAxis(ops, maxTime, HyperPeriod, coreList.size() + RZList.size(), csvfileList.elementAt(i));
                LatexTraceGeneration.addLatexSchedulerImageHyper(ops, maxTime, Offset, HyperPeriod, coreList.size() + RZList.size());
                boolean energyTraceAvailable = this.addLatexSchedulerImageEnergy(ops, maxTime, Offset, HyperPeriod, vcdFileName, coreList.size() + RZList.size(), csvfileList.elementAt(i), Offset + (double)hyperperiodNumberDisplayed * HyperPeriod);
                LatexTraceGeneration.addLatexSchedulerImageCaption(ops);
                LatexTraceGeneration.addLatexSimulationInformation(ops, schedulerStrategy, mapperStrategy, procNumber, RZNumber, listOfApplications, slicesNumber);
                LatexTraceGeneration.addLatexSchedulerImageFooter(ops);
                if (energyTraceAvailable) {
                    LatexTraceGeneration.addLatexPowerImageHeader(ops, maxTime);
                    this.getPowerFromVCD(ops, this.configuration, maxTime, HyperPeriod, vcdFileName, csvfileList.elementAt(i), Offset + (double)hyperperiodNumberDisplayed * HyperPeriod);
                    LatexTraceGeneration.addLatexPowerImageFooter(ops);
                }
                LatexTraceGeneration.addLatexFileFooter(ops);
                ops.flush();
                ((OutputStream)ops).close();
                if (pref.isVerboseMode()) {
                    out.print("Running pdflatex ... ");
                }
                LatexTraceGeneration.runPdfLatex(reportFile);
                if (pref.isVerboseMode()) {
                    out.println("done");
                }
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            ++i;
        }
    }

    private static void addLatexFileHeader(OutputStream console) throws IOException, JDOMException {
        PrintStream out = new PrintStream(console);
        out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        out.println("%");
        out.println("% Scheduler and power trace of FoRTReSS simulation ");
        out.println("% Latex file. Compile it with pdflatex tool.");
        out.println("% ");
        out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        out.println("% ");
        out.println("% University of Nice-Sophia Antipolis - LEAT/CNRS");
        out.println("% FoRTReSS Generation Flow");
        out.println("% Authors : Robin Bonamy (Robin.Bonamy@unice.fr), Fabrice Muller (Fabrice.Muller@unice.fr)");
        out.println("% 2014");
        out.println("% ");
        out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        out.println("");
        out.println("");
        out.println("");
        out.println("\\documentclass{article}");
        out.println("\\usepackage{tikz}");
        out.println("\\usepackage{verbatim}");
        out.println("\\usepackage[active,tightpage]{preview}");
        out.println("\\PreviewEnvironment{tikzpicture}");
        out.println("\\setlength\\PreviewBorder{10pt}");
        out.println("\\usetikzlibrary{chains}");
        out.println("\\usetikzlibrary{patterns}");
        out.println("\\usetikzlibrary{arrows,decorations.pathreplacing}");
        out.println("\\usepackage{amsmath}");
        out.println("\\usepackage{pgfplots}");
        out.println("\\usepackage{pgfplotstable}");
        out.println("\\pgfdeclarelayer{bg}    % declare background layer");
        out.println("\\pgfsetlayers{bg,main}  % set the order of the layers (main is the standard layer)");
        out.println("\\begin{document}");
        out.println("");
        out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        out.println("");
    }

    private static void addLatexSchedulerImageHeader(OutputStream console) throws IOException, JDOMException {
        PrintStream out = new PrintStream(console);
        out.println("\\begin{tikzpicture}[ \n scale=0.75,\n start chain=1 going below,\n start chain=2 going right,\n node distance=0mm,\n NodeTEXT/.style={scale=0.75,right}, ");
        out.println("Preemted/.style={,pattern=north west lines},");
        out.println("RUNNING/.style={\n %scale=0.75,\n on chain=2,\n rectangle,\n rounded corners=2pt,\n %draw=black,\n %very thin,\n text centered,\n %text width=5cm,\n minimum height=12mm,\n fill=blue!30\n },");
        out.println("IDLE/.style={\n fill=blue!10\n },");
        out.println("HWRUN/.style={\n fill=black!30!green!50\n },");
        out.println("MAPPED/.style={\n draw=black!10,\n fill=black!10\n },");
        out.println("RZ/.style={\n %scale=0.75,\n on chain=1,\n node distance=1mm,\n minimum height=12mm,\n minimum width=2cm,\n text centered\n},");
        out.println("Start/.style={\n %scale=0.75,\n on chain=2,\n text width=0cm,\n minimum height=12mm,\n text centered\n },");
        out.println("Config/.style={\n %scale=0.75,\n on chain=2,\n text width=0cm,\n minimum height=12mm,\n text centered,\n fill=red!30\n },");
        out.println("Running/.style={\n %scale=0.75,\n on chain=2,\n text width=0cm,\n minimum height=12mm,\n text centered,\n fill=blue!30\n },");
        out.println("Mapped/.style={\n %scale=0.75,\n on chain=2,\n text width=0cm,\n minimum height=12mm,\n text centered,\n fill=gray!30\n},");
        out.println("Active/.style={\n %scale=0.75,\n on chain=2,\n text width=0cm,\n minimum height=12mm,\n text centered,\n fill=gray!60\n },");
        out.println("waiting/.style={\n %scale=0.75,\n on chain=2,\n text width=0cm,\n minimum height=12mm,\ntext centered,\n fill=orange!30\n },");
        out.println("BLANK/.style={\n %scale=0.75,\n on chain=2,\n text width=0cm,\n minimum height=12mm,\n text centered,\n fill=white!30\n },");
        out.println("every node/.style={font=\\sffamily} \n ]");
        out.println("");
        out.println("%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%");
        out.println("");
    }

    private static void addLatexSchedulerImageCaption(OutputStream console) throws IOException, JDOMException {
        PrintStream out = new PrintStream(console);
        out.println("\\fill [RUNNING,BLANK,yshift=\\y, xshift=0, text width=80pt] (0,0) rectangle (80pt,40pt) node[pos=0.5] {\\scriptsize{CAPTION : }};");
        out.println("\\draw [RUNNING,BLANK,yshift=\\y, xshift=90, text width=80pt] (0,0) rectangle (80pt,40pt) node[pos=0.5] {\\scriptsize{BLANK}};");
        out.println("\\draw [RUNNING,Config,yshift=\\y, xshift=180, text width=80pt] (0,0) rectangle (80pt,40pt) node[pos=0.5] {\\scriptsize{Config}};");
        out.println("\\draw [RUNNING,Active,yshift=\\y, xshift=270, text width=80pt] (0,0) rectangle (110pt,40pt) node[pos=0.5] {\\scriptsize{Active \\\\(Waiting for data)}};");
        out.println("\\draw [RUNNING,Running,yshift=\\y, xshift=390, text width=80pt] (0,0) rectangle (80pt,40pt) node[pos=0.5] {\\scriptsize{SW Running}};");
        out.println("\\draw [RUNNING,Running, HWRUN,yshift=\\y, xshift=480, text width=80pt] (0,0) rectangle (80pt,40pt) node[pos=0.5] {\\scriptsize{HW Running}};");
        out.println("\\draw [RUNNING,Mapped,yshift=\\y, xshift=570, text width=80pt] (0,0) rectangle (80pt,40pt) node[pos=0.5] {\\scriptsize{Mapped \\\\(Finished)}};");
    }

    private static void addLatexSimulationInformation(OutputStream console, String schedulerStrategy, String mapperStrategy, int procNumber, int RZNumer, Vector<ConfigApplication> listOfApplications, String slicesNumber) throws IOException, JDOMException {
        PrintStream out = new PrintStream(console);
        out.print("\\node[NodeTEXT,yshift=40pt, xshift=-50pt,anchor=west] {\\small{Scheduler Strategy:} \\large{" + schedulerStrategy.replace("_", "\\_") + " }" + " \\small{Mapper Strategy:} \\large{" + mapperStrategy.replace("_", "\\_") + "}");
        if (procNumber > 1) {
            out.print(" \\large{  " + procNumber + "CPUs  } ");
        } else {
            out.print(" \\large{  " + procNumber + "CPU  } ");
        }
        if (RZNumer > 1) {
            out.print(" \\large{  " + RZNumer + "PRRs  } ");
        } else {
            out.print(" \\large{  " + RZNumer + "PRR }");
        }
        if (slicesNumber != "") {
            out.print(" \\large{(" + slicesNumber + " slices)  } ");
        }
        out.print(" \\large{ " + listOfApplications.elementAt(0).getFileName().replace("_", "\\_") + "}");
        int i = 1;
        while (i < listOfApplications.size()) {
            out.print("\\large{ | " + listOfApplications.elementAt(i).getFileName().replace("_", "\\_") + "}");
            ++i;
        }
        out.println("};");
    }

    private static void addLatexSchedulerImageFooter(OutputStream console) throws IOException, JDOMException {
        PrintStream out = new PrintStream(console);
        out.println("\\end{tikzpicture}");
    }

    private static void addLatexPowerImageHeader(OutputStream console, double maxTime) throws IOException, JDOMException {
        PrintStream out = new PrintStream(console);
        out.println("\\begin{tikzpicture}[scale=0.75,NodeTEXT/.style={scale=0.75,right},]");
        out.println("\\def\\maxx{" + maxTime / constConvertTimeUS / tikzScaleUS + "pt};");
        out.println("\\begin{axis}[enlarge x limits=false, xmin=0, ymin=0, height=210pt, width=\\maxx +45pt, legend entries={RECONF power,HW run power,HW idle power,HW static power, SW run power, SW idle power, SW static power},legend style={at={(-30pt,.6)},anchor=east},legend plot pos=left]");
    }

    private static void addLatexPowerImageFooter(OutputStream console) throws IOException, JDOMException {
        PrintStream out = new PrintStream(console);
        out.println("\\addplot+ [mark=none, draw=none,red!95!green!40, const plot, fill=red!95!green!40] table[ x=time, y expr=\\thisrow{cpu_static} + \\thisrow{cpu_idle} + \\thisrow{cpu_run} + \\thisrow{prr_static} + \\thisrow{prr_idle} +  \\thisrow{prr_run}+ \\thisrow{reconf} ]\\data\\closedcycle;");
        out.println("\\addplot+ [mark=none, draw=none,green!70!black!100, const plot, fill=green!70!black!100] table[ x=time, y expr=\\thisrow{cpu_static} + \\thisrow{cpu_idle} + \\thisrow{cpu_run} + \\thisrow{prr_static} + \\thisrow{prr_idle} +  \\thisrow{prr_run} ]\\data\\closedcycle;");
        out.println("\\addplot+ [mark=none, draw=none,green!70!black!60, const plot, fill=green!70!black!60] table[ x=time, y expr=\\thisrow{cpu_static} + \\thisrow{cpu_idle} + \\thisrow{cpu_run} + \\thisrow{prr_static} + \\thisrow{prr_idle} ]\\data\\closedcycle;");
        out.println("\\addplot+ [mark=none, draw=none,green!70!black!30, const plot, fill=green!70!black!30] table[ x=time, y expr=\\thisrow{cpu_static} + \\thisrow{cpu_idle} + \\thisrow{cpu_run} + \\thisrow{prr_static} ]\\data\\closedcycle;");
        out.println("\\addplot+ [mark=none, draw=none,blue!70!black!60, const plot, fill=blue!70!black!60] table[ x=time, y expr=\\thisrow{cpu_static} + \\thisrow{cpu_idle} + \\thisrow{cpu_run}]\\data\\closedcycle;");
        out.println("\\addplot+ [mark=none, solid, draw=none,blue!70!black!30, const plot, fill=blue!70!black!30] table[ x=time, y expr=\\thisrow{cpu_static} + \\thisrow{cpu_idle} ]\\data\\closedcycle;");
        out.println("\\addplot+ [mark=none, solid, draw=none,blue!70!black!20, const plot, fill=blue!70!black!20] table[ x=time, y expr=\\thisrow{cpu_static} ]\\data\\closedcycle;");
        out.println("\\addplot+ [mark=none, black, const plot] table[ x=time, y expr=\\thisrow{cpu_static} + \\thisrow{cpu_idle} + \\thisrow{cpu_run} + \\thisrow{prr_static} + \\thisrow{prr_idle} +  \\thisrow{prr_run}+ \\thisrow{reconf} ]\\data;");
        out.println("\\end{axis}");
        out.println("\\end{tikzpicture}");
    }

    private static void addLatexFileFooter(OutputStream console) throws IOException, JDOMException {
        PrintStream out = new PrintStream(console);
        out.println("\\end{document}");
    }

    private static void addLatexSchedulerImageAxis(OutputStream console, double maxTime, double HyperPeriod, double RZ_nb, String csvName) throws IOException, JDOMException {
        PrintStream out = new PrintStream(console);
        double i = 0.0;
        i = 0.0;
        while (i < maxTime / constConvertTimeUS) {
            out.println("\\draw (" + i / tikzScaleUS + "pt," + -(RZ_nb * 30.0) + "pt) node[below]{" + i / 1000.0 + "};");
            out.println("\\draw (" + i / tikzScaleUS + "pt," + -(RZ_nb * 30.0) + "pt) --  (" + i / tikzScaleUS + "pt," + -(RZ_nb * 30.0 - 10.0) + "pt);");
            i += xSteps;
        }
        out.println("\\draw (" + i / tikzScaleUS + "pt," + -(RZ_nb * 30.0) + "pt) node[below]{" + i / 1000.0 + " ms};");
        out.println("\\draw (" + i / tikzScaleUS + "pt," + -(RZ_nb * 30.0) + "pt) --  (" + i / tikzScaleUS + "pt," + -(RZ_nb * 30.0 - 10.0) + "pt);");
        out.println("\\draw[->] (0pt," + -(RZ_nb * 30.0 - 10.0) + "pt) -- (" + (maxTime / constConvertTimeUS / tikzScaleUS + 5.0) + "pt," + -(RZ_nb * 30.0 - 10.0) + "pt);");
        i = 0.0;
        while (i < RZ_nb) {
            out.println("\\draw (0pt," + (-i * 30.0 + 10.0) + "pt)  --  (" + -10 + "pt," + (-i * 30.0 + 10.0) + "pt);");
            i += 1.0;
        }
        out.println("\\def\\y{" + -((RZ_nb + 2.0) * 30.0 + 15.0) + "};");
    }

    private static void addLatexSchedulerImageHyper(OutputStream console, double maxTime, double Offset, double HyperPeriod, double RZ_nb) throws IOException, JDOMException {
        PrintStream out = new PrintStream(console);
        double i = 0.0;
        while (i < maxTime / constConvertTimeUS) {
            out.println("\\draw (" + i / tikzScaleUS + "pt," + 30 + "pt) -- (" + i / tikzScaleUS + "pt," + -(RZ_nb * 30.0) + "pt);");
            i += HyperPeriod;
        }
    }

    private boolean addLatexSchedulerImageEnergy(OutputStream console, double maxTime, double Offset, double HyperPeriod, String vcdFileName, double RZ_nb, String csvName, double userRequestedTracePeriod) throws IOException, JDOMException {
        return this.getEnergyFromVCD(console, this.configuration, HyperPeriod, RZ_nb, vcdFileName, csvName, userRequestedTracePeriod);
    }

    public static void runPdfLatex(String absfilename) throws IOException, JDOMException, InterruptedException {
        String pdfLatexPath = "pdflatex";
        if (pdfLatexPath.trim().isEmpty()) {
            JOptionPane.showMessageDialog(null, "pdfLatex not found ! Please, verify your latex/miktex installation and PATH variable.", "pdflatex Path Error", 0);
        }
        int index = absfilename.lastIndexOf(File.separator);
        String dir = absfilename.substring(0, index);
        String[] cmd = new String[]{pdfLatexPath, "-interaction=batchmode", absfilename};
        Process p = null;
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        pb.directory(new File(dir));
        p = pb.start();
        p.waitFor();
    }

    public double read(OutputStream latex_file, String RZ, int id, int type, String vcdFileName, double userRequestedTracePeriod) throws Exception {
        String sCurrentLine;
        String hash = "";
        double currentTime = 0.0;
        double previousTime = 0.0;
        String task = "BLANK";
        String impl = "";
        String state = "BLANK";
        double maxTime = 0.0;
        PrintStream out = new PrintStream(latex_file);
        BufferedReader br = new BufferedReader(new FileReader(vcdFileName));
        out.println("\\def\\y{" + -30 * id + "};");
        out.println("\\fill [RUNNING, BLANK,yshift=\\y, xshift=-120pt] (0,0) rectangle (90pt,24pt) node[pos=0, xshift=1pt, yshift=8pt] {\\small{" + RZ.replace("_", "\\_") + "}};");
        while ((sCurrentLine = br.readLine()) != null && currentTime / constConvertTimeTikz < 16000.0 && currentTime / constConvertTimeUS < userRequestedTracePeriod) {
            String[] parts = sCurrentLine.split(" +");
            if (parts[0].equals("$var") && parts[4].equals("Reconfiguration_manager." + RZ)) {
                hash = parts[3];
            }
            if (parts[0].length() > 2 && parts[0].charAt(0) == '#') {
                currentTime = Double.parseDouble(parts[0].substring(1));
            }
            if (parts.length <= 1 || !parts[1].equals(hash)) continue;
            String temp = parts[0].replace('b', '0');
            String Result = "";
            char nextChar = ' ';
            int i = 1;
            while (i <= temp.length() - 7) {
                nextChar = (char)Integer.parseInt(temp.substring(i, i + 7), 2);
                Result = String.valueOf(Result) + nextChar;
                i += 8;
            }
            if (state.equals("Running") || state.equals("BLANK")) {
                if (type == 0 && state.equals("Running")) {
                    out.println("\\fill [RUNNING," + state + ",HWRUN ,yshift=\\y, xshift=" + previousTime / constConvertTimeTikz + "pt] (0,0) rectangle (" + (currentTime - previousTime) / constConvertTimeTikz + "pt,24pt) node[pos=0, xshift=1pt, yshift=7pt] {};");
                } else {
                    out.println("\\fill [RUNNING," + state + ",yshift=\\y, xshift=" + previousTime / constConvertTimeTikz + "pt] (0,0) rectangle (" + (currentTime - previousTime) / constConvertTimeTikz + "pt,24pt) node[pos=0, xshift=1pt, yshift=7pt] {};");
                }
                out.println("\\node[NodeTEXT,yshift=\\y+15pt, xshift=" + previousTime / constConvertTimeTikz + "pt,anchor=west]  {\\small{" + task.replace("_", "\\_") + "}};");
                out.println("\\node[NodeTEXT,yshift=\\y+5pt, xshift=" + previousTime / constConvertTimeTikz + "pt,anchor=west]  {\\tiny{" + impl.replace("_", "\\_") + "}};");
            } else {
                out.print("\\begin{pgfonlayer}{bg};");
                out.print("\\fill [RUNNING," + state + ",yshift=\\y, xshift=" + previousTime / constConvertTimeTikz + "pt] (0,0) rectangle (" + (currentTime - previousTime) / constConvertTimeTikz + "pt,24pt) node[pos=0, xshift=1pt, yshift=7pt] {};");
                out.println("\\end{pgfonlayer};");
            }
            String[] parts2 = Result.split(" +");
            state = parts2[0];
            if (parts2.length > 1) {
                String[] parts4;
                String[] parts3 = parts2[1].split("__");
                if (parts3.length == 2) {
                    parts4 = parts3[1].split("\\.");
                    task = parts4[0];
                    impl = parts4[1];
                } else if (parts3.length == 1) {
                    parts4 = parts3[0].split("\\.");
                    task = parts4[0];
                    if (parts4.length > 1) {
                        impl = parts4[1];
                    }
                } else {
                    task = "ERROR";
                    impl = "Running";
                }
            } else {
                task = "BLANK";
            }
            previousTime = currentTime;
        }
        if (state.equals("Running") || state.equals("BLANK")) {
            if (type == 0 && state.equals("Running")) {
                out.println("\\fill [RUNNING," + state + ",HWRUN,yshift=\\y, xshift=" + previousTime / constConvertTimeTikz + "pt] (0,0) rectangle (" + (currentTime - previousTime) / constConvertTimeTikz + "pt,24pt) node[pos=0, xshift=1pt, yshift=7pt] {};");
            } else {
                out.println("\\fill [RUNNING," + state + ",yshift=\\y, xshift=" + previousTime / constConvertTimeTikz + "pt] (0,0) rectangle (" + (currentTime - previousTime) / constConvertTimeTikz + "pt,24pt) node[pos=0, xshift=1pt, yshift=7pt] {};");
            }
            out.println("\\node[NodeTEXT,yshift=\\y+15pt, xshift=" + previousTime / constConvertTimeTikz + "pt,anchor=west]  {\\small{" + task.replace("_", "\\_") + "}};");
            out.println("\\node[NodeTEXT,yshift=\\y+5pt, xshift=" + previousTime / constConvertTimeTikz + "pt,anchor=west]  {\\tiny{" + impl.replace("_", "\\_") + "}};");
        } else {
            out.print("\\begin{pgfonlayer}{bg};");
            out.print("\\fill [RUNNING," + state + ",yshift=\\y, xshift=" + previousTime / constConvertTimeTikz + "pt] (0,0) rectangle (" + (currentTime - previousTime) / constConvertTimeTikz + "pt,24pt) node[pos=0, xshift=1pt, yshift=7pt] {};");
            out.print("\\end{pgfonlayer};");
        }
        if (currentTime > maxTime) {
            maxTime = currentTime;
        }
        br.close();
        return maxTime;
    }

    private boolean getEnergyFromVCD(OutputStream console, String configuration, double HyperPeriod, double RZ_nb, String vcdFileName, String csvName, double userRequestedTracePeriod) throws IOException, JDOMException {
        String[] parts;
        String sCurrentLine;
        String hash = "";
        double currentTime = 0.0;
        double currentEnergy = 0.0;
        double sumOfEnergy = 0.0;
        double hyperEnergyCount = 0.0;
        double maxEnergy = 0.0;
        double minEnergy = Double.MAX_VALUE;
        double previousEnergy = 0.0;
        PrintStream out = new PrintStream(console);
        BufferedReader br = new BufferedReader(new FileReader(vcdFileName));
        while ((sCurrentLine = br.readLine()) != null && currentTime / constConvertTimeTikz < 16000.0 && currentTime / constConvertTimeUS < userRequestedTracePeriod) {
            parts = sCurrentLine.split(" +");
            if (parts[0].equals("$var") && parts[4].equals("Power_Monitoring.Hyper_Instant_Energy")) {
                hash = parts[3];
            }
            if (parts[0].length() > 2 && parts[0].charAt(0) == '#') {
                currentTime = Double.parseDouble(parts[0].substring(1));
            }
            if (parts.length <= 1 || parts[0].length() <= 1 || !parts[1].equals(hash)) continue;
            currentEnergy = Double.parseDouble(parts[0].substring(1));
            if (currentEnergy < previousEnergy) {
                out.println("\\node[NodeTEXT,yshift=" + -((RZ_nb + 2.0) * 30.0 - 40.0) + "pt, xshift=" + (currentTime / constConvertTimeUS - HyperPeriod / 2.0) / tikzScaleUS + "pt,anchor=north]  {\\small{" + new DecimalFormat("#0.00").format(previousEnergy) + " mJ}};");
                out.println("\\draw[decorate,decoration={brace,amplitude=5pt,mirror}] (" + (currentTime / constConvertTimeUS - HyperPeriod) / tikzScaleUS + "pt," + -((RZ_nb + 2.0) * 30.0 - 45.0) + "pt) --  (" + currentTime / constConvertTimeUS / tikzScaleUS + "pt," + -((RZ_nb + 2.0) * 30.0 - 45.0) + "pt) node(){};");
            }
            previousEnergy = currentEnergy;
        }
        if (currentEnergy != 0.0 && currentTime != 0.0) {
            out.println("\\node[NodeTEXT,yshift=" + -((RZ_nb + 2.0) * 30.0 - 40.0) + "pt, xshift=" + (currentTime / constConvertTimeUS - HyperPeriod / 2.0) / tikzScaleUS + "pt,anchor=north]  {\\small{" + new DecimalFormat("#0.00").format(previousEnergy) + " mJ}};");
            out.println("\\draw[decorate,decoration={brace,amplitude=5pt,mirror}] (" + (currentTime / constConvertTimeUS - HyperPeriod) / tikzScaleUS + "pt," + -((RZ_nb + 2.0) * 30.0 - 45.0) + "pt) --  (" + currentTime / constConvertTimeUS / tikzScaleUS + "pt," + -((RZ_nb + 2.0) * 30.0 - 45.0) + "pt) node(){};");
        }
        br.close();
        br = new BufferedReader(new FileReader(vcdFileName));
        while ((sCurrentLine = br.readLine()) != null) {
            parts = sCurrentLine.split(" +");
            if (parts[0].equals("$var") && parts[4].equals("Power_Monitoring.Hyper_Instant_Energy")) {
                hash = parts[3];
            }
            if (parts[0].length() > 2 && parts[0].charAt(0) == '#') {
                currentTime = Double.parseDouble(parts[0].substring(1));
            }
            if (parts.length <= 1 || parts[0].length() <= 1 || !parts[1].equals(hash)) continue;
            currentEnergy = Double.parseDouble(parts[0].substring(1));
            if (currentEnergy < previousEnergy) {
                sumOfEnergy += previousEnergy;
                hyperEnergyCount += 1.0;
                if (previousEnergy > maxEnergy) {
                    maxEnergy = previousEnergy;
                }
                if (previousEnergy < minEnergy) {
                    minEnergy = previousEnergy;
                }
            }
            previousEnergy = currentEnergy;
        }
        br.close();
        if (hash != "") {
            out.println("\\node[NodeTEXT,yshift=" + -((RZ_nb + 2.0) * 30.0 - 40.0) + "pt, xshift=-50pt,anchor=east]  {\\small{Average: " + new DecimalFormat("#0.00").format(sumOfEnergy / hyperEnergyCount) + " mJ}};");
            out.println("\\node[NodeTEXT,yshift=" + -((RZ_nb + 2.0) * 30.0 - 30.0) + "pt, xshift=-50pt,anchor=east]  {\\small{Max: " + new DecimalFormat("#0.00").format(maxEnergy) + " mJ}};");
            out.println("\\node[NodeTEXT,yshift=" + -((RZ_nb + 2.0) * 30.0 - 20.0) + "pt, xshift=-50pt,anchor=east]  {\\small{Min: " + new DecimalFormat("#0.00").format(minEnergy) + " mJ}};");
            return true;
        }
        out.println("\\node[NodeTEXT,yshift=" + -((RZ_nb + 2.0) * 30.0 - 40.0) + "pt, xshift=-50pt,anchor=east]  {\\small{No Energy Information}};");
        out.println("\\node[NodeTEXT,yshift=" + -((RZ_nb + 2.0) * 30.0 - 30.0) + "pt, xshift=-50pt,anchor=east]  {\\small{Add Power\\_Monitoring Module}};");
        return false;
    }

    private void getPowerFromVCD(OutputStream console, String configuration, double maxTime, double HyperPeriod, String vcdFileName, String csvName, double userRequestedTracePeriod) throws IOException, JDOMException {
        String sCurrentLine;
        double currentTime = 0.0;
        double previousTime = 0.0;
        PrintStream out = new PrintStream(console);
        BufferedReader br = new BufferedReader(new FileReader(vcdFileName));
        String[] signalsToRead = new String[]{"Power_Monitoring.Instant_current", "Power_Monitoring.Cores_static_current", "Power_Monitoring.Cores_idle_current", "Power_Monitoring.Cores_run_current", "Power_Monitoring.RZ_static_current", "Power_Monitoring.RZ_idle_current", "Power_Monitoring.RZ_run_current", "Power_Monitoring.Reconf_current"};
        String[] hash = new String[signalsToRead.length];
        double[] currentPower = new double[signalsToRead.length];
        int i = 0;
        while (i < signalsToRead.length) {
            hash[i] = "";
            currentPower[i] = 0.0;
            ++i;
        }
        out.println("\\pgfplotstableread{");
        out.println("time total cpu_static cpu_idle cpu_run prr_static prr_idle prr_run reconf");
        while ((sCurrentLine = br.readLine()) != null && currentTime / constConvertTimeTikz < 16000.0 && currentTime / constConvertTimeUS < userRequestedTracePeriod) {
            int i2;
            String[] parts = sCurrentLine.split(" +");
            if (parts[0].equals("$var")) {
                i2 = 0;
                while (i2 < signalsToRead.length) {
                    if (parts[4].equals(signalsToRead[i2])) {
                        hash[i2] = parts[3];
                    }
                    ++i2;
                }
            }
            if (parts[0].length() > 2 && parts[0].charAt(0) == '#') {
                currentTime = Double.parseDouble(parts[0].substring(1));
                continue;
            }
            if (parts.length <= 1 || parts[0].length() <= 1 || parts[0].charAt(0) != 'r') continue;
            i2 = 0;
            while (i2 < signalsToRead.length) {
                if (parts[1].equals(hash[i2]) && !hash[i2].equals("")) {
                    currentPower[i2] = Double.parseDouble(parts[0].substring(1));
                    if (previousTime != currentTime) {
                        out.print(previousTime / 1.0E9);
                        int j = 0;
                        while (j < signalsToRead.length) {
                            out.print(" " + currentPower[j]);
                            ++j;
                        }
                        out.println("");
                        previousTime = currentTime;
                    }
                }
                ++i2;
            }
        }
        out.print(currentTime / 1.0E9);
        i = 0;
        while (i < signalsToRead.length) {
            out.print(" " + currentPower[i]);
            ++i;
        }
        out.println("");
        out.println("}\\data");
        out.println("");
        out.println("");
        out.println("");
        br.close();
    }
}

