/*
 * Decompiled with CFR 0.152.
 */
package fortress.generation;

import fortress.env.FortressEnv;
import fortress.env.FortressException;
import fortress.generation.FortressGeneration;
import fortress.generation.ReplaceKeyword;
import fortress.xml.DeviceCell;
import fortress.xml.DeviceColumn;
import fortress.xml.DevicePackage;
import fortress.xml.FPGAConstraints;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressDeviceLibrary;
import fortress.xml.FortressPreferences;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;

public class DeviceHeaderGeneration {
    public final String DEVICE_HEADER_FILENAME = "device.h";
    String configuration;

    public DeviceHeaderGeneration(String configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - void declaration
     */
    public void Generate(OutputStream console) throws Exception {
        void var15_33;
        void var15_31;
        void var15_29;
        void var15_27;
        void var15_25;
        void var15_23;
        int j;
        DeviceCell[] dcell;
        Object dcol;
        void var15_21;
        void var15_19;
        PrintStream out = new PrintStream(console);
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        if (pref.isVerboseMode()) {
            out.println("----------------------------------");
            out.println("- Device Header Generation");
            out.println("- " + FortressEnv.getLaboratory());
            out.println("- " + FortressEnv.today());
            out.println("- Configuration : " + this.configuration);
            out.println();
        }
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(this.configuration);
        FortressDeviceLibrary lib = FortressEnv.getFortressDeviceLibrary();
        DevicePackage dp = lib.getDevicePackage(conf.getSelectedDevice());
        if (dp == null) {
            throw new Exception("No Device Found : " + conf.getSelectedDevice());
        }
        HashMap<String, DeviceCell> refCells = dp.getReferenceCell();
        String template_filename = FortressEnv.getHeaderDeviceTemplateFile();
        String generated_filename = String.valueOf(FortressEnv.getHeaderDevicePath(this.configuration)) + "device.h";
        if (pref.isVerboseMode()) {
            out.print("Running generation of Device Header : " + generated_filename + " ... ");
        }
        ReplaceKeyword rk = new ReplaceKeyword(template_filename, generated_filename);
        String buf = FortressGeneration.createFortressHeaderForC("device.h", "Some defines representing the hardware in " + dp.getDeviceName() + " device" + " (" + dp.getCategory() + ")");
        rk.addReplaceKeyword("FORTRESS_HEADER", buf);
        buf = "const int NB_LINES_DEVICE   = " + dp.getLineNumber() + ";" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "const int NB_COLUMNS_DEVICE = " + dp.getColumnNumber() + ";" + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_LINES_COLUMNS_DEVICE", buf);
        buf = "enum RBType{";
        boolean firstRefCell = true;
        for (Map.Entry<String, DeviceCell> entry : refCells.entrySet()) {
            DeviceCell deviceCell = entry.getValue();
            if (firstRefCell) {
                buf = String.valueOf(buf) + deviceCell.getName();
                firstRefCell = false;
                continue;
            }
            buf = String.valueOf(buf) + ", " + deviceCell.getName();
        }
        buf = String.valueOf(buf) + "};" + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_ENUM_REF_CELL", buf);
        buf = "";
        for (Map.Entry<String, DeviceCell> entry : refCells.entrySet()) {
            DeviceCell deviceCell = entry.getValue();
            buf = String.valueOf(buf) + "const Cell " + deviceCell.getName() + "_cell(\"" + deviceCell.getName();
            buf = String.valueOf(buf) + "\", " + deviceCell.isReconfigurable();
            buf = String.valueOf(buf) + ", " + deviceCell.getNbCellsPerColumn();
            buf = String.valueOf(buf) + ", " + deviceCell.getCost();
            buf = String.valueOf(buf) + ", " + deviceCell.getBitstreamSizePerColumn();
            buf = String.valueOf(buf) + ", " + deviceCell.isMarginSensitive();
            buf = String.valueOf(buf) + ");" + FortressEnv.EOL;
        }
        rk.addReplaceKeyword("FORTRESS_DECLARE_REF_CELL", buf);
        buf = "const RBType fpga_device[NB_LINES_DEVICE][NB_COLUMNS_DEVICE] = {" + FortressEnv.EOL;
        Vector<DeviceColumn> vcell = dp.getDeviceCellList();
        String[] lineType = new String[dp.getLineNumber()];
        boolean bl = false;
        while (var15_19 < lineType.length) {
            lineType[var15_19] = "{";
            ++var15_19;
        }
        boolean bl2 = false;
        while (var15_21 < vcell.size()) {
            dcol = vcell.elementAt((int)var15_21);
            dcell = ((DeviceColumn)dcol).getCells();
            j = 0;
            while (j < dcell.length) {
                int n = j;
                lineType[n] = String.valueOf(lineType[n]) + dcell[j].getName();
                if (var15_21 != vcell.size() - 1) {
                    int n2 = j;
                    lineType[n2] = String.valueOf(lineType[n2]) + ",";
                }
                ++j;
            }
            ++var15_21;
        }
        boolean bl3 = false;
        while (var15_23 < lineType.length) {
            buf = String.valueOf(buf) + lineType[var15_23] + "}";
            if (var15_23 != lineType.length - 1) {
                buf = String.valueOf(buf) + ",";
            }
            buf = String.valueOf(buf) + FortressEnv.EOL;
            ++var15_23;
        }
        buf = String.valueOf(buf) + "};" + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_DEVICE_MODEL", buf);
        buf = "const int x_coordinate_fpga_device[NB_LINES_DEVICE][NB_COLUMNS_DEVICE] = {" + FortressEnv.EOL;
        vcell = dp.getDeviceCellList();
        lineType = new String[dp.getLineNumber()];
        boolean bl4 = false;
        while (var15_25 < lineType.length) {
            lineType[var15_25] = "{";
            ++var15_25;
        }
        boolean bl5 = false;
        while (var15_27 < vcell.size()) {
            dcol = vcell.elementAt((int)var15_27);
            dcell = ((DeviceColumn)dcol).getCells();
            j = 0;
            while (j < dcell.length) {
                int n = j;
                lineType[n] = String.valueOf(lineType[n]) + dcell[j].getX();
                if (var15_27 != vcell.size() - 1) {
                    int n3 = j;
                    lineType[n3] = String.valueOf(lineType[n3]) + ",";
                }
                ++j;
            }
            ++var15_27;
        }
        boolean bl6 = false;
        while (var15_29 < lineType.length) {
            buf = String.valueOf(buf) + lineType[var15_29] + "}";
            if (var15_29 != lineType.length - 1) {
                buf = String.valueOf(buf) + ",";
            }
            buf = String.valueOf(buf) + FortressEnv.EOL;
            ++var15_29;
        }
        buf = String.valueOf(buf) + "};" + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_X_COORDINATE_MODEL", buf);
        buf = "const PositionConstraint columns_position_constraints[NB_COLUMNS_DEVICE] = {" + FortressEnv.EOL;
        vcell = dp.getDeviceCellList();
        lineType = new String[dp.getLineNumber()];
        boolean bl7 = false;
        while (var15_31 < lineType.length) {
            lineType[var15_31] = "{";
            ++var15_31;
        }
        boolean bl8 = false;
        while (var15_33 < vcell.size()) {
            dcol = vcell.elementAt((int)var15_33);
            dcell = ((DeviceColumn)dcol).getCells();
            buf = var15_33 == false ? String.valueOf(buf) + dcell[0].getPositionConstraint() : String.valueOf(buf) + ", " + dcell[0].getPositionConstraint();
            ++var15_33;
        }
        buf = String.valueOf(buf) + "};" + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_POSITION_CONSTRAINT_MODEL", buf);
        buf = "const int NB_LUT_SLICE      = " + dp.getLutSliceNumber() + ";" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "const int NB_FF_SLICE       = " + dp.getFFSliceNumber() + ";" + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_DEVICE_RESSOURCE_CONSTANTS", buf);
        if (dp.getCategory().equalsIgnoreCase("Virtex5")) {
            buf = "deviceClass = Virtex5;" + FortressEnv.EOL;
        } else if (dp.getCategory().equalsIgnoreCase("Virtex6")) {
            buf = "deviceClass = Virtex6;" + FortressEnv.EOL;
        } else if (dp.getCategory().equalsIgnoreCase("Virtex7")) {
            buf = "deviceClass = Virtex7;" + FortressEnv.EOL;
        } else if (dp.getCategory().equalsIgnoreCase("Kintex7")) {
            buf = "deviceClass = Kintex7;" + FortressEnv.EOL;
        } else if (dp.getCategory().equalsIgnoreCase("Zynq7")) {
            buf = "deviceClass = Zynq7;" + FortressEnv.EOL;
        } else if (dp.getCategory().equalsIgnoreCase("Artix7")) {
            buf = "deviceClass = Artix7;" + FortressEnv.EOL;
        } else {
            buf = "deviceClass = CUSTOM;" + FortressEnv.EOL;
            FortressException.messageWarning(out, "Device Header Gen.", "Using CUSTOM device : " + dp.getCategory());
        }
        buf = String.valueOf(buf) + "\t\tdeviceID = \"" + conf.getSelectedDevice() + "\";" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "\t\tpackage = \"" + conf.getSelectedDevicePackage() + "\";" + FortressEnv.EOL;
        buf = String.valueOf(buf) + "\t\tspeedGrade = \"" + conf.getSelectedSpeedGrade() + "\";" + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_DEVICE_TYPE", buf);
        buf = "";
        for (Map.Entry entry : refCells.entrySet()) {
            DeviceCell cell2 = (DeviceCell)entry.getValue();
            buf = String.valueOf(buf) + "\t\tdeviceCellMap[" + cell2.getName() + "] = " + cell2.getName() + "_cell;" + FortressEnv.EOL;
        }
        rk.addReplaceKeyword("FORTRESS_CELL_MAP_INIT", buf);
        buf = "";
        Vector<FPGAConstraints> vector = conf.getFPGAStaticConstraints();
        if (vector.size() == 0) {
            buf = String.valueOf(buf) + "\t\t// Empty" + FortressEnv.EOL;
        }
        int i2 = 0;
        while (i2 < vector.size()) {
            FPGAConstraints fc = vector.elementAt(i2);
            if (fc.isRB()) {
                buf = String.valueOf(buf) + "\t\trestrictedColumns.push_back(Coordinates(" + fc.getColumn() + ", " + fc.getRow() + "));" + FortressEnv.EOL;
            } else {
                j = fc.getColumn();
                while (j < fc.getColumnMax()) {
                    buf = String.valueOf(buf) + "\t\trestrictedColumns.push_back(Coordinates(" + j + ", " + fc.getRow() + "));" + FortressEnv.EOL;
                    ++j;
                }
            }
            ++i2;
        }
        rk.addReplaceKeyword("FORTRESS_STATIC_CONSTRAINTS", buf);
        rk.Generate();
        if (pref.isVerboseMode()) {
            out.println("done");
        }
    }
}

