/*
 * Decompiled with CFR 0.152.
 */
package fortress.env;

import fortress.env.FortressEnv;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.NetworkInterface;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Vector;

public class LicenseManager {
    final int MAX = 256;
    int begin_date_year;
    int begin_date_month;
    int begin_date_day;
    int end_date_year;
    int end_date_month;
    int end_date_day;
    int user_id;
    String compagny;
    String license_type;
    Vector<NetworkInterface> niList;

    LicenseManager() {
        this.begin_date_year = 0;
        this.begin_date_month = 0;
        this.begin_date_day = 0;
        this.end_date_year = 0;
        this.end_date_month = 0;
        this.end_date_day = 0;
        this.user_id = 0;
        this.compagny = "";
        this.license_type = "";
        this.niList = new Vector();
    }

    public LicenseManager(String filename) throws IOException {
        this.niList = new Vector();
        try {
            this.niList = FortressEnv.getNetworkInterfaceList();
        }
        catch (Exception exception) {}
        File file = new File(filename);
        if (!file.exists()) {
            throw new IOException("License File Not Found !");
        }
        int size = (int)file.length();
        byte[] memblock = new byte[size];
        try (BufferedInputStream licFile = new BufferedInputStream(new FileInputStream(filename));){
            licFile.read(memblock, 0, size);
        }
        char[] coded_char_vec = new char[256];
        int i = 0;
        while (i < 256) {
            coded_char_vec[memblock[i] & 0xFF] = (char)i;
            ++i;
        }
        int max_buf = size - 256;
        char[] buffer = new char[max_buf];
        int i2 = 0;
        while (i2 < max_buf) {
            buffer[i2] = coded_char_vec[memblock[256 + i2] & 0xFF];
            ++i2;
        }
        int cpt = 0;
        ++cpt;
        String s_begin_date_year = "";
        while (buffer[cpt] != ':') {
            s_begin_date_year = String.valueOf(s_begin_date_year) + buffer[cpt++];
        }
        ++cpt;
        String s_begin_date_month = "";
        while (buffer[cpt] != '.') {
            s_begin_date_month = String.valueOf(s_begin_date_month) + buffer[cpt++];
        }
        ++cpt;
        String s_begin_date_day = "";
        while (buffer[cpt] != ',') {
            s_begin_date_day = String.valueOf(s_begin_date_day) + buffer[cpt++];
        }
        ++cpt;
        String s_end_date_year = "";
        while (buffer[cpt] != '/') {
            s_end_date_year = String.valueOf(s_end_date_year) + buffer[cpt++];
        }
        ++cpt;
        String s_end_date_month = "";
        while (buffer[cpt] != '-') {
            s_end_date_month = String.valueOf(s_end_date_month) + buffer[cpt++];
        }
        ++cpt;
        String s_end_date_day = "";
        while (buffer[cpt] != ';') {
            s_end_date_day = String.valueOf(s_end_date_day) + buffer[cpt++];
        }
        ++cpt;
        String s_user_id = "";
        while (buffer[cpt] != '!') {
            s_user_id = String.valueOf(s_user_id) + buffer[cpt++];
        }
        ++cpt;
        String s_compagny = "";
        while (buffer[cpt] != '{') {
            s_compagny = String.valueOf(s_compagny) + buffer[cpt++];
        }
        ++cpt;
        String s_license_type = "";
        while (buffer[cpt] != '}') {
            s_license_type = String.valueOf(s_license_type) + buffer[cpt++];
        }
        this.begin_date_year = Integer.valueOf(s_begin_date_year);
        this.begin_date_month = Integer.valueOf(s_begin_date_month);
        this.begin_date_day = Integer.valueOf(s_begin_date_day);
        this.end_date_year = Integer.valueOf(s_end_date_year);
        this.end_date_month = Integer.valueOf(s_end_date_month);
        this.end_date_day = Integer.valueOf(s_end_date_day);
        this.user_id = Integer.valueOf(s_user_id);
        this.compagny = s_compagny;
        this.license_type = s_license_type;
    }

    static void checksLicence(OutputStream console) throws Exception {
        Calendar now;
        PrintStream out = new PrintStream(console);
        String filename = FortressEnv.getLicenseFile();
        LicenseManager lm = new LicenseManager(filename);
        int days = lm.isValidLicence((now = Calendar.getInstance()).get(1), now.get(2) + 1, now.get(5));
        if (days <= 0) {
            throw new Exception("Error: Invalid licence since " + -days + " days.");
        }
        if (days <= 30) {
            out.println();
            out.println("WARNING: Valid licence only for " + days + " days !");
            out.println();
        }
    }

    public int isValidLicence(int year, int month, int day) {
        Date current_date = this.getDate(year, month, day);
        Date begin_date = this.getDate(this.begin_date_year, this.begin_date_month, this.begin_date_day);
        Date end_date = this.getDate(this.end_date_year, this.end_date_month, this.end_date_day);
        long diff_time = current_date.getTime() / 1000L - begin_date.getTime() / 1000L;
        if (diff_time < 0L) {
            return -1;
        }
        diff_time = end_date.getTime() / 1000L - current_date.getTime() / 1000L;
        return (int)(diff_time / 86400L);
    }

    Date getDate(int year, int month, int day) {
        GregorianCalendar cal = new GregorianCalendar(year, month, day);
        return cal.getTime();
    }

    public String toString() {
        String buf = "";
        buf = String.valueOf(buf) + "Begin date : " + this.begin_date_year;
        buf = String.valueOf(buf) + "\\" + this.begin_date_month;
        buf = String.valueOf(buf) + "\\" + this.begin_date_day;
        buf = String.valueOf(buf) + "\n";
        buf = String.valueOf(buf) + "End date   : " + this.end_date_year;
        buf = String.valueOf(buf) + "\\" + this.end_date_month;
        buf = String.valueOf(buf) + "\\" + this.end_date_day;
        buf = String.valueOf(buf) + "\n";
        buf = String.valueOf(buf) + "Custom ID  : " + this.user_id;
        buf = String.valueOf(buf) + "\n";
        buf = String.valueOf(buf) + "Compagny   : " + this.compagny;
        buf = String.valueOf(buf) + "\n";
        buf = String.valueOf(buf) + "Type       : " + this.license_type;
        buf = String.valueOf(buf) + "\n";
        return buf;
    }
}

