/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands.ViewStatistics;

import Modulesystem.diagram.commands.ResultInputDialog;
import fortress.env.ConsoleCommandExecListener;
import fortress.env.DoubleOutputStream;
import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import fortress.env.FortressFlow;
import fortress.generation.CSVParser;
import fortress.xml.FortressPreferences;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;

public class ViewStatisticsOthersHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block7: {
            try {
                FortressPreferences pref = FortressEnv.getFortressPreferences();
                pref.loadFile();
                Display display = PlatformUI.createDisplay();
                Vector<String> configurationList = pref.getConfigurations();
                Vector<Object[]> solValues = new Vector<Object[]>();
                int i = 0;
                while (i < configurationList.size()) {
                    String placementPath = FortressEnv.getUCFFilePath(configurationList.elementAt(i));
                    Vector<String> list = FortressEnv.getFileListWithoutExtension(placementPath, ".csv");
                    solValues.add(list.toArray());
                    ++i;
                }
                ResultInputDialog inputDiag = new ResultInputDialog(display, "View Statistics", configurationList.toArray(), solValues);
                boolean result = inputDiag.open();
                MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
                if (!result) break block7;
                String cfgFile = (String)inputDiag.getCfgSelectedValue();
                String csvFile = (String)inputDiag.getSolSelectedValue();
                String csvPath = FortressEnv.getCSVFilePath(cfgFile);
                FortressFlow flow = FortressFlow.createFortressFlow(cfgFile, (OutputStream)console, false);
                flow.setCommandExecListener(new ConsoleCommandExecListener(console));
                try {
                    String logFile = FortressEnv.getConfigurationLogFile(cfgFile);
                    FileOutputStream ops = new FileOutputStream(logFile, true);
                    DoubleOutputStream doubleStream = new DoubleOutputStream((OutputStream)console, ops);
                    PrintStream out = new PrintStream(doubleStream);
                    if (csvFile != null) {
                        String path = String.valueOf(csvPath) + csvFile + ".csv";
                        CSVParser csvparser = new CSVParser(path);
                        String buf = csvparser.toString();
                        out.println("*********************************************************");
                        out.println("View Statistics  (configuration : " + cfgFile + ")");
                        out.println("                 (solution : " + csvFile + ")");
                        out.println();
                        if (!FortressFlow.isFlowUpdated(cfgFile, false)) {
                            out.println("!!!!!!!!!!!!!!");
                            out.println("WARNING : View Statistics are not updated ! Please, run simulation.");
                            out.println("!!!!!!!!!!!!!!");
                            out.println();
                        }
                        out.println(buf);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new Exception(ex.getMessage());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return FortressEnv.hasOpenedProject() && pref.hasActiveConfiguration();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

