/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands.ViewStatistics;

import Modulesystem.diagram.commands.InputDialog;
import fortress.env.DoubleOutputStream;
import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import fortress.env.FortressFlow;
import fortress.generation.CSVParser;
import fortress.xml.FortressPreferences;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;

public class ViewStatisticsCurrentConfigHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Vector<String> v;
        Display display;
        String csvPath;
        String configuration;
        block5: {
            FortressPreferences pref = FortressEnv.getFortressPreferences();
            pref.loadFile();
            configuration = pref.getActiveConfiguration();
            csvPath = FortressEnv.getCSVFilePath(configuration);
            display = PlatformUI.createDisplay();
            v = FortressEnv.getFileListWithoutExtension(csvPath, ".csv");
            if (v.size() != 0) break block5;
            JOptionPane.showMessageDialog(null, "No solution found ! Please, simulate this configuration.", null, 1);
            return null;
        }
        try {
            InputDialog inputDiag = new InputDialog(display, "View Statistics", "Select a Solution", v.toArray());
            String csvFile = (String)inputDiag.open();
            MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
            String logFile = FortressEnv.getConfigurationLogFile(configuration);
            FileOutputStream ops = new FileOutputStream(logFile, true);
            DoubleOutputStream doubleStream = new DoubleOutputStream((OutputStream)console, ops);
            PrintStream out = new PrintStream(doubleStream);
            if (csvFile != null) {
                String path = String.valueOf(csvPath) + csvFile + ".csv";
                CSVParser csvparser = new CSVParser(path);
                String buf = csvparser.toString();
                out.println("*********************************************************");
                out.println("View Statistics  (configuration : " + configuration + ")");
                out.println();
                if (!FortressFlow.isFlowUpdated(configuration, false)) {
                    out.println("!!!!!!!!!!!!!!");
                    out.println("WARNING : View Statistics are not updated ! Please, run simulation.");
                    out.println("!!!!!!!!!!!!!!");
                    out.println();
                }
                out.println(buf);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            System.out.println("ERROR : " + ex.getMessage());
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return FortressEnv.hasOpenedProject() && pref.hasActiveConfiguration();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

