/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import Modulesystem.diagram.commands.ApplicationParametersTab;
import Modulesystem.diagram.commands.FoRTReSSParametersTab;
import Modulesystem.diagram.commands.ProcessorParametersTab;
import Modulesystem.diagram.commands.SynthesisReportNetlistTab;
import fortress.env.FortressEnv;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressPreferences;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import org.jdom.JDOMException;

public class SystemParametersTab {
    JFrame WindowsParameters;
    JTabbedPane Tab;
    boolean selected_configuration_validate;
    FortressPreferences pref = FortressEnv.getFortressPreferences();
    FortressConfiguration config = null;
    ProcessorParametersTab T_ProcessorParameters = null;
    FoRTReSSParametersTab T_FoRTReSSParameters = null;
    ApplicationParametersTab T_ApplicationParameters = null;
    SynthesisReportNetlistTab T_SynthesisReportNetlist = null;
    JTextField MsBuildPath = null;
    JComboBox<String> TargetArchitecture = null;
    JTextField Xilinx_vivado_path = null;
    JComboBox<String> Xilinx_vivado_version = null;
    JTextField PlanAhead_path = null;
    JComboBox<String> PlanAhead_path_version = null;
    JTextField SystemC_path = null;
    JTextField SystemC_lib = null;
    JTextField Xerces_path = null;
    JTextField VisualCPP_path = null;
    JTextField ModelSim = null;
    JTextField TextEditor = null;
    JComboBox<String> Selected_Configuration = null;
    JComboBox<String> Visual_Studio_Version = null;
    JCheckBox Check_verbose_mode = null;

    public SystemParametersTab(JFrame Windows, JTabbedPane Tab, FortressPreferences pref, FortressConfiguration config) {
        this.WindowsParameters = Windows;
        this.Tab = Tab;
        this.selected_configuration_validate = false;
        this.pref = pref;
        this.config = config;
        this.T_ProcessorParameters = new ProcessorParametersTab(this.WindowsParameters, Tab, pref, config);
        this.T_FoRTReSSParameters = new FoRTReSSParametersTab(this.WindowsParameters, Tab, pref, config);
        this.T_ApplicationParameters = new ApplicationParametersTab(this.WindowsParameters, Tab, pref, config);
        this.T_SynthesisReportNetlist = new SynthesisReportNetlistTab(this.WindowsParameters, Tab, pref);
        this.MsBuildPath = new JTextField();
        this.VisualCPP_path = new JTextField();
        this.Xerces_path = new JTextField();
        this.TargetArchitecture = new JComboBox();
        this.PlanAhead_path = new JTextField();
        this.PlanAhead_path_version = new JComboBox();
        this.Xilinx_vivado_path = new JTextField();
        this.Xilinx_vivado_version = new JComboBox();
        this.SystemC_path = new JTextField();
        this.SystemC_lib = new JTextField();
        this.ModelSim = new JTextField();
        this.TextEditor = new JTextField();
        this.Check_verbose_mode = new JCheckBox("Verbose mode");
        this.Selected_Configuration = new JComboBox();
        this.Visual_Studio_Version = new JComboBox();
    }

    void setTitle(String config) {
        if (config == null) {
            this.WindowsParameters.setTitle("Preference - No Configuration");
        } else {
            this.WindowsParameters.setTitle("Preference - " + config);
        }
    }

    public void CreateSystemParametersTab() {
        JPanel p_PlanAhead_path_version;
        GroupLayout g_Jtext;
        GroupLayout g_Label;
        JLabel MsBuildPath_Label = new JLabel("MsBuild Path:");
        this.MsBuildPath.setPreferredSize(new Dimension(360, 25));
        JButton Button_MsBuildPath = new JButton("Search");
        this.MsBuildPath.setEnabled(FortressEnv.isWindowsOS());
        Button_MsBuildPath.setEnabled(FortressEnv.isWindowsOS());
        JLabel VisualCPP_Label = new JLabel("Visual C++ Path:");
        this.VisualCPP_path.setPreferredSize(new Dimension(360, 25));
        JButton Button_VisualCPPPath = new JButton("Search");
        this.VisualCPP_path.setEnabled(FortressEnv.isWindowsOS());
        Button_VisualCPPPath.setEnabled(FortressEnv.isWindowsOS());
        JLabel Xerces_path_Label = new JLabel("Xerces Path:");
        this.Xerces_path.setPreferredSize(new Dimension(360, 25));
        JButton Button_Xerces_path = new JButton("Search");
        JLabel PlanAhead_path_Label = new JLabel("PlanAhead Path:");
        PlanAhead_path_Label.setToolTipText("Absolute path to PlanAhead executable");
        this.PlanAhead_path.setToolTipText("Absolute path to PlanAhead executable");
        this.PlanAhead_path.setPreferredSize(new Dimension(350, 25));
        JLabel PlanAhead_path_version_Label = new JLabel("  PlanAhead Version:");
        this.PlanAhead_path_version.setBackground(Color.white);
        this.PlanAhead_path_version.setPreferredSize(new Dimension(80, 25));
        this.setPlanAhead_path_versionList();
        JLabel Xilinx_vivado_path_Label = new JLabel("Xilinx Vivado Path:");
        Xilinx_vivado_path_Label.setToolTipText("Absolute path to Xilinx Vivado");
        this.Xilinx_vivado_path.setToolTipText("Absolute path to Xilinx Vivado");
        this.Xilinx_vivado_path.setPreferredSize(new Dimension(350, 25));
        JLabel Xilinx_vivado_version_Label = new JLabel("  Vidado Version:");
        this.Xilinx_vivado_version.setBackground(Color.white);
        this.Xilinx_vivado_version.setPreferredSize(new Dimension(100, 25));
        this.setXilinx_vivado_versionList();
        JLabel Visual_Studio_Version_Label = new JLabel("   Visual Studio Version:");
        this.Visual_Studio_Version.setBackground(Color.white);
        this.setVisual_Studio_VersionList();
        this.Visual_Studio_Version.setEnabled(FortressEnv.isWindowsOS());
        JLabel SystemC_path_Label = new JLabel("SystemC Path:");
        SystemC_path_Label.setToolTipText("Absolute path to SystemC library");
        this.SystemC_path.setToolTipText("Absolute path to SystemC library");
        this.SystemC_path.setPreferredSize(new Dimension(350, 25));
        JLabel SystemC_lib_Label = new JLabel("SystemCLib Path:");
        SystemC_lib_Label.setToolTipText("Absolute path to SystemCLib library");
        this.SystemC_lib.setToolTipText("Absolute path to SystemCLib library");
        this.SystemC_lib.setPreferredSize(new Dimension(350, 25));
        JLabel ModelSim_Label = new JLabel("ModelSim:");
        ModelSim_Label.setToolTipText("Absolute path to ModelSim executable (version 6.6 or later)");
        this.ModelSim.setToolTipText("Absolute path to ModelSim executable (version 6.6 or later)");
        this.ModelSim.setPreferredSize(new Dimension(350, 25));
        JLabel TextEditor_Label = new JLabel("Text Editor:");
        TextEditor_Label.setToolTipText("Absolute path to Text Editor executable");
        this.TextEditor.setToolTipText("Absolute path to Text Editor executable");
        this.TextEditor.setPreferredSize(new Dimension(350, 25));
        JPanel p_configuration = new JPanel();
        p_configuration.setBorder(BorderFactory.createTitledBorder("Configuration"));
        this.Selected_Configuration.setPreferredSize(new Dimension(200, 20));
        this.Selected_Configuration.setBackground(Color.white);
        try {
            Vector<String> config_list = this.pref.getConfigurations();
            Iterator i = config_list.iterator();
            i = config_list.iterator();
            if (config_list != null) {
                while (i.hasNext()) {
                    String x = (String)i.next();
                    if (x.isEmpty()) continue;
                    this.Selected_Configuration.addItem(x);
                }
            }
            if (this.pref.getActiveConfiguration() != null) {
                this.setTitle(this.pref.getActiveConfiguration());
                this.Selected_Configuration.setSelectedItem(this.pref.getActiveConfiguration());
            }
        }
        catch (JDOMException e2) {
            e2.printStackTrace();
        }
        JLabel Selected_Configuartion_Label = new JLabel("Current Configuration:");
        JButton Button_New_configuration = new JButton("New");
        JButton Button_delete_configuration = new JButton("Delete");
        JButton Button_duplicate_configuration = new JButton("Duplicate");
        p_configuration.setLayout(new FlowLayout(0));
        p_configuration.add(Selected_Configuartion_Label);
        p_configuration.add(this.Selected_Configuration);
        p_configuration.add(Button_New_configuration);
        p_configuration.add(Button_delete_configuration);
        p_configuration.add(Button_duplicate_configuration);
        if (this.Selected_Configuration.getModel().getSize() != 0) {
            this.selected_configuration_validate = true;
        }
        JPanel p_other = new JPanel();
        p_other.setBorder(BorderFactory.createTitledBorder("Others"));
        this.Check_verbose_mode.setPreferredSize(new Dimension(300, 20));
        this.Check_verbose_mode.setToolTipText("Display on console more information about process or not");
        p_other.setLayout(new FlowLayout(0));
        p_other.add(this.Check_verbose_mode);
        Button_MsBuildPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser_MsBuildPath = new JFileChooser();
                chooser_MsBuildPath.setCurrentDirectory(SystemParametersTab.this.getPathFile(SystemParametersTab.this.MsBuildPath.getText()));
                chooser_MsBuildPath.setFileSelectionMode(1);
                int returnVal = chooser_MsBuildPath.showOpenDialog(null);
                if (returnVal == 0) {
                    SystemParametersTab.this.MsBuildPath.setText(chooser_MsBuildPath.getSelectedFile().getAbsolutePath());
                }
            }
        });
        Button_VisualCPPPath.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser_VisualCPPPath = new JFileChooser();
                chooser_VisualCPPPath.setCurrentDirectory(SystemParametersTab.this.getPathFile(SystemParametersTab.this.VisualCPP_path.getText()));
                chooser_VisualCPPPath.setFileSelectionMode(0);
                int returnVal = chooser_VisualCPPPath.showOpenDialog(null);
                if (returnVal == 0) {
                    SystemParametersTab.this.VisualCPP_path.setText(chooser_VisualCPPPath.getSelectedFile().getAbsolutePath());
                }
            }
        });
        Button_Xerces_path.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser_Xerces_path = new JFileChooser();
                chooser_Xerces_path.setCurrentDirectory(SystemParametersTab.this.getPathFile(SystemParametersTab.this.Xerces_path.getText()));
                chooser_Xerces_path.setFileSelectionMode(1);
                int returnVal = chooser_Xerces_path.showOpenDialog(null);
                if (returnVal == 0) {
                    SystemParametersTab.this.Xerces_path.setText(chooser_Xerces_path.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JButton Button_PlanAhead_path = new JButton("Search");
        Button_PlanAhead_path.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser_PlanAhead_path = new JFileChooser();
                chooser_PlanAhead_path.setCurrentDirectory(SystemParametersTab.this.getPathFile(SystemParametersTab.this.PlanAhead_path.getText()));
                chooser_PlanAhead_path.setFileSelectionMode(1);
                int returnVal = chooser_PlanAhead_path.showOpenDialog(null);
                if (returnVal == 0) {
                    SystemParametersTab.this.PlanAhead_path.setText(chooser_PlanAhead_path.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JButton Button_Xilinx_vivado_path = new JButton("Search");
        Button_Xilinx_vivado_path.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser_Xilinx_vivado_path = new JFileChooser();
                chooser_Xilinx_vivado_path.setCurrentDirectory(SystemParametersTab.this.getPathFile(SystemParametersTab.this.Xilinx_vivado_path.getText()));
                chooser_Xilinx_vivado_path.setFileSelectionMode(1);
                int returnVal = chooser_Xilinx_vivado_path.showOpenDialog(null);
                if (returnVal == 0) {
                    SystemParametersTab.this.Xilinx_vivado_path.setText(chooser_Xilinx_vivado_path.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JButton Button_SystemC_lib = new JButton("Search");
        Button_SystemC_lib.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser_SystemC_lib = new JFileChooser();
                chooser_SystemC_lib.setCurrentDirectory(SystemParametersTab.this.getPathFile(SystemParametersTab.this.SystemC_lib.getText()));
                chooser_SystemC_lib.setFileSelectionMode(1);
                int returnVal = chooser_SystemC_lib.showOpenDialog(null);
                if (returnVal == 0) {
                    SystemParametersTab.this.SystemC_lib.setText(chooser_SystemC_lib.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JButton Button_SystemC_path = new JButton("Search");
        Button_SystemC_path.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser_SystemC_path = new JFileChooser();
                chooser_SystemC_path.setCurrentDirectory(SystemParametersTab.this.getPathFile(SystemParametersTab.this.SystemC_path.getText()));
                chooser_SystemC_path.setFileSelectionMode(1);
                int returnVal = chooser_SystemC_path.showOpenDialog(null);
                if (returnVal == 0) {
                    SystemParametersTab.this.SystemC_path.setText(chooser_SystemC_path.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JButton Button_ModelSim = new JButton("Search");
        Button_ModelSim.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser_ModelSim = new JFileChooser();
                chooser_ModelSim.setCurrentDirectory(SystemParametersTab.this.getPathFile(SystemParametersTab.this.ModelSim.getText()));
                chooser_ModelSim.setFileSelectionMode(1);
                int returnVal = chooser_ModelSim.showOpenDialog(null);
                if (returnVal == 0) {
                    SystemParametersTab.this.ModelSim.setText(chooser_ModelSim.getSelectedFile().getAbsolutePath());
                }
            }
        });
        JButton Button_TextEditor = new JButton("Search");
        Button_TextEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser chooser_TextEditor = new JFileChooser();
                chooser_TextEditor.setCurrentDirectory(SystemParametersTab.this.getPathFile(SystemParametersTab.this.TextEditor.getText()));
                chooser_TextEditor.setFileSelectionMode(0);
                int returnVal = chooser_TextEditor.showOpenDialog(null);
                if (returnVal == 0) {
                    SystemParametersTab.this.TextEditor.setText(chooser_TextEditor.getSelectedFile().getAbsolutePath());
                }
            }
        });
        Button_New_configuration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                final JDialog New_configuration_windows = new JDialog(SystemParametersTab.this.WindowsParameters, "New configuration", true);
                New_configuration_windows.setLocationRelativeTo(SystemParametersTab.this.WindowsParameters.getParent());
                New_configuration_windows.setResizable(false);
                final JTextField New_configuration_Name = new JTextField();
                int d = 1;
                int i = 0;
                int j = 0;
                while (j < SystemParametersTab.this.Selected_Configuration.getModel().getSize()) {
                    i = 0;
                    while (i < SystemParametersTab.this.Selected_Configuration.getModel().getSize()) {
                        if (SystemParametersTab.this.Selected_Configuration.getItemAt(i).compareTo("Config_" + d) == 0) {
                            ++d;
                            i = SystemParametersTab.this.Selected_Configuration.getModel().getSize();
                        }
                        ++i;
                    }
                    ++j;
                }
                New_configuration_Name.setText("Config_" + d);
                New_configuration_Name.setPreferredSize(new Dimension(200, 20));
                JLabel New_configuration_Name_Label = new JLabel("New Configuration Name:");
                New_configuration_windows.setSize(New_configuration_Name_Label.getFontMetrics(New_configuration_Name_Label.getFont()).stringWidth("New Configuration Name:") + 219, 100);
                JButton Button_New_configuration_OK = new JButton("OK");
                JButton Button_New_configuration_Cancel = new JButton("Cancel");
                JPanel p_New_configuration = new JPanel();
                p_New_configuration.setLayout(new FlowLayout(0));
                p_New_configuration.add(New_configuration_Name_Label);
                p_New_configuration.add(New_configuration_Name);
                JPanel p_Button_New_configuration = new JPanel();
                p_Button_New_configuration.setLayout(new FlowLayout(4));
                p_Button_New_configuration.add(Button_New_configuration_OK);
                p_Button_New_configuration.add(Button_New_configuration_Cancel);
                JPanel p_New_configuration_windows = new JPanel();
                GroupLayout g_New_configuration_windows = new GroupLayout(p_New_configuration_windows);
                p_New_configuration_windows.setLayout(g_New_configuration_windows);
                g_New_configuration_windows.setHorizontalGroup(g_New_configuration_windows.createParallelGroup().addComponent(p_New_configuration).addComponent(p_Button_New_configuration));
                g_New_configuration_windows.setVerticalGroup(g_New_configuration_windows.createSequentialGroup().addComponent(p_New_configuration).addComponent(p_Button_New_configuration));
                New_configuration_windows.add(p_New_configuration_windows);
                Button_New_configuration_OK.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        if (!New_configuration_Name.getText().isEmpty()) {
                            try {
                                if (!(this).SystemParametersTab.this.pref.existsConfiguration(New_configuration_Name.getText())) {
                                    (this).SystemParametersTab.this.pref.addConfiguration(New_configuration_Name.getText());
                                    (this).SystemParametersTab.this.pref.setActiveConfiguration(New_configuration_Name.getText());
                                    (this).SystemParametersTab.this.Selected_Configuration.addItem(New_configuration_Name.getText());
                                    (this).SystemParametersTab.this.Selected_Configuration.setSelectedIndex((this).SystemParametersTab.this.Selected_Configuration.getModel().getSize() - 1);
                                    FortressEnv.createConfigurationPath(New_configuration_Name.getText());
                                    (this).SystemParametersTab.this.config.saveFile(New_configuration_Name.getText());
                                    New_configuration_windows.dispose();
                                    SystemParametersTab.this.setTitle((this).SystemParametersTab.this.pref.getActiveConfiguration());
                                } else {
                                    JOptionPane.showMessageDialog(null, "This configuration already exists.", null, 1);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            (this).SystemParametersTab.this.Tab.setEnabledAt(1, true);
                            (this).SystemParametersTab.this.Tab.setEnabledAt(2, true);
                            (this).SystemParametersTab.this.Tab.setEnabledAt(3, true);
                            (this).SystemParametersTab.this.Tab.setEnabledAt(4, true);
                        } else {
                            JOptionPane.showMessageDialog(null, "You must enter a name.", null, 1);
                        }
                    }
                });
                Button_New_configuration_Cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        New_configuration_windows.dispose();
                    }
                });
                New_configuration_windows.setVisible(true);
            }
        });
        Button_duplicate_configuration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                final JDialog New_configuration_windows = new JDialog(SystemParametersTab.this.WindowsParameters, "Duplicate " + SystemParametersTab.this.Selected_Configuration.getItemAt(SystemParametersTab.this.Selected_Configuration.getSelectedIndex()), true);
                New_configuration_windows.setLocationRelativeTo(SystemParametersTab.this.WindowsParameters.getParent());
                New_configuration_windows.setResizable(false);
                final JTextField Duplicate_configuration_Name = new JTextField();
                Duplicate_configuration_Name.setPreferredSize(new Dimension(200, 20));
                JLabel Duplicate_configuration_Name_Label = new JLabel("Enter a new Name:");
                New_configuration_windows.setSize(Duplicate_configuration_Name_Label.getFontMetrics(Duplicate_configuration_Name_Label.getFont()).stringWidth("Enter a new Name:") + 219, 100);
                JButton Button_Duplicate_configuration_OK = new JButton("OK");
                JButton Button_Duplicate_configuration_Cancel = new JButton("Cancel");
                JPanel p_New_configuration = new JPanel();
                p_New_configuration.setLayout(new FlowLayout(0));
                p_New_configuration.add(Duplicate_configuration_Name_Label);
                p_New_configuration.add(Duplicate_configuration_Name);
                JPanel p_Button_New_configuration = new JPanel();
                p_Button_New_configuration.setLayout(new FlowLayout(4));
                p_Button_New_configuration.add(Button_Duplicate_configuration_OK);
                p_Button_New_configuration.add(Button_Duplicate_configuration_Cancel);
                JPanel p_New_configuration_windows = new JPanel();
                GroupLayout g_New_configuration_windows = new GroupLayout(p_New_configuration_windows);
                p_New_configuration_windows.setLayout(g_New_configuration_windows);
                g_New_configuration_windows.setHorizontalGroup(g_New_configuration_windows.createParallelGroup().addComponent(p_New_configuration).addComponent(p_Button_New_configuration));
                g_New_configuration_windows.setVerticalGroup(g_New_configuration_windows.createSequentialGroup().addComponent(p_New_configuration).addComponent(p_Button_New_configuration));
                New_configuration_windows.add(p_New_configuration_windows);
                Button_Duplicate_configuration_OK.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        block5: {
                            if (!Duplicate_configuration_Name.getText().isEmpty()) {
                                try {
                                    if (!(this).SystemParametersTab.this.pref.existsConfiguration(Duplicate_configuration_Name.getText())) {
                                        FortressConfiguration.duplicateConfigurationFile((this).SystemParametersTab.this.Selected_Configuration.getItemAt((this).SystemParametersTab.this.Selected_Configuration.getSelectedIndex()), Duplicate_configuration_Name.getText());
                                        (this).SystemParametersTab.this.pref.addConfiguration(Duplicate_configuration_Name.getText());
                                        (this).SystemParametersTab.this.pref.setActiveConfiguration(Duplicate_configuration_Name.getText());
                                        (this).SystemParametersTab.this.Selected_Configuration.addItem(Duplicate_configuration_Name.getText());
                                        (this).SystemParametersTab.this.Selected_Configuration.setSelectedIndex((this).SystemParametersTab.this.Selected_Configuration.getModel().getSize() - 1);
                                        (this).SystemParametersTab.this.config.saveFile(Duplicate_configuration_Name.getText());
                                        New_configuration_windows.dispose();
                                        SystemParametersTab.this.setTitle((this).SystemParametersTab.this.pref.getActiveConfiguration());
                                        break block5;
                                    }
                                    JOptionPane.showMessageDialog(null, "This configuation already exists.", null, 1);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            } else {
                                JOptionPane.showMessageDialog(null, "You must enter a name.", null, 1);
                            }
                        }
                    }
                });
                Button_Duplicate_configuration_Cancel.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent event) {
                        New_configuration_windows.dispose();
                    }
                });
                New_configuration_windows.setVisible(true);
            }
        });
        this.Selected_Configuration.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent arg0) {
                try {
                    String select_config = (String)arg0.getItem();
                    if (select_config == null) {
                        SystemParametersTab.this.selected_configuration_validate = false;
                        return;
                    }
                    if (arg0.getStateChange() == 2) {
                        if (SystemParametersTab.this.pref.existsConfiguration(select_config)) {
                            SystemParametersTab.this.applyConfiguration();
                            FortressConfiguration ref_conf = new FortressConfiguration();
                            ref_conf.loadFile(select_config);
                            if (ref_conf.equals(SystemParametersTab.this.config)) {
                                return;
                            }
                            int result = JOptionPane.showConfirmDialog(null, "Would you like to save the configuration " + select_config + " ?", "Save & Change Configuration", 0);
                            if (result == 0) {
                                SystemParametersTab.this.config.saveFile(select_config);
                            }
                        }
                    } else {
                        SystemParametersTab.this.pref.setActiveConfiguration(select_config);
                        SystemParametersTab.this.selected_configuration_validate = true;
                        SystemParametersTab.this.config.loadFile(select_config);
                        SystemParametersTab.this.getConfiguration();
                        SystemParametersTab.this.setTitle(SystemParametersTab.this.pref.getActiveConfiguration());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        Button_delete_configuration.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    int i;
                    if (SystemParametersTab.this.Selected_Configuration.getItemAt(SystemParametersTab.this.Selected_Configuration.getSelectedIndex()) != null && (i = JOptionPane.showConfirmDialog(null, "Are you sure to delete the " + SystemParametersTab.this.Selected_Configuration.getItemAt(SystemParametersTab.this.Selected_Configuration.getSelectedIndex()) + " ?", "Confirmation", 0)) == 0) {
                        SystemParametersTab.this.pref.removeConfiguration(SystemParametersTab.this.Selected_Configuration.getItemAt(SystemParametersTab.this.Selected_Configuration.getSelectedIndex()));
                        SystemParametersTab.this.Selected_Configuration.removeItem(SystemParametersTab.this.Selected_Configuration.getSelectedItem());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (SystemParametersTab.this.Selected_Configuration.getModel().getSize() == 0) {
                    SystemParametersTab.this.Tab.setEnabledAt(1, false);
                    SystemParametersTab.this.Tab.setEnabledAt(2, false);
                    SystemParametersTab.this.Tab.setEnabledAt(3, false);
                    SystemParametersTab.this.Tab.setEnabledAt(4, false);
                    SystemParametersTab.this.selected_configuration_validate = false;
                }
            }
        });
        JButton default_path_restore_button = new JButton("Restore Path");
        default_path_restore_button.setPreferredSize(new Dimension(150, 25));
        default_path_restore_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    int result = JOptionPane.showConfirmDialog(null, "You will restore the default paths. Are you sure ?", "Restore Default Paths", 0);
                    if (result == 0) {
                        FortressPreferences default_pref = new FortressPreferences();
                        default_pref.loadDefaultFile();
                        SystemParametersTab.this.VisualCPP_path.setText(default_pref.getVisualCPPPath());
                        SystemParametersTab.this.MsBuildPath.setText(default_pref.getMsBuildPath());
                        SystemParametersTab.this.Visual_Studio_Version.getModel().setSelectedItem(default_pref.getVisualStudioVersion());
                        SystemParametersTab.this.Xerces_path.setText(default_pref.getXercesPath());
                        SystemParametersTab.this.PlanAhead_path.setText(default_pref.getPlanheadPath());
                        SystemParametersTab.this.PlanAhead_path_version.getModel().setSelectedItem(default_pref.getXilinxToolVersion());
                        SystemParametersTab.this.Xilinx_vivado_path.setText(default_pref.getXilinxVivadoPath());
                        SystemParametersTab.this.Xilinx_vivado_version.getModel().setSelectedItem(default_pref.getXilinxVivadoVersion());
                        SystemParametersTab.this.SystemC_path.setText(default_pref.getSystemCPath());
                        SystemParametersTab.this.SystemC_lib.setText(default_pref.getSystemCLibPath());
                        SystemParametersTab.this.ModelSim.setText(default_pref.getModelsimPath());
                        SystemParametersTab.this.TextEditor.setText(default_pref.getTextEditorPath());
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        JButton default_path_save_button = new JButton("Save Template Path");
        default_path_save_button.setPreferredSize(new Dimension(150, 25));
        default_path_save_button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    int result = JOptionPane.showConfirmDialog(null, "You will modify the default paths on the system configuration file in the FoRTReSS tool. Are you sure ?", "Modify Default Paths", 0);
                    if (result == 0) {
                        FortressPreferences default_pref = new FortressPreferences();
                        default_pref.loadDefaultFile();
                        default_pref.setPlanheadPath(SystemParametersTab.this.PlanAhead_path.getText());
                        default_pref.setXilinxVivadoPath(SystemParametersTab.this.Xilinx_vivado_path.getText());
                        default_pref.setSystemCPath(SystemParametersTab.this.SystemC_path.getText());
                        default_pref.setSystemCLibPath(SystemParametersTab.this.SystemC_lib.getText());
                        default_pref.setModelsimPath(SystemParametersTab.this.ModelSim.getText());
                        default_pref.setTextEditorPath(SystemParametersTab.this.TextEditor.getText());
                        default_pref.setXilinxToolVersion(SystemParametersTab.this.PlanAhead_path_version.getItemAt(SystemParametersTab.this.PlanAhead_path_version.getSelectedIndex()));
                        default_pref.setXilinxVivadoVersion(SystemParametersTab.this.Xilinx_vivado_version.getItemAt(SystemParametersTab.this.Xilinx_vivado_version.getSelectedIndex()));
                        default_pref.setVisualStudioVersion(SystemParametersTab.this.Visual_Studio_Version.getItemAt(SystemParametersTab.this.Visual_Studio_Version.getSelectedIndex()));
                        default_pref.setMsBuildPath(SystemParametersTab.this.MsBuildPath.getText());
                        default_pref.setVisualCPPPath(SystemParametersTab.this.VisualCPP_path.getText());
                        default_pref.setXercesPath(SystemParametersTab.this.Xerces_path.getText());
                        default_pref.saveDefaultPathTemplateFile();
                    }
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(null, ex.getMessage(), null, 0);
                }
                catch (JDOMException ex) {
                    ex.printStackTrace();
                }
            }
        });
        JPanel p_Label = new JPanel();
        JPanel p_Jtext = new JPanel();
        JPanel p_Jbutton = new JPanel();
        if (FortressEnv.isWindowsOS()) {
            g_Label = new GroupLayout(p_Label);
            p_Label.setLayout(g_Label);
            g_Label.setHorizontalGroup(g_Label.createParallelGroup().addComponent(PlanAhead_path_Label).addComponent(Xilinx_vivado_path_Label).addComponent(SystemC_path_Label).addComponent(SystemC_lib_Label).addComponent(ModelSim_Label).addComponent(TextEditor_Label).addComponent(MsBuildPath_Label).addComponent(VisualCPP_Label).addComponent(Xerces_path_Label));
            g_Label.setVerticalGroup(g_Label.createSequentialGroup().addComponent(PlanAhead_path_Label).addGap(25).addComponent(Xilinx_vivado_path_Label).addGap(25).addComponent(SystemC_path_Label).addGap(25).addComponent(SystemC_lib_Label).addGap(25).addComponent(ModelSim_Label).addGap(25).addComponent(TextEditor_Label).addGap(25).addComponent(MsBuildPath_Label).addGap(25).addComponent(VisualCPP_Label).addGap(25).addComponent(Xerces_path_Label));
            g_Jtext = new GroupLayout(p_Jtext);
            p_Jtext.setLayout(g_Jtext);
            g_Jtext.setHorizontalGroup(g_Jtext.createParallelGroup().addComponent(this.PlanAhead_path).addComponent(this.Xilinx_vivado_path).addComponent(this.SystemC_path).addComponent(this.SystemC_lib).addComponent(this.ModelSim).addComponent(this.TextEditor).addComponent(this.MsBuildPath).addComponent(this.VisualCPP_path).addComponent(this.Xerces_path));
            g_Jtext.setVerticalGroup(g_Jtext.createSequentialGroup().addComponent(this.PlanAhead_path).addGap(16).addComponent(this.Xilinx_vivado_path).addGap(16).addComponent(this.SystemC_path).addGap(16).addComponent(this.SystemC_lib).addGap(17).addComponent(this.ModelSim).addGap(15).addComponent(this.TextEditor).addGap(15).addComponent(this.MsBuildPath).addGap(15).addComponent(this.VisualCPP_path).addGap(15).addComponent(this.Xerces_path));
            p_PlanAhead_path_version = new JPanel();
            p_PlanAhead_path_version.setLayout(new FlowLayout(0));
            p_PlanAhead_path_version.add(PlanAhead_path_version_Label);
            p_PlanAhead_path_version.add(this.PlanAhead_path_version);
            JPanel p_Xilinx_vivado_version = new JPanel();
            p_Xilinx_vivado_version.setLayout(new FlowLayout(0));
            p_Xilinx_vivado_version.add(Xilinx_vivado_version_Label);
            p_Xilinx_vivado_version.add(this.Xilinx_vivado_version);
            JPanel p_Visual_Studio_version = new JPanel();
            p_Visual_Studio_version.setLayout(new FlowLayout(0));
            p_Visual_Studio_version.add(Visual_Studio_Version_Label);
            p_Visual_Studio_version.add(this.Visual_Studio_Version);
            JPanel p_Jbutton_PlanAhead_path = new JPanel();
            p_Jbutton_PlanAhead_path.setLayout(new FlowLayout(0));
            p_Jbutton_PlanAhead_path.add(Button_PlanAhead_path);
            p_Jbutton_PlanAhead_path.add(p_PlanAhead_path_version);
            JPanel p_Jbutton_Xilinx_vivado_path = new JPanel();
            p_Jbutton_Xilinx_vivado_path.setLayout(new FlowLayout(0));
            p_Jbutton_Xilinx_vivado_path.add(Button_Xilinx_vivado_path);
            p_Jbutton_Xilinx_vivado_path.add(p_Xilinx_vivado_version);
            JPanel p_Jbutton_Visual_Studio_version = new JPanel();
            p_Jbutton_Visual_Studio_version.setLayout(new FlowLayout(0));
            p_Jbutton_Visual_Studio_version.add(Button_MsBuildPath);
            p_Jbutton_Visual_Studio_version.add(p_Visual_Studio_version);
            JPanel p_Jbutton_SystemC_path = new JPanel();
            p_Jbutton_SystemC_path.setLayout(new FlowLayout(0));
            p_Jbutton_SystemC_path.add(Button_SystemC_path);
            JPanel p_Jbutton_VisualCPP_path = new JPanel();
            p_Jbutton_VisualCPP_path.setLayout(new FlowLayout(0));
            p_Jbutton_VisualCPP_path.add(Button_VisualCPPPath);
            JPanel p_Jbutton_Xerces_path = new JPanel();
            p_Jbutton_Xerces_path.setLayout(new FlowLayout(0));
            p_Jbutton_Xerces_path.add(Button_Xerces_path);
            JPanel p_Jbutton_ModelSim = new JPanel();
            p_Jbutton_ModelSim.setLayout(new FlowLayout(0));
            p_Jbutton_ModelSim.add(Button_ModelSim);
            JPanel p_Jbutton_TextEditor = new JPanel();
            p_Jbutton_TextEditor.setLayout(new FlowLayout(0));
            p_Jbutton_TextEditor.add(Button_TextEditor);
            JPanel p_Jbutton_SystemC_lib = new JPanel();
            p_Jbutton_SystemC_lib.setLayout(new FlowLayout(0));
            p_Jbutton_SystemC_lib.add(Button_SystemC_lib);
            GroupLayout g_Jbutton = new GroupLayout(p_Jbutton);
            p_Jbutton.setLayout(g_Jbutton);
            g_Jbutton.setHorizontalGroup(g_Jbutton.createParallelGroup().addComponent(p_Jbutton_PlanAhead_path).addComponent(p_Jbutton_Xilinx_vivado_path).addComponent(p_Jbutton_SystemC_path).addComponent(p_Jbutton_SystemC_lib).addComponent(p_Jbutton_ModelSim).addComponent(p_Jbutton_TextEditor).addComponent(p_Jbutton_Visual_Studio_version).addComponent(p_Jbutton_VisualCPP_path).addComponent(p_Jbutton_Xerces_path));
            g_Jbutton.setVerticalGroup(g_Jbutton.createSequentialGroup().addComponent(p_Jbutton_PlanAhead_path).addComponent(p_Jbutton_Xilinx_vivado_path).addComponent(p_Jbutton_SystemC_path).addGap(5).addComponent(p_Jbutton_SystemC_lib).addGap(5).addComponent(p_Jbutton_ModelSim).addGap(5).addComponent(p_Jbutton_TextEditor).addComponent(p_Jbutton_Visual_Studio_version).addComponent(p_Jbutton_VisualCPP_path).addComponent(p_Jbutton_Xerces_path));
        } else if (FortressEnv.isLinuxOS()) {
            g_Label = new GroupLayout(p_Label);
            p_Label.setLayout(g_Label);
            g_Label.setHorizontalGroup(g_Label.createParallelGroup().addComponent(PlanAhead_path_Label).addComponent(Xilinx_vivado_path_Label).addComponent(SystemC_path_Label).addComponent(SystemC_lib_Label).addComponent(ModelSim_Label).addComponent(TextEditor_Label).addComponent(Xerces_path_Label));
            g_Label.setVerticalGroup(g_Label.createSequentialGroup().addComponent(PlanAhead_path_Label).addGap(25).addComponent(Xilinx_vivado_path_Label).addGap(25).addComponent(SystemC_path_Label).addGap(25).addComponent(SystemC_lib_Label).addGap(25).addComponent(ModelSim_Label).addGap(25).addComponent(TextEditor_Label).addGap(25).addComponent(Xerces_path_Label));
            g_Jtext = new GroupLayout(p_Jtext);
            p_Jtext.setLayout(g_Jtext);
            g_Jtext.setHorizontalGroup(g_Jtext.createParallelGroup().addComponent(this.PlanAhead_path).addComponent(this.Xilinx_vivado_path).addComponent(this.SystemC_path).addComponent(this.SystemC_lib).addComponent(this.ModelSim).addComponent(this.TextEditor).addComponent(this.Xerces_path));
            g_Jtext.setVerticalGroup(g_Jtext.createSequentialGroup().addGap(4).addComponent(this.PlanAhead_path).addGap(16).addComponent(this.Xilinx_vivado_path).addGap(16).addComponent(this.SystemC_path).addGap(17).addComponent(this.SystemC_lib).addGap(17).addComponent(this.ModelSim).addGap(15).addComponent(this.TextEditor).addGap(15).addComponent(this.Xerces_path));
            p_PlanAhead_path_version = new JPanel();
            p_PlanAhead_path_version.setLayout(new FlowLayout(0));
            p_PlanAhead_path_version.add(PlanAhead_path_version_Label);
            p_PlanAhead_path_version.add(this.PlanAhead_path_version);
            JPanel p_Jbutton_PlanAhead_path = new JPanel();
            p_Jbutton_PlanAhead_path.add((Component)Button_PlanAhead_path, "West");
            p_Jbutton_PlanAhead_path.add((Component)p_PlanAhead_path_version, "Center");
            JPanel p_Xilinx_vivado_version = new JPanel();
            p_Xilinx_vivado_version.setLayout(new FlowLayout(0));
            p_Xilinx_vivado_version.add(Xilinx_vivado_version_Label);
            p_Xilinx_vivado_version.add(this.Xilinx_vivado_version);
            JPanel p_Jbutton_Xilinx_vivado_path = new JPanel();
            p_Jbutton_Xilinx_vivado_path.add((Component)Button_Xilinx_vivado_path, "West");
            p_Jbutton_Xilinx_vivado_path.add((Component)p_Xilinx_vivado_version, "Center");
            JPanel p_Jbutton_SystemC_path = new JPanel();
            p_Jbutton_SystemC_path.setLayout(new FlowLayout(0));
            p_Jbutton_SystemC_path.add(Button_SystemC_path);
            JPanel p_Jbutton_ModelSim = new JPanel();
            p_Jbutton_ModelSim.setLayout(new FlowLayout(0));
            p_Jbutton_ModelSim.add(Button_ModelSim);
            JPanel p_Jbutton_TextEditor = new JPanel();
            p_Jbutton_TextEditor.setLayout(new FlowLayout(0));
            p_Jbutton_TextEditor.add(Button_TextEditor);
            JPanel p_Jbutton_Xerces_path = new JPanel();
            p_Jbutton_Xerces_path.setLayout(new FlowLayout(0));
            p_Jbutton_Xerces_path.add(Button_Xerces_path);
            JPanel p_Jbutton_SystemC_lib = new JPanel();
            p_Jbutton_SystemC_lib.setLayout(new FlowLayout(0));
            p_Jbutton_SystemC_lib.add(Button_SystemC_lib);
            GroupLayout g_Jbutton = new GroupLayout(p_Jbutton);
            p_Jbutton.setLayout(g_Jbutton);
            g_Jbutton.setHorizontalGroup(g_Jbutton.createParallelGroup().addComponent(p_Jbutton_PlanAhead_path).addComponent(p_Jbutton_Xilinx_vivado_path).addComponent(p_Jbutton_SystemC_path).addComponent(p_Jbutton_SystemC_lib).addComponent(p_Jbutton_ModelSim).addComponent(p_Jbutton_TextEditor).addComponent(p_Jbutton_Xerces_path));
            g_Jbutton.setVerticalGroup(g_Jbutton.createSequentialGroup().addGap(1).addComponent(p_Jbutton_PlanAhead_path).addComponent(p_Jbutton_Xilinx_vivado_path).addComponent(p_Jbutton_SystemC_path).addGap(6).addComponent(p_Jbutton_SystemC_lib).addGap(5).addComponent(p_Jbutton_ModelSim).addGap(5).addComponent(p_Jbutton_TextEditor).addGap(5).addComponent(p_Jbutton_Xerces_path));
        }
        JPanel p_Path_select = new JPanel();
        p_Path_select.setBorder(BorderFactory.createTitledBorder("Path"));
        p_Path_select.setLayout(new FlowLayout(0));
        p_Path_select.add(p_Label);
        p_Path_select.add(p_Jtext);
        p_Path_select.add(p_Jbutton);
        JPanel p_Path_default = new JPanel();
        p_Path_default.setLayout(new FlowLayout(2));
        p_Path_default.add(default_path_restore_button);
        p_Path_default.add(default_path_save_button);
        JPanel p_space = new JPanel();
        JPanel p_SystemParameters = new JPanel();
        p_SystemParameters.setPreferredSize(new Dimension(800, 450));
        GroupLayout g_SystemParameters = new GroupLayout(p_SystemParameters);
        p_SystemParameters.setLayout(g_SystemParameters);
        g_SystemParameters.setHorizontalGroup(g_SystemParameters.createParallelGroup().addComponent(p_Path_select).addComponent(p_Path_default).addComponent(p_configuration).addComponent(p_other).addComponent(p_space));
        g_SystemParameters.setVerticalGroup(g_SystemParameters.createSequentialGroup().addComponent(p_Path_select).addComponent(p_Path_default).addComponent(p_configuration).addComponent(p_other).addGap(100).addComponent(p_space));
        JScrollPane ScrollPane_SystemParameters = new JScrollPane(p_SystemParameters);
        this.Tab.addTab("System Parameters", ScrollPane_SystemParameters);
    }

    public boolean getselected_configuration_validate() {
        return this.selected_configuration_validate;
    }

    public void getonglet_configuration() {
        this.T_FoRTReSSParameters.CreateFoRTReSSParametersTab();
        this.T_ProcessorParameters.CreateProcessorParametersTab();
        this.T_ApplicationParameters.CreateApplicationParametersTab();
        this.T_SynthesisReportNetlist.CreateSynthesisReportNetlistTab();
        this.Tab.setEnabledAt(1, this.selected_configuration_validate);
        this.Tab.setEnabledAt(2, this.selected_configuration_validate);
        this.Tab.setEnabledAt(3, this.selected_configuration_validate);
        this.Tab.setEnabledAt(4, true);
    }

    public void getPreference() {
        try {
            this.VisualCPP_path.setText(this.pref.getVisualCPPPath());
            this.MsBuildPath.setText(this.pref.getMsBuildPath());
            this.Visual_Studio_Version.getModel().setSelectedItem(this.pref.getVisualStudioVersion());
            this.Xerces_path.setText(this.pref.getXercesPath());
            this.PlanAhead_path.setText(this.pref.getPlanheadPath());
            this.PlanAhead_path_version.getModel().setSelectedItem(this.pref.getXilinxToolVersion());
            this.Xilinx_vivado_path.setText(this.pref.getXilinxVivadoPath());
            this.Xilinx_vivado_version.getModel().setSelectedItem(this.pref.getXilinxVivadoVersion());
            this.SystemC_path.setText(this.pref.getSystemCPath());
            this.SystemC_lib.setText(this.pref.getSystemCLibPath());
            this.ModelSim.setText(this.pref.getModelsimPath());
            this.TextEditor.setText(this.pref.getTextEditorPath());
            this.Check_verbose_mode.setSelected(this.pref.isVerboseMode());
            if (this.Selected_Configuration.getItemAt(this.Selected_Configuration.getSelectedIndex()) != null) {
                this.config.loadFile(this.pref.getActiveConfiguration());
                this.getConfiguration();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void applyPreference() {
        try {
            this.pref.setPlanheadPath(this.PlanAhead_path.getText());
            this.pref.setXilinxVivadoPath(this.Xilinx_vivado_path.getText());
            this.pref.setSystemCPath(this.SystemC_path.getText());
            this.pref.setSystemCLibPath(this.SystemC_lib.getText());
            this.pref.setModelsimPath(this.ModelSim.getText());
            this.pref.setTextEditorPath(this.TextEditor.getText());
            this.pref.setXilinxToolVersion(this.PlanAhead_path_version.getItemAt(this.PlanAhead_path_version.getSelectedIndex()));
            this.pref.setXilinxVivadoVersion(this.Xilinx_vivado_version.getItemAt(this.Xilinx_vivado_version.getSelectedIndex()));
            this.pref.setVisualStudioVersion(this.Visual_Studio_Version.getItemAt(this.Visual_Studio_Version.getSelectedIndex()));
            this.pref.setMsBuildPath(this.MsBuildPath.getText());
            this.pref.setVisualCPPPath(this.VisualCPP_path.getText());
            this.pref.setXercesPath(this.Xerces_path.getText());
            this.pref.setVerboseMode(this.Check_verbose_mode.isSelected());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getConfiguration() {
        this.T_FoRTReSSParameters.getFortressParameters();
        this.T_ApplicationParameters.getApplicationParameter();
        this.T_ProcessorParameters.getProcessorParameter();
    }

    public void getDefaultConfiguration() {
        try {
            this.config.loadDefaultFile();
            this.getConfiguration();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void applyConfiguration() {
        try {
            this.T_FoRTReSSParameters.applyFortressParameters();
            this.T_ProcessorParameters.applyProcessorParameters();
            this.T_ApplicationParameters.applyApplicatioParameters();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public FortressConfiguration getselected_configuration() {
        return this.config;
    }

    private void setPlanAhead_path_versionList() {
        Vector<String> Report_list = FortressPreferences.getXilinxToolVersionList();
        Iterator i = Report_list.iterator();
        i = Report_list.iterator();
        if (Report_list != null) {
            while (i.hasNext()) {
                String x = (String)i.next();
                if (x == null) continue;
                this.PlanAhead_path_version.addItem(x);
            }
        }
    }

    private void setXilinx_vivado_versionList() {
        Vector<String> Report_list = FortressPreferences.getXilinxVivadolVersionList();
        Iterator i = Report_list.iterator();
        i = Report_list.iterator();
        if (Report_list != null) {
            while (i.hasNext()) {
                String x = (String)i.next();
                if (x == null) continue;
                this.Xilinx_vivado_version.addItem(x);
            }
        }
    }

    private void setVisual_Studio_VersionList() {
        Vector<String> Report_list = FortressPreferences.getVisualStudioVersionList();
        Iterator i = Report_list.iterator();
        i = Report_list.iterator();
        if (Report_list != null) {
            while (i.hasNext()) {
                String x = (String)i.next();
                if (x == null) continue;
                this.Visual_Studio_Version.addItem(x);
            }
        }
    }

    private File getPathFile(String path) {
        File f = new File(path);
        if (f.exists()) {
            if (f.isFile()) {
                f = f.getParentFile();
            }
        } else {
            f = new File("/");
        }
        return f;
    }
}

