/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.xml.ConfigPowerFctPoint;
import fortress.xml.ConfigPowerGroup;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PowerGroupInputDialog
extends JDialog
implements ActionListener,
ListSelectionListener {
    JTextField group_name_textField;
    JFormattedTextField nominal_voltage_textField;
    JFormattedTextField nominal_freq_textField;
    JCheckBox common_domain_checkbox;
    int selectedListIndex;
    DefaultListModel<ConfigPowerFctPoint> Model_power_fct_list;
    JList<ConfigPowerFctPoint> power_fct_list;
    JFormattedTextField curr_voltage_textField;
    JFormattedTextField curr_freq_textField;
    JButton addButton;
    JButton deleteButton;
    JButton okButton;
    JButton cancelButton;
    boolean cancelAction;

    public PowerGroupInputDialog(Frame WindowsParameters, String title) {
        super(WindowsParameters, title, true);
        this.createDialog(WindowsParameters);
    }

    public PowerGroupInputDialog(Frame WindowsParameters, String title, ConfigPowerGroup powerGroup) {
        super(WindowsParameters, title, true);
        this.createDialog(WindowsParameters);
        this.setPowerGroup(powerGroup);
    }

    public void setPowerGroup(ConfigPowerGroup powerGroup) {
        this.group_name_textField.setText(powerGroup.getGroupName());
        this.nominal_voltage_textField.setValue(Float.valueOf(powerGroup.getNominalFctPoint().getVoltage()));
        this.nominal_freq_textField.setValue(Float.valueOf(powerGroup.getNominalFctPoint().getFrequency()));
        this.common_domain_checkbox.setSelected(powerGroup.isCommonDomain());
        this.power_fct_list.removeAll();
        Vector<ConfigPowerFctPoint> powerFctList = powerGroup.getctPointList();
        int i = 0;
        while (i < powerFctList.size()) {
            this.Model_power_fct_list.addElement(powerFctList.elementAt(i));
            ++i;
        }
        if (!this.Model_power_fct_list.isEmpty()) {
            this.curr_voltage_textField.setEditable(true);
            this.curr_freq_textField.setEditable(true);
        }
    }

    public ConfigPowerGroup getPowerGroup() {
        ConfigPowerGroup newgroup = new ConfigPowerGroup(this.group_name_textField.getText());
        newgroup.setCommonDomain(this.common_domain_checkbox.isSelected());
        newgroup.setNominalFctPoint(new ConfigPowerFctPoint(((Float)this.nominal_voltage_textField.getValue()).floatValue(), ((Float)this.nominal_freq_textField.getValue()).floatValue()));
        Vector<ConfigPowerFctPoint> powerFctList = new Vector<ConfigPowerFctPoint>();
        int i = 0;
        while (i < this.Model_power_fct_list.size()) {
            powerFctList.add(this.Model_power_fct_list.elementAt(i));
            ++i;
        }
        newgroup.setFctPointList(powerFctList);
        return newgroup;
    }

    public void createDialog(Frame WindowsParameters) {
        this.selectedListIndex = -1;
        Point p = WindowsParameters.getLocation();
        this.setLocation(p.x + 200, p.y + 200);
        this.setResizable(false);
        this.cancelAction = true;
        JPanel group_name_panel = new JPanel();
        FlowLayout info_panel_layout = new FlowLayout(0);
        group_name_panel.setLayout(info_panel_layout);
        JLabel info = new JLabel();
        info.setText("Group Name : ");
        info.setPreferredSize(new Dimension(90, 20));
        group_name_panel.add(info);
        this.group_name_textField = new JTextField("");
        this.group_name_textField.setPreferredSize(new Dimension(170, 20));
        group_name_panel.add(this.group_name_textField);
        JPanel common_domain_panel = new JPanel();
        FlowLayout common_domain_panel_layout = new FlowLayout(0);
        common_domain_panel.setLayout(common_domain_panel_layout);
        this.common_domain_checkbox = new JCheckBox("Common Domain ");
        this.common_domain_checkbox.setPreferredSize(new Dimension(200, 20));
        common_domain_panel.add(this.common_domain_checkbox);
        JPanel nominal_pt_panel = new JPanel();
        FlowLayout nominal_pt_layout = new FlowLayout(0);
        nominal_pt_panel.setLayout(nominal_pt_layout);
        nominal_pt_panel.setBorder(BorderFactory.createTitledBorder("Nominal Fct. Point"));
        info = new JLabel();
        info.setText("Voltage : ");
        info.setPreferredSize(new Dimension(60, 20));
        nominal_pt_panel.add(info);
        this.nominal_voltage_textField = new JFormattedTextField(new Float(0.0f));
        this.nominal_voltage_textField.setPreferredSize(new Dimension(50, 20));
        nominal_pt_panel.add(this.nominal_voltage_textField);
        info = new JLabel();
        info.setText("Frequency : ");
        info.setPreferredSize(new Dimension(75, 20));
        nominal_pt_panel.add(info);
        this.nominal_freq_textField = new JFormattedTextField(new Float(0.0f));
        this.nominal_freq_textField.setPreferredSize(new Dimension(90, 20));
        nominal_pt_panel.add(this.nominal_freq_textField);
        JPanel current_pt_panel = new JPanel();
        FlowLayout current_pt_layout = new FlowLayout(0);
        current_pt_panel.setLayout(current_pt_layout);
        current_pt_panel.setBorder(BorderFactory.createTitledBorder("Current Fct. Point"));
        info = new JLabel();
        info.setText("Voltage : ");
        info.setPreferredSize(new Dimension(60, 20));
        current_pt_panel.add(info);
        this.curr_voltage_textField = new JFormattedTextField(new Float(0.0f));
        this.curr_voltage_textField.setPreferredSize(new Dimension(50, 20));
        current_pt_panel.add(this.curr_voltage_textField);
        info = new JLabel();
        info.setText("Frequency : ");
        info.setPreferredSize(new Dimension(75, 20));
        current_pt_panel.add(info);
        this.curr_freq_textField = new JFormattedTextField(new Float(0.0f));
        this.curr_freq_textField.setPreferredSize(new Dimension(90, 20));
        current_pt_panel.add(this.curr_freq_textField);
        this.curr_voltage_textField.setEditable(false);
        this.curr_freq_textField.setEditable(false);
        this.addButton = new JButton("Add");
        this.addButton.addActionListener(this);
        this.deleteButton = new JButton("Delete");
        this.deleteButton.addActionListener(this);
        JPanel b_panel = new JPanel();
        GridLayout b_panel_layout = new GridLayout(1, 0);
        b_panel_layout.setHgap(10);
        b_panel.setLayout(b_panel_layout);
        b_panel.add(this.addButton);
        b_panel.add(this.deleteButton);
        this.Model_power_fct_list = new DefaultListModel();
        JPanel point_list_panel = new JPanel();
        FlowLayout point_list_layout = new FlowLayout(1);
        point_list_panel.setLayout(point_list_layout);
        point_list_panel.setBorder(BorderFactory.createTitledBorder("Fct Point List"));
        this.power_fct_list = new JList<ConfigPowerFctPoint>(this.Model_power_fct_list);
        JScrollPane point_list_list_scroller = new JScrollPane(this.power_fct_list);
        point_list_list_scroller.setPreferredSize(new Dimension(250, 80));
        point_list_panel.add(point_list_list_scroller);
        this.power_fct_list.addListSelectionListener(this);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel button_panel = new JPanel();
        GridLayout button_panel_layout = new GridLayout(1, 0);
        button_panel_layout.setHgap(10);
        button_panel.setLayout(button_panel_layout);
        button_panel.add(this.cancelButton);
        button_panel.add(this.okButton);
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraintLayout = new GridBagConstraints();
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 0;
        JPanel page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(group_name_panel);
        this.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 1;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(common_domain_panel);
        this.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 2;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(nominal_pt_panel);
        this.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 3;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(current_pt_panel);
        this.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 4;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(b_panel);
        this.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 5;
        page_info_panel = new JPanel();
        page_info_panel.setLayout(new FlowLayout(0));
        page_info_panel.add(point_list_panel);
        this.add((Component)page_info_panel, constraintLayout);
        constraintLayout.fill = 1;
        constraintLayout.gridx = 0;
        constraintLayout.gridy = 6;
        JPanel page_end_panel = new JPanel();
        page_end_panel.setLayout(new FlowLayout(2));
        page_end_panel.add(button_panel);
        this.add((Component)page_end_panel, constraintLayout);
        this.pack();
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.addButton) {
            this.Model_power_fct_list.addElement(new ConfigPowerFctPoint(0.0f, 0.0f));
            this.power_fct_list.setSelectedIndex(this.Model_power_fct_list.getSize() - 1);
        } else if (event.getSource() == this.deleteButton) {
            int index = this.power_fct_list.getSelectedIndex();
            if (index != -1) {
                this.Model_power_fct_list.remove(index);
            }
        } else if (event.getSource() == this.okButton) {
            this.cancelAction = false;
            this.dispose();
        } else if (event.getSource() == this.cancelButton) {
            this.cancelAction = true;
            this.dispose();
        }
    }

    public boolean isCancelled() {
        return this.cancelAction;
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        if (arg0.getValueIsAdjusting()) {
            return;
        }
        if (this.Model_power_fct_list.isEmpty()) {
            this.selectedListIndex = -1;
            this.curr_voltage_textField.setEditable(false);
            this.curr_freq_textField.setEditable(false);
            this.curr_voltage_textField.setValue(0);
            this.curr_freq_textField.setValue(0);
        } else {
            ConfigPowerFctPoint cpfp;
            if (this.selectedListIndex != -1) {
                cpfp = this.Model_power_fct_list.getElementAt(this.selectedListIndex);
                cpfp.setVoltage(((Float)this.curr_voltage_textField.getValue()).floatValue());
                cpfp.setFrequency(((Float)this.curr_freq_textField.getValue()).floatValue());
            }
            this.curr_voltage_textField.setEditable(true);
            this.curr_freq_textField.setEditable(true);
            cpfp = this.power_fct_list.getSelectedValue();
            this.curr_voltage_textField.setValue(Float.valueOf(cpfp.getVoltage()));
            this.curr_freq_textField.setValue(Float.valueOf(cpfp.getFrequency()));
            this.selectedListIndex = this.power_fct_list.getSelectedIndex();
        }
    }
}

