/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import fortress.xml.FortressPreferences;
import fortress.xml.FortressProject;
import java.util.Collections;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.console.MessageConsoleStream;

public class InputDialogOpenProject
extends Dialog {
    public InputDialogOpenProject(Display display, String title) {
        this(display, 67680, title);
    }

    public InputDialogOpenProject(Display display, int style, String title) {
        super(new Shell(display), style);
        this.setText(title);
    }

    public void open() {
        final Shell shell = new Shell(this.getParent(), this.getStyle());
        shell.setText("Open Project");
        Composite composite = new Composite((Composite)shell, 2048);
        composite.setBounds(0, 0, 510, 110);
        Label ProjectLocation_label = new Label(composite, 0);
        ProjectLocation_label.setText("Project Location : ");
        ProjectLocation_label.setBounds(10, 10, 200, 20);
        final Combo ProjectLocation = new Combo(composite, 0);
        ProjectLocation.setBounds(10, 35, 400, 20);
        this.setComboBox(ProjectLocation);
        ProjectLocation.select(0);
        Button Browse = new Button(composite, 0);
        Browse.setText("Browse");
        Browse.setBounds(425, 34, 70, 25);
        Button ok = new Button(composite, 0);
        ok.setText("OK");
        ok.setBounds(350, 70, 70, 25);
        Button cancel = new Button(composite, 8);
        cancel.setText("Cancel");
        cancel.setBounds(425, 70, 70, 25);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
                String project_path = ProjectLocation.getItem(ProjectLocation.getSelectionIndex());
                if (!FortressEnv.isExistFile(project_path)) {
                    JOptionPane.showMessageDialog(null, "This project does not exist !", null, 0);
                    shell.close();
                    return;
                }
                try {
                    FortressEnv.closeApplicationDiagram();
                    FortressProject fp = new FortressProject();
                    fp.addProjectPath(project_path);
                    FortressEnv.setProjectPath(project_path);
                    fp.saveFile();
                    console.println("Current Project Path : " + project_path);
                    FortressPreferences pref = new FortressPreferences();
                    pref.loadFile();
                    FortressEnv.openApplicationDiagram();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                shell.close();
            }
        });
        Browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
                FileDialog fDial = new FileDialog(shell, 4096);
                fDial.setText("Select Project");
                String[] extention = new String[]{"*.prj"};
                fDial.setFilterExtensions(extention);
                fDial.setFilterPath(FortressEnv.getProjectPath());
                fDial.open();
                if (!fDial.getFilterPath().isEmpty()) {
                    if (!InputDialogOpenProject.this.pathExist(ProjectLocation, fDial.getFilterPath())) {
                        ProjectLocation.add(fDial.getFilterPath());
                    }
                    ProjectLocation.select(ProjectLocation.indexOf(fDial.getFilterPath()));
                    console.println(fDial.getFilterPath());
                }
            }
        });
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                shell.close();
            }
        });
        shell.pack();
        Rectangle shellBounds = this.getParent().getBounds();
        Point dialogSize = shell.getSize();
        shell.setLocation(shellBounds.x + (shellBounds.width - dialogSize.x) / 2, shellBounds.y + (shellBounds.height - dialogSize.y) / 2);
        shell.open();
        Display display = this.getParent().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    private void setComboBox(Combo combo) {
        try {
            FortressProject fp = new FortressProject();
            Vector<String> Report_list = fp.getProjectPath();
            Collections.reverse(Report_list);
            Iterator i = Report_list.iterator();
            i = Report_list.iterator();
            if (Report_list != null) {
                while (i.hasNext()) {
                    String x = (String)i.next();
                    if (x == null) continue;
                    combo.add(x);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean pathExist(Combo ProjectLocation, String ProjectPath) {
        int i = 0;
        i = 0;
        while (i < ProjectLocation.getItemCount()) {
            if (ProjectLocation.getItem(i).equals(ProjectPath)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

