/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands;

import fortress.env.FortressEnv;
import fortress.xml.DeviceCell;
import fortress.xml.DevicePackage;
import fortress.xml.FPGAConstraints;
import fortress.xml.FPGAInterfaceConstraints;
import fortress.xml.FPGAStaticConstraints;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressDeviceLibrary;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.jdom.JDOMException;

public class FPGAInputDialog
extends JDialog
implements ActionListener,
FocusListener,
KeyListener {
    final int ROW_WIDTH = 60;
    final int COLUMN_WIDTH = 10;
    FortressConfiguration config;
    DevicePackage devicePkg;
    FpgaCellRenderer fpgaCellRenderer;
    JLabel dyn_info;
    JButton okButton;
    JButton cancelButton;
    JToggleButton addStaticButton;
    JToggleButton removeButton;
    JToggleButton noActionButton;
    JToggleButton addInterfaceButton;
    JButton removeAllStaticAreaButton;
    JComboBox<String> posInterfaceComboBox;
    JComboBox<String> typeInterfaceTextField;
    FPGAModel fpgaModel;
    JTable fpga;

    public FPGAInputDialog(Frame WindowsParameters, FortressConfiguration config) throws Exception {
        super(WindowsParameters, "Static & Interface Constraints", true);
        this.config = config;
        FortressDeviceLibrary lib = FortressEnv.getFortressDeviceLibrary();
        this.devicePkg = lib.getDevicePackage(config.getSelectedDevice());
        if (this.devicePkg == null) {
            throw new Exception("No Device Found : " + config.getSelectedDevice());
        }
        try {
            Point p = WindowsParameters.getLocation();
            this.setLocation(p.x + 200, p.y);
            this.setResizable(true);
            JPanel info_panel = new JPanel();
            FlowLayout info_panel_layout = new FlowLayout(0);
            info_panel_layout.setHgap(20);
            info_panel_layout.setVgap(1);
            info_panel.setLayout(info_panel_layout);
            JLabel info = new JLabel();
            info.setText("Device : " + config.getSelectedFullDeviceName().toUpperCase() + " (" + this.devicePkg.getSociety() + ")");
            info_panel.add(info);
            this.dyn_info = new JLabel();
            this.dyn_info.setText("");
            info_panel.add(this.dyn_info);
            JPanel menu_panel = new JPanel();
            FlowLayout menu_panel_layout = new FlowLayout(0);
            menu_panel.setLayout(menu_panel_layout);
            menu_panel_layout.setHgap(10);
            menu_panel_layout.setVgap(1);
            JPanel static_menu_panel = new JPanel();
            static_menu_panel.setBorder(BorderFactory.createTitledBorder("Static"));
            this.addStaticButton = new JToggleButton(new ImageIcon(FortressEnv.getImageFile("calendar-edit-icon.png")));
            this.addStaticButton.setToolTipText("Add Static Constraints");
            this.addStaticButton.setSelected(false);
            this.addStaticButton.addActionListener(this);
            static_menu_panel.add(this.addStaticButton);
            this.removeAllStaticAreaButton = new JButton(new ImageIcon(FortressEnv.getImageFile("data-delete-icon.png")));
            this.removeAllStaticAreaButton.setToolTipText("Delete All Static Cell(s)");
            this.removeAllStaticAreaButton.setSelected(false);
            this.removeAllStaticAreaButton.addActionListener(this);
            static_menu_panel.add(this.removeAllStaticAreaButton);
            menu_panel.add(static_menu_panel);
            JPanel common_menu_panel = new JPanel();
            common_menu_panel.setBorder(BorderFactory.createTitledBorder("Common"));
            this.removeButton = new JToggleButton(new ImageIcon(FortressEnv.getImageFile("eraser-icon.png")));
            this.removeButton.setToolTipText("Delete Constraint(s)");
            this.removeButton.setSelected(false);
            this.removeButton.addActionListener(this);
            common_menu_panel.add(this.removeButton);
            this.noActionButton = new JToggleButton(new ImageIcon(FortressEnv.getImageFile("cursor-icon.png")));
            this.noActionButton.setSelected(true);
            this.noActionButton.addActionListener(this);
            common_menu_panel.add(this.noActionButton);
            menu_panel.add(common_menu_panel);
            JPanel interface_menu_panel = new JPanel();
            interface_menu_panel.setBorder(BorderFactory.createTitledBorder("Interface"));
            this.addInterfaceButton = new JToggleButton(new ImageIcon(FortressEnv.getImageFile("calendar-edit-icon.png")));
            this.addInterfaceButton.setToolTipText("Add Interface Constraints");
            this.addInterfaceButton.setSelected(false);
            this.addInterfaceButton.addActionListener(this);
            interface_menu_panel.add(this.addInterfaceButton);
            this.posInterfaceComboBox = new JComboBox();
            Vector<String> v = FortressConfiguration.getFPGAInterfacePositionList();
            int i = 0;
            while (i < v.size()) {
                this.posInterfaceComboBox.addItem(v.elementAt(i));
                ++i;
            }
            this.posInterfaceComboBox.setEnabled(false);
            interface_menu_panel.add(this.posInterfaceComboBox);
            this.posInterfaceComboBox.addActionListener(this);
            this.typeInterfaceTextField = new JComboBox();
            this.typeInterfaceTextField.setEditable(true);
            this.typeInterfaceTextField.setToolTipText("Example : AXI & PLB");
            this.typeInterfaceTextField.setPreferredSize(new Dimension(150, 25));
            this.typeInterfaceTextField.setEnabled(false);
            this.typeInterfaceTextField.addItem("AXI4");
            this.typeInterfaceTextField.addItem("AXI4-MASTER");
            this.typeInterfaceTextField.addItem("AXI4-SLAVE");
            this.typeInterfaceTextField.addItem("AXI4-STREAM");
            this.typeInterfaceTextField.addItem("PLB");
            this.typeInterfaceTextField.addItem("PLB-MASTER");
            this.typeInterfaceTextField.addItem("PLB-SLAVE");
            this.typeInterfaceTextField.setSelectedIndex(0);
            this.typeInterfaceTextField.addActionListener(this);
            interface_menu_panel.add(this.typeInterfaceTextField);
            menu_panel.add(interface_menu_panel);
            ButtonGroup buttonsGroup = new ButtonGroup();
            buttonsGroup.add(this.addStaticButton);
            buttonsGroup.add(this.removeButton);
            buttonsGroup.add(this.noActionButton);
            buttonsGroup.add(this.addInterfaceButton);
            this.okButton = new JButton("OK");
            this.okButton.addActionListener(this);
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(this);
            JPanel button_panel = new JPanel();
            GridLayout button_panel_layout = new GridLayout(0, 2);
            button_panel_layout.setHgap(10);
            button_panel.setLayout(button_panel_layout);
            button_panel.add(this.cancelButton);
            button_panel.add(this.okButton);
            this.fpgaModel = new FPGAModel(this.devicePkg);
            this.fpga = new JTable(this.fpgaModel);
            this.fpga.setShowHorizontalLines(false);
            this.fpga.setShowVerticalLines(false);
            this.fpga.setBackground(Color.BLACK);
            this.fpga.setTableHeader(null);
            this.fpgaCellRenderer = new FpgaCellRenderer();
            this.fpga.setAutoResizeMode(0);
            JScrollPane fpga_scroll = new JScrollPane(this.fpga, 20, 30);
            int width = this.fpga.getColumnCount() * 10;
            int height = this.fpga.getRowCount() * 60;
            if (width > 800) {
                width = 800;
            }
            if (height > 600) {
                height = 600;
            }
            this.fpga.setPreferredScrollableViewportSize(new Dimension(width, height));
            this.fpga.setCellSelectionEnabled(true);
            this.fpga.setColumnSelectionAllowed(true);
            this.fpga.setSelectionBackground(Color.cyan);
            this.fpga.setSelectionMode(2);
            ListSelectionModel listSelectionModel = this.fpga.getSelectionModel();
            listSelectionModel.addListSelectionListener(this.fpgaCellRenderer);
            this.fpga.getColumnModel().getSelectionModel().addListSelectionListener(this.fpgaCellRenderer);
            this.fpga.addMouseListener(this.fpgaCellRenderer);
            this.fpga.addFocusListener(this);
            int i2 = 0;
            while (i2 < this.fpga.getColumnCount()) {
                TableColumn col = this.fpga.getColumnModel().getColumn(i2);
                col.setMaxWidth(11);
                col.setMinWidth(9);
                col.setPreferredWidth(10);
                col.setCellRenderer(this.fpgaCellRenderer);
                ++i2;
            }
            this.fpga.setRowHeight(60);
            GridBagLayout gbc = new GridBagLayout();
            this.setLayout(gbc);
            GridBagConstraints constraintLayout = new GridBagConstraints();
            constraintLayout.fill = 1;
            constraintLayout.gridx = 0;
            constraintLayout.gridy = 0;
            JPanel page_info_panel = new JPanel();
            page_info_panel.setLayout(new FlowLayout(0));
            page_info_panel.add(info_panel);
            this.add((Component)page_info_panel, constraintLayout);
            constraintLayout.fill = 1;
            constraintLayout.gridx = 0;
            constraintLayout.gridy = 1;
            JPanel page_start_panel = new JPanel();
            page_start_panel.setLayout(new FlowLayout(0));
            page_start_panel.add(menu_panel);
            this.add((Component)page_start_panel, constraintLayout);
            constraintLayout.fill = 1;
            constraintLayout.gridx = 0;
            constraintLayout.gridy = 2;
            JPanel page_center_panel = new JPanel();
            page_center_panel.setLayout(new FlowLayout(1));
            page_center_panel.add(fpga_scroll);
            this.add((Component)page_center_panel, constraintLayout);
            constraintLayout.fill = 1;
            constraintLayout.gridx = 0;
            constraintLayout.gridy = 3;
            JPanel page_end_panel = new JPanel();
            page_end_panel.setLayout(new FlowLayout(2));
            page_end_panel.add(button_panel);
            this.add((Component)page_end_panel, constraintLayout);
            this.pack();
        }
        catch (JDOMException ex) {
            ex.printStackTrace();
            throw new Exception(ex.getMessage());
        }
    }

    private int convertRow2Fpga(int row) {
        return this.fpga.getRowCount() - row - 1;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.typeInterfaceTextField.setEnabled(false);
        this.posInterfaceComboBox.setEnabled(false);
        if (event.getSource() == this.okButton) {
            try {
                this.config.setFPGAConstraints(this.fpgaCellRenderer.getArea());
            }
            catch (JDOMException ex) {
                ex.printStackTrace();
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dispose();
        } else if (event.getSource() == this.cancelButton) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.dispose();
        } else if (event.getSource() == this.addStaticButton) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (event.getSource() == this.removeButton) {
            this.setCursor(Cursor.getPredefinedCursor(12));
        } else if (event.getSource() == this.noActionButton) {
            this.setCursor(Cursor.getPredefinedCursor(0));
        } else if (event.getSource() == this.removeAllStaticAreaButton) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            this.fpgaCellRenderer.removeAllStaticConstraints();
            this.fpga.repaint();
        } else if (event.getSource() == this.addInterfaceButton) {
            this.typeInterfaceTextField.setEnabled(true);
            this.posInterfaceComboBox.setEnabled(true);
            this.setCursor(Cursor.getPredefinedCursor(12));
        }
        if (event.getSource() == this.posInterfaceComboBox) {
            this.typeInterfaceTextField.setEnabled(true);
            this.posInterfaceComboBox.setEnabled(true);
            try {
                this.fpgaCellRenderer.saveCell();
                this.fpgaCellRenderer.updateDisplayDynInfo();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        } else if (event.getSource() == this.typeInterfaceTextField) {
            this.typeInterfaceTextField.setEnabled(true);
            this.posInterfaceComboBox.setEnabled(true);
            try {
                this.fpgaCellRenderer.saveCell();
                this.fpgaCellRenderer.updateDisplayDynInfo();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
    }

    @Override
    public void focusLost(FocusEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
        try {
            this.fpgaCellRenderer.saveCell();
            this.fpgaCellRenderer.updateDisplayDynInfo();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    class FPGAModel
    extends AbstractTableModel {
        DevicePackage devicePkg;

        public FPGAModel(DevicePackage devicePkg) {
            this.devicePkg = devicePkg;
        }

        @Override
        public int getColumnCount() {
            return this.devicePkg.getColumnNumber();
        }

        @Override
        public int getRowCount() {
            return this.devicePkg.getLineNumber();
        }

        @Override
        public String getColumnName(int columnIndex) {
            return "";
        }

        @Override
        public Object getValueAt(int row, int column) {
            String ct = "?";
            try {
                DeviceCell dc = this.devicePkg.getCell(column, FPGAInputDialog.this.convertRow2Fpga(row));
                ct = dc.getDescription();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return ct;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    class FpgaCellRenderer
    extends DefaultTableCellRenderer
    implements ListSelectionListener,
    MouseListener {
        FPGAConstraints[][] area;

        public FpgaCellRenderer() throws JDOMException {
            this.area = FPGAInputDialog.this.config.getTableFPGAConstraints();
        }

        public FPGAConstraints[][] getArea() {
            return this.area;
        }

        public void removeAllStaticConstraints() {
            int i = 0;
            while (i < FPGAInputDialog.this.devicePkg.getLineNumber()) {
                int j = 0;
                while (j < FPGAInputDialog.this.devicePkg.getColumnNumber()) {
                    if (this.area[i][j] instanceof FPGAStaticConstraints) {
                        this.area[i][j] = null;
                    }
                    ++j;
                }
                ++i;
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            int fpga_row = FPGAInputDialog.this.convertRow2Fpga(row);
            Color color = Color.WHITE;
            JPanel cell = new JPanel();
            boolean static_cell = true;
            String cellName = "";
            try {
                DeviceCell ct = FPGAInputDialog.this.devicePkg.getCell(column, fpga_row);
                cellName = ct.getDescription();
                static_cell = !ct.isReconfigurable();
                color = ct.getForegroundColor();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (this.area[fpga_row][column] instanceof FPGAStaticConstraints) {
                cellName = String.valueOf(cellName) + " , Static Constraint";
            } else if (this.area[fpga_row][column] instanceof FPGAInterfaceConstraints) {
                String type = ((FPGAInterfaceConstraints)this.area[fpga_row][column]).getInterfaceType();
                String pos = ((FPGAInterfaceConstraints)this.area[fpga_row][column]).getPosition();
                cellName = String.valueOf(cellName) + ", Interface [" + pos + ", " + type + " ]";
            }
            if (isSelected) {
                cell.setBackground(Color.GREEN);
            } else if (this.area[fpga_row][column] instanceof FPGAStaticConstraints) {
                cell.setBackground(Color.GRAY);
            } else if (this.area[fpga_row][column] instanceof FPGAInterfaceConstraints) {
                cell.setBackground(Color.ORANGE);
            } else if (static_cell) {
                cell.setBackground(Color.WHITE);
            } else {
                cell.setBackground(Color.BLACK);
            }
            cell.setToolTipText(cellName);
            cell.setBorder(BorderFactory.createLineBorder(color, 2));
            return cell;
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (listSelectionEvent.getValueIsAdjusting()) {
                return;
            }
            ListSelectionModel lsm = (ListSelectionModel)listSelectionEvent.getSource();
            if (lsm.isSelectionEmpty() || FPGAInputDialog.this.noActionButton.isSelected()) {
                try {
                    this.updateDisplayDynInfo();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            } else {
                try {
                    this.updateDisplayDynInfo();
                    if (FPGAInputDialog.this.noActionButton.isSelected()) {
                        return;
                    }
                    this.saveCell();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                FPGAInputDialog.this.fpga.repaint();
            }
        }

        public void updateDisplayDynInfo() throws Exception {
            int row = FPGAInputDialog.this.fpga.getSelectedRow();
            int fpga_row = FPGAInputDialog.this.convertRow2Fpga(row);
            int column = FPGAInputDialog.this.fpga.getSelectedColumn();
            DeviceCell dc = FPGAInputDialog.this.devicePkg.getCell(column, fpga_row);
            String cellName = dc.getDescription();
            String dyn_info_text = "Cell : " + cellName + "  xy[" + column + "; " + fpga_row + "] / ucf[" + dc.getX() + "; " + dc.getY() + "]";
            if (this.area[fpga_row][column] instanceof FPGAStaticConstraints) {
                dyn_info_text = String.valueOf(dyn_info_text) + " with Static Constraint";
            } else if (this.area[fpga_row][column] instanceof FPGAInterfaceConstraints) {
                FPGAInterfaceConstraints fic = (FPGAInterfaceConstraints)this.area[fpga_row][column];
                String type = fic.getInterfaceType();
                String pos = fic.getPosition();
                dyn_info_text = String.valueOf(dyn_info_text) + " with Interface [" + pos + ", " + type + "]";
                FPGAInputDialog.this.typeInterfaceTextField.setSelectedItem(type);
                FPGAInputDialog.this.posInterfaceComboBox.setSelectedItem(pos);
            } else {
                dyn_info_text = String.valueOf(dyn_info_text);
            }
            FPGAInputDialog.this.dyn_info.setText(dyn_info_text);
        }

        public void saveCell() throws Exception {
            int[] row = FPGAInputDialog.this.fpga.getSelectedRows();
            int[] column = FPGAInputDialog.this.fpga.getSelectedColumns();
            int rowMin = row[0];
            int rowMax = row[row.length - 1];
            int columnMin = column[0];
            int columnMax = column[column.length - 1];
            int i = rowMin;
            while (i <= rowMax) {
                int fpga_row = FPGAInputDialog.this.convertRow2Fpga(i);
                int j = columnMin;
                while (j <= columnMax) {
                    if (FPGAInputDialog.this.addStaticButton.isSelected()) {
                        this.area[fpga_row][j] = new FPGAStaticConstraints(fpga_row, j);
                    } else if (FPGAInputDialog.this.addInterfaceButton.isSelected()) {
                        DeviceCell dc = FPGAInputDialog.this.devicePkg.getCell(j, fpga_row);
                        if (dc.isReconfigurable()) {
                            String type = (String)FPGAInputDialog.this.typeInterfaceTextField.getSelectedItem();
                            if (!(type = type.trim()).isEmpty()) {
                                String pos = FPGAInputDialog.this.posInterfaceComboBox.getSelectedItem().toString();
                                this.area[fpga_row][j] = new FPGAInterfaceConstraints(fpga_row, j, type, pos);
                                this.addTypeInterfaceComboBox(type);
                            } else if (this.area[fpga_row][j] instanceof FPGAInterfaceConstraints) {
                                FPGAInputDialog.this.typeInterfaceTextField.setSelectedItem(((FPGAInterfaceConstraints)this.area[fpga_row][j]).getInterfaceType());
                                FPGAInputDialog.this.posInterfaceComboBox.setSelectedItem(((FPGAInterfaceConstraints)this.area[fpga_row][j]).getPosition());
                            } else {
                                JOptionPane.showMessageDialog(null, "The TYPE of Interface is empty. Please, add a interface. For example, you can add <AXI>.");
                            }
                        }
                    } else if (FPGAInputDialog.this.removeButton.isSelected()) {
                        this.area[fpga_row][j] = null;
                    }
                    ++j;
                }
                ++i;
            }
        }

        void addTypeInterfaceComboBox(String newType) {
            int n = FPGAInputDialog.this.typeInterfaceTextField.getItemCount();
            boolean found = false;
            int i = 0;
            while (i < n) {
                String item = FPGAInputDialog.this.typeInterfaceTextField.getItemAt(i);
                if (item.equalsIgnoreCase(newType)) {
                    found = true;
                    break;
                }
                ++i;
            }
            if (!found) {
                FPGAInputDialog.this.typeInterfaceTextField.insertItemAt(newType, 0);
            }
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

