/*
 * Decompiled with CFR 0.152.
 */
package jfb.gmf.modulesystem.diagram.part;

import jfb.gmf.modulesystem.ModuleDiagram;
import jfb.gmf.modulesystem.ModulesystemPackage;
import jfb.gmf.modulesystem.diagram.part.ModulesystemDiagramEditorPlugin;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.tooling.runtime.structure.DiagramStructure;

public class ModulesystemVisualIDRegistry {
    private static final String DEBUG_KEY = "Modulesystem.diagram/debug/visualID";
    public static final DiagramStructure TYPED_INSTANCE = new DiagramStructure(){

        public int getVisualID(View view) {
            return ModulesystemVisualIDRegistry.getVisualID(view);
        }

        public String getModelID(View view) {
            return ModulesystemVisualIDRegistry.getModelID(view);
        }

        public int getNodeVisualID(View containerView, EObject domainElement) {
            return ModulesystemVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        }

        public boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
            return ModulesystemVisualIDRegistry.checkNodeVisualID(containerView, domainElement, candidate);
        }

        public boolean isCompartmentVisualID(int visualID) {
            return ModulesystemVisualIDRegistry.isCompartmentVisualID(visualID);
        }

        public boolean isSemanticLeafVisualID(int visualID) {
            return ModulesystemVisualIDRegistry.isSemanticLeafVisualID(visualID);
        }
    };

    public static int getVisualID(View view) {
        if (view instanceof Diagram) {
            if ("Modulesystem".equals(view.getType())) {
                return 1000;
            }
            return -1;
        }
        return ModulesystemVisualIDRegistry.getVisualID(view.getType());
    }

    public static String getModelID(View view) {
        Diagram diagram = view.getDiagram();
        while (view != diagram) {
            EAnnotation annotation = view.getEAnnotation("Shortcut");
            if (annotation != null) {
                return (String)annotation.getDetails().get((Object)"modelID");
            }
            view = (View)view.eContainer();
        }
        return diagram != null ? diagram.getType() : null;
    }

    public static int getVisualID(String type) {
        try {
            return Integer.parseInt(type);
        }
        catch (NumberFormatException numberFormatException) {
            if (Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)DEBUG_KEY))) {
                ModulesystemDiagramEditorPlugin.getInstance().logError("Unable to parse view type as a visualID number: " + type);
            }
            return -1;
        }
    }

    public static String getType(int visualID) {
        return Integer.toString(visualID);
    }

    public static int getDiagramVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ModulesystemPackage.eINSTANCE.getModuleDiagram().isSuperTypeOf(domainElement.eClass()) && ModulesystemVisualIDRegistry.isDiagram((ModuleDiagram)domainElement)) {
            return 1000;
        }
        return -1;
    }

    public static int getNodeVisualID(View containerView, EObject domainElement) {
        int containerVisualID;
        if (domainElement == null) {
            return -1;
        }
        String containerModelID = ModulesystemVisualIDRegistry.getModelID(containerView);
        if (!"Modulesystem".equals(containerModelID)) {
            return -1;
        }
        if ("Modulesystem".equals(containerModelID)) {
            containerVisualID = ModulesystemVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return -1;
        }
        switch (containerVisualID) {
            case 1000: {
                if (ModulesystemPackage.eINSTANCE.getTestBench().isSuperTypeOf(domainElement.eClass())) {
                    return 2001;
                }
                if (!ModulesystemPackage.eINSTANCE.getModule().isSuperTypeOf(domainElement.eClass())) break;
                return 2002;
            }
            case 7001: {
                if (ModulesystemPackage.eINSTANCE.getImplementationHard().isSuperTypeOf(domainElement.eClass())) {
                    return 3001;
                }
                if (!ModulesystemPackage.eINSTANCE.getImplementationSoft().isSuperTypeOf(domainElement.eClass())) break;
                return 3002;
            }
        }
        return -1;
    }

    public static boolean canCreateNode(View containerView, int nodeVisualID) {
        int containerVisualID;
        String containerModelID = ModulesystemVisualIDRegistry.getModelID(containerView);
        if (!"Modulesystem".equals(containerModelID)) {
            return false;
        }
        if ("Modulesystem".equals(containerModelID)) {
            containerVisualID = ModulesystemVisualIDRegistry.getVisualID(containerView);
        } else if (containerView instanceof Diagram) {
            containerVisualID = 1000;
        } else {
            return false;
        }
        switch (containerVisualID) {
            case 1000: {
                if (2001 == nodeVisualID) {
                    return true;
                }
                if (2002 != nodeVisualID) break;
                return true;
            }
            case 2001: {
                if (5001 != nodeVisualID) break;
                return true;
            }
            case 2002: {
                if (5004 == nodeVisualID) {
                    return true;
                }
                if (7001 != nodeVisualID) break;
                return true;
            }
            case 3001: {
                if (5002 != nodeVisualID) break;
                return true;
            }
            case 3002: {
                if (5003 != nodeVisualID) break;
                return true;
            }
            case 7001: {
                if (3001 == nodeVisualID) {
                    return true;
                }
                if (3002 != nodeVisualID) break;
                return true;
            }
            case 4001: {
                if (6001 != nodeVisualID) break;
                return true;
            }
        }
        return false;
    }

    public static int getLinkWithClassVisualID(EObject domainElement) {
        if (domainElement == null) {
            return -1;
        }
        if (ModulesystemPackage.eINSTANCE.getConnection().isSuperTypeOf(domainElement.eClass())) {
            return 4001;
        }
        return -1;
    }

    private static boolean isDiagram(ModuleDiagram element) {
        return true;
    }

    public static boolean checkNodeVisualID(View containerView, EObject domainElement, int candidate) {
        if (candidate == -1) {
            return false;
        }
        int basic = ModulesystemVisualIDRegistry.getNodeVisualID(containerView, domainElement);
        return basic == candidate;
    }

    public static boolean isCompartmentVisualID(int visualID) {
        switch (visualID) {
            case 7001: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSemanticLeafVisualID(int visualID) {
        switch (visualID) {
            case 1000: {
                return false;
            }
            case 2001: 
            case 3001: 
            case 3002: {
                return true;
            }
        }
        return false;
    }
}

