/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.env.FortressEnv;
import fortress.xml.ConfigApplication;
import fortress.xml.FortressBenchModule;
import fortress.xml.FortressConnection;
import fortress.xml.FortressModuleImplementation;
import fortress.xml.FortressNodeModule;
import fortress.xml.FortressXMLBuilder;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.JDOMException;

public class FortressSchematic
extends FortressXMLBuilder {
    String fileName;
    Vector<FortressNodeModule> nodeList;
    Vector<FortressBenchModule> testbenchList;

    public FortressSchematic(String fileName) {
        this.fileName = fileName;
    }

    public void loadFile(ConfigApplication ca) throws JDOMException, IOException {
        String fname = ca.isLocal() ? FortressEnv.getSchematicFile(ca.getFileNameWithExtension()) : ca.getFile();
        File f = new File(fname);
        if (!f.exists()) {
            throw new IOException("Error: File (" + fname + ") not found !");
        }
        this.doc = this.sxb.build(f);
        this.root = this.doc.getRootElement();
        Vector<String> node_module_list = this.getNodeModuleNameList();
        Vector<String> bench_module_list = this.getBenchModuleNameList();
        this.nodeList = new Vector();
        this.generateNodeList(node_module_list, bench_module_list);
        this.testbenchList = new Vector();
        this.generateTestbenchList(node_module_list, bench_module_list);
        this.linkOutConnections();
        this.linkInConnections();
    }

    public String getApplicationName() {
        int k = this.fileName.lastIndexOf(File.separator);
        String fdest = k == -1 ? this.fileName : this.fileName.substring(k + 1);
        return fdest.substring(0, fdest.lastIndexOf("."));
    }

    public String getFileName() {
        return this.fileName;
    }

    public Vector<FortressNodeModule> getNodeModuleList() {
        return this.nodeList;
    }

    public Vector<FortressBenchModule> getTestbenchList() {
        return this.testbenchList;
    }

    public FortressNodeModule getNodeModule(String name) {
        FortressNodeModule nm = null;
        int i = 0;
        while (i < this.nodeList.size()) {
            if (name.equals(this.nodeList.elementAt(i).getModuleName())) {
                return this.nodeList.elementAt(i);
            }
            ++i;
        }
        return nm;
    }

    public FortressBenchModule getBenchModule(String name) {
        FortressBenchModule nm = null;
        int i = 0;
        while (i < this.testbenchList.size()) {
            if (name.equals(this.testbenchList.elementAt(i).getModuleName())) {
                return this.testbenchList.elementAt(i);
            }
            ++i;
        }
        return nm;
    }

    public Object getModule(String name) {
        Object obj = this.getNodeModule(name);
        if (obj == null) {
            obj = this.getBenchModule(name);
        }
        return obj;
    }

    /*
     * Unable to fully structure code
     */
    Vector<String> getNodeModuleNameList() throws JDOMException {
        list = new Vector<String>();
        module_list = this.root.getChildren("module");
        i = module_list.iterator();
        if (i.hasNext()) ** GOTO lbl12
        throw new JDOMException("Error: No Module Found !");
lbl-1000:
        // 1 sources

        {
            el = (Element)i.next();
            val = el.getAttributeValue("module_name");
            if (val == null) {
                throw new JDOMException("Error: No Node Module Name Found !");
            }
            list.add(new String(val));
lbl12:
            // 2 sources

            ** while (i.hasNext())
        }
lbl13:
        // 1 sources

        return list;
    }

    /*
     * Unable to fully structure code
     */
    Vector<String> getBenchModuleNameList() throws JDOMException {
        list = new Vector<String>();
        module_list = this.root.getChildren("testBench");
        i = module_list.iterator();
        if (i.hasNext()) ** GOTO lbl12
        throw new JDOMException("Error: No TestBench Found !");
lbl-1000:
        // 1 sources

        {
            el = (Element)i.next();
            val = el.getAttributeValue("testBench_name");
            if (val == null) {
                throw new JDOMException("Error: No Bench Module Name Found !");
            }
            list.add(new String(val));
lbl12:
            // 2 sources

            ** while (i.hasNext())
        }
lbl13:
        // 1 sources

        return list;
    }

    void generateNodeList(Vector<String> node_module_list, Vector<String> bench_module_list) throws JDOMException {
        List module_list = this.root.getChildren("module");
        for (Element el : module_list) {
            String module_name = el.getAttributeValue("module_name");
            String s = this.checkEmptyAttribute(el.getAttributeValue("deadline"));
            String deadline = s == null ? FortressNodeModule.getDefaultDeadline() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("period"));
            String period = s == null ? FortressNodeModule.getDefaultPeriod() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("priority"));
            String priority = s == null ? FortressNodeModule.getDefaultPriority() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("begin_time"));
            String begin_time = s == null ? FortressNodeModule.getDefaultBeginTime() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("static_module"));
            boolean static_module = s == null ? FortressNodeModule.isDefaultStaticModule() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("activate_Trace"));
            boolean activated_trace = s == null ? FortressNodeModule.isDefaultActivatedTrace() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("tracefile"));
            String tracefile = s == null ? FortressNodeModule.getDefaultTraceFile(module_name) : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("enable_execution_mode_signal_in_trace"));
            boolean enable_execution_module_signals_trace = s == null ? FortressNodeModule.isDefaultEnableExecutionModeSignalsTrace() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("logfile"));
            String logfile = s == null ? FortressNodeModule.getDefaultTraceFile(module_name) : s;
            List comList = el.getChildren("targetConnection");
            Vector<FortressConnection> connections = this.getConnections(node_module_list, bench_module_list, comList);
            List implList = el.getChildren("implementationHard");
            Vector<FortressModuleImplementation> hwImpl = this.getHwImplementations(implList);
            implList = el.getChildren("implementationSoft");
            Vector<FortressModuleImplementation> swImpl = this.getSwImplementations(implList);
            this.nodeList.add(new FortressNodeModule(module_name, deadline, period, priority, begin_time, static_module, activated_trace, tracefile, enable_execution_module_signals_trace, logfile, connections, hwImpl, swImpl));
        }
    }

    Vector<FortressModuleImplementation> getHwImplementations(List implList) throws JDOMException {
        Vector<FortressModuleImplementation> hwImplementations = new Vector<FortressModuleImplementation>(implList.size() + 1);
        for (Element el : implList) {
            String s = this.checkEmptyAttribute(el.getAttributeValue("implementation_name"));
            if (s == null) {
                throw new JDOMException("Error: No implementation name !");
            }
            String implementation_name = s;
            s = this.checkEmptyAttribute(el.getAttributeValue("frequency"));
            String frequency = s == null ? FortressModuleImplementation.getDefaultFrequency() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("worst_case_execution_time"));
            String worst_case_execution_time = s == null ? FortressModuleImplementation.getDefaultWCET() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("best_case_execution_time"));
            String best_case_execution_time = s == null ? FortressModuleImplementation.getDefaultBCET() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("context_switch_time"));
            String context_switch_time = s == null ? FortressModuleImplementation.getDefaultContextSwitchTime() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("use_context_switch"));
            boolean use_context_switch = s == null ? FortressModuleImplementation.hasDefaultUseContextSwitchTime() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("pidle"));
            String Pidle = s == null ? FortressModuleImplementation.getDefaultPidle() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("prun"));
            String Prun = s == null ? FortressModuleImplementation.getDefaultPrun() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("use_algorithm"));
            boolean use_algorithm = s == null ? FortressModuleImplementation.hasDefaultUseAlgorithm() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("algorithm_name"));
            String algorithm_name = s == null ? "" : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("nb_preemption_points"));
            int nb_preemption_points = s == null ? FortressModuleImplementation.getDefaultNbPreemptionPoints() : Integer.parseInt(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("interface_types"));
            String interface_types = s == null ? FortressModuleImplementation.getDefaultInterfaceTypes() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("loc_constraints"));
            String loc_contraints = s == null ? FortressModuleImplementation.getDefaultLocContraints() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("task_report"));
            String task_report = s == null ? FortressModuleImplementation.getDefaultTaskReport() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("netlist"));
            String netlist = s == null ? FortressModuleImplementation.getDefaultNetlist() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("resource_margin"));
            String resource_margin = s == null ? FortressModuleImplementation.getDefaultResourceMargin() : s;
            hwImplementations.add(new FortressModuleImplementation(implementation_name, frequency, worst_case_execution_time, best_case_execution_time, context_switch_time, use_context_switch, Pidle, Prun, use_algorithm, algorithm_name, nb_preemption_points, interface_types, loc_contraints, task_report, netlist, resource_margin));
        }
        return hwImplementations;
    }

    Vector<FortressModuleImplementation> getSwImplementations(List implList) throws JDOMException {
        Vector<FortressModuleImplementation> swImplementations = new Vector<FortressModuleImplementation>(implList.size() + 1);
        for (Element el : implList) {
            String s = this.checkEmptyAttribute(el.getAttributeValue("implementation_name"));
            if (s == null) {
                throw new JDOMException("Error: No implementation name !");
            }
            String implementation_name = s;
            s = this.checkEmptyAttribute(el.getAttributeValue("worst_case_execution_time"));
            String worst_case_execution_time = s == null ? FortressModuleImplementation.getDefaultWCET() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("best_case_execution_time"));
            String best_case_execution_time = s == null ? FortressModuleImplementation.getDefaultBCET() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("binary_loading_time"));
            String binary_loading_time = s == null ? FortressModuleImplementation.getDefaultBinaryLoadingTime() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("use_algorithm"));
            boolean use_algorithm = s == null ? FortressModuleImplementation.hasDefaultUseAlgorithm() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("algorithm_name"));
            String algorithm_name = s == null ? FortressModuleImplementation.getDefaultSwAlgorithmName() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("nb_preemption_points"));
            int nb_preemption_points = s == null ? FortressModuleImplementation.getDefaultNbPreemptionPoints() : Integer.parseInt(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("interface_types"));
            String interface_types = s == null ? FortressModuleImplementation.getDefaultInterfaceTypes() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("processor_type"));
            String processor_type = s == null ? FortressModuleImplementation.getDefaultProcessorType() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("use_context_switch"));
            boolean use_context_switch = s == null ? FortressModuleImplementation.hasDefaultUseContextSwitchTime() : Boolean.parseBoolean(s);
            swImplementations.add(new FortressModuleImplementation(implementation_name, worst_case_execution_time, best_case_execution_time, binary_loading_time, use_algorithm, algorithm_name, nb_preemption_points, interface_types, processor_type, use_context_switch));
        }
        return swImplementations;
    }

    Vector<FortressConnection> getConnections(Vector<String> node_module_list, Vector<String> bench_module_list, List comList) throws JDOMException {
        Vector<FortressConnection> connections = new Vector<FortressConnection>(comList.size() + 1);
        for (Element el : comList) {
            String s = this.checkEmptyAttribute(el.getAttributeValue("connection_name"));
            if (s == null) {
                throw new JDOMException("Error: No Connection name !");
            }
            String connection_name = s;
            s = this.checkEmptyAttribute(el.getAttributeValue("packet_size"));
            String packet_size = s == null ? FortressConnection.getDefaultPacketSize() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("input_communication_type"));
            String input_communication_type = s == null ? FortressConnection.getDefaultInputCommunicationType() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("output_communication_type"));
            String output_communication_type = s == null ? FortressConnection.getDefaultOutputCommunicationType() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("begin_req"));
            String begin_req = s == null ? FortressConnection.getDefaultBeginReq() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("end_req"));
            String end_req = s == null ? FortressConnection.getDefaultEndReq() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("begin_resp"));
            String begin_resp = s == null ? FortressConnection.getDefaultBeginResp() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("end_resp"));
            String end_resp = s == null ? FortressConnection.getDefaultEndResp() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("input_priority_channel"));
            boolean input_priority_channel = s == null ? FortressConnection.isDefaultInputPriorityChannel() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("output_priority_channel"));
            boolean output_priority_channel = s == null ? FortressConnection.isDefaultOutputPriorityChannel() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("transient_channel"));
            boolean transient_channel = s == null ? FortressConnection.isDefaultTransientChannel() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("target_Block"));
            FortressConnection.TargetConnectionType target_Block = s.contains("module") ? FortressConnection.TargetConnectionType.MODULE : FortressConnection.TargetConnectionType.TESTBENCH;
            int pos = s.lastIndexOf(".");
            if (pos == -1) {
                throw new JDOMException("Internal Error: No number reference for connection " + connection_name + " !");
            }
            s = s.substring(pos + 1);
            pos = Integer.parseInt(s);
            String target_module = target_Block == FortressConnection.TargetConnectionType.MODULE ? node_module_list.elementAt(pos) : bench_module_list.elementAt(pos);
            connections.add(new FortressConnection(connection_name, packet_size, input_communication_type, output_communication_type, begin_req, end_req, begin_resp, end_resp, input_priority_channel, output_priority_channel, transient_channel, target_Block, target_module));
        }
        return connections;
    }

    void generateTestbenchList(Vector<String> node_module_list, Vector<String> bench_module_list) throws JDOMException {
        List module_list = this.root.getChildren("testBench");
        for (Element el : module_list) {
            String module_name = el.getAttributeValue("testBench_name");
            String s = this.checkEmptyAttribute(el.getAttributeValue("testBench_Thread"));
            String testBench_thread = s == null ? FortressBenchModule.getDefaultTestBenchThread() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("period"));
            String period = s == null ? FortressBenchModule.getDefaultPeriod() : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("activate_Trace"));
            boolean activated_trace = s == null ? FortressBenchModule.isDefaultActivatedTrace() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("tracefile"));
            String tracefile = s == null ? FortressBenchModule.getDefaultTraceFile(module_name) : s;
            s = this.checkEmptyAttribute(el.getAttributeValue("enable_configuration_signals_trace"));
            boolean enable_configuration_signals_trace = s == null ? FortressBenchModule.isDefaultEnableConfigurationSignalsTrace() : Boolean.parseBoolean(s);
            s = this.checkEmptyAttribute(el.getAttributeValue("logfile"));
            String logfile = s == null ? FortressBenchModule.getDefaultTraceFile(module_name) : s;
            List comList = el.getChildren("targetConnection");
            Vector<FortressConnection> connections = this.getConnections(node_module_list, bench_module_list, comList);
            this.testbenchList.add(new FortressBenchModule(module_name, testBench_thread, period, activated_trace, tracefile, enable_configuration_signals_trace, logfile, connections));
        }
    }

    private String checkEmptyAttribute(String s) {
        if (s == null) {
            return null;
        }
        if (s.trim().length() == 0) {
            return null;
        }
        return s;
    }

    void linkOutConnections() throws JDOMException {
        Object obj;
        FortressConnection fc;
        int j;
        Vector<FortressConnection> outConnections;
        Object current_module;
        int i = 0;
        while (i < this.nodeList.size()) {
            current_module = this.nodeList.elementAt(i);
            outConnections = ((FortressNodeModule)current_module).getOutConnections();
            j = 0;
            while (j < outConnections.size()) {
                fc = outConnections.elementAt(j);
                obj = this.getModule(fc.getTargetModule());
                if (obj == null) {
                    throw new JDOMException("Error: Update OutConnections " + fc.getTargetModule() + " on module " + ((FortressNodeModule)current_module).getModuleName());
                }
                fc.setModule(obj);
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.testbenchList.size()) {
            current_module = this.testbenchList.elementAt(i);
            outConnections = ((FortressBenchModule)current_module).getOutConnections();
            j = 0;
            while (j < outConnections.size()) {
                fc = outConnections.elementAt(j);
                obj = this.getModule(fc.getTargetModule());
                if (obj == null) {
                    throw new JDOMException("Error: Update OutConnections " + fc.getTargetModule() + " on module " + ((FortressBenchModule)current_module).getModuleName());
                }
                fc.setModule(obj);
                ++j;
            }
            ++i;
        }
    }

    void linkInConnections() throws JDOMException {
        FortressConnection fc;
        int k;
        Vector<FortressConnection> fcList;
        Object search_module;
        int j;
        Vector<FortressConnection> inConnectionList;
        Object current_module;
        int i = 0;
        while (i < this.nodeList.size()) {
            current_module = this.nodeList.elementAt(i);
            inConnectionList = new Vector<FortressConnection>();
            j = 0;
            while (j < this.nodeList.size()) {
                search_module = this.nodeList.elementAt(j);
                fcList = ((FortressNodeModule)search_module).getOutFortressConnection(((FortressNodeModule)current_module).getModuleName());
                k = 0;
                while (k < fcList.size()) {
                    fc = new FortressConnection(fcList.elementAt(k));
                    fc.setModule(search_module);
                    inConnectionList.add(fc);
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < this.testbenchList.size()) {
                search_module = this.testbenchList.elementAt(j);
                fcList = ((FortressBenchModule)search_module).getOutFortressConnection(((FortressNodeModule)current_module).getModuleName());
                k = 0;
                while (k < fcList.size()) {
                    fc = new FortressConnection(fcList.elementAt(k));
                    fc.setModule(search_module);
                    inConnectionList.add(fc);
                    ++k;
                }
                ++j;
            }
            ((FortressNodeModule)current_module).setInConnections(inConnectionList);
            ++i;
        }
        i = 0;
        while (i < this.testbenchList.size()) {
            current_module = this.testbenchList.elementAt(i);
            inConnectionList = new Vector();
            j = 0;
            while (j < this.nodeList.size()) {
                search_module = this.nodeList.elementAt(j);
                fcList = ((FortressNodeModule)search_module).getOutFortressConnection(((FortressBenchModule)current_module).getModuleName());
                k = 0;
                while (k < fcList.size()) {
                    fc = new FortressConnection(fcList.elementAt(k));
                    fc.setModule(search_module);
                    inConnectionList.add(fc);
                    ++k;
                }
                ++j;
            }
            j = 0;
            while (j < this.testbenchList.size()) {
                search_module = this.testbenchList.elementAt(j);
                fcList = ((FortressBenchModule)search_module).getOutFortressConnection(((FortressBenchModule)current_module).getModuleName());
                k = 0;
                while (k < fcList.size()) {
                    fc = new FortressConnection(fcList.elementAt(k));
                    fc.setModule(search_module);
                    inConnectionList.add(fc);
                    ++k;
                }
                ++j;
            }
            ((FortressBenchModule)current_module).setInConnections(inConnectionList);
            ++i;
        }
    }
}

