/*
 * Decompiled with CFR 0.152.
 */
package fortress.xml;

import fortress.env.FortressEnv;
import fortress.xml.ConfigPowerFctPoint;
import fortress.xml.ConfigPowerGroup;
import fortress.xml.ConfigProcessorName;
import fortress.xml.FortressXMLBuilder;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class FortressPreferences
extends FortressXMLBuilder {
    public static String XILINX_TOOL_VERSION_v12 = "12.x";
    public static String XILINX_TOOL_VERSION_v13 = "13.x";
    public static String XILINX_TOOL_VERSION_v14 = "14.x";
    public static String XILINX_VIVADO_VERSION_2014_2 = "2014.2";
    public static String VISUAL_STUDIO_2010_32bits = "Visual Studio 2010 (32 bits)";
    public static String VISUAL_STUDIO_2012_32bits = "Visual Studio 2012 (32 bits)";

    public void loadFile() throws JDOMException, IOException {
        File f = new File(FortressEnv.getPreferencesFile());
        if (!f.exists()) {
            f = new File(FortressEnv.getTemplatePreferenceFile());
        }
        this.doc = this.sxb.build(f);
        this.root = this.doc.getRootElement();
    }

    public void loadDefaultFile() throws JDOMException, IOException {
        File f = new File(FortressEnv.getTemplatePreferenceFile());
        this.doc = this.sxb.build(f);
        this.root = this.doc.getRootElement();
    }

    public void loadReadOnlyFile() throws JDOMException, IOException {
        File f = new File(FortressEnv.getPreferencesFile());
        if (!f.exists()) {
            f = new File(FortressEnv.getTemplatePreferenceFile());
        }
        if (this.doc == null) {
            this.doc = this.sxb.build(f);
            this.root = this.doc.getRootElement();
        }
    }

    public void saveDefaultPathTemplateFile() throws JDOMException, IOException {
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        xmlOutput.output(this.doc, (Writer)new FileWriter(FortressEnv.getTemplatePreferenceFile()));
    }

    public void saveFile() throws JDOMException, IOException {
        XMLOutputter xmlOutput = new XMLOutputter();
        xmlOutput.setFormat(Format.getPrettyFormat());
        xmlOutput.output(this.doc, (Writer)new FileWriter(FortressEnv.getPreferencesFile()));
    }

    public boolean equals(FortressPreferences pref) throws JDOMException {
        boolean eq = this.getPlanheadPath().equals(pref.getPlanheadPath()) && this.getXilinxVivadoPath().equals(pref.getXilinxVivadoPath()) && this.getSystemCPath().equals(pref.getSystemCPath()) && this.getSystemCLibPath().equals(pref.getSystemCLibPath()) && this.getXercesPath().equals(pref.getXercesPath()) && this.getVisualCPPPath().equals(pref.getVisualCPPPath()) && this.getModelsimPath().equals(pref.getModelsimPath()) && this.getTextEditorPath().equals(pref.getTextEditorPath()) && this.getMsBuildPath().equals(pref.getMsBuildPath()) && this.getActiveConfiguration().equals(pref.getActiveConfiguration()) && this.getXilinxToolVersion().equals(pref.getXilinxToolVersion()) && this.getXilinxVivadoVersion().equals(pref.getXilinxVivadoVersion()) && this.getVisualStudioVersion().equals(pref.getVisualStudioVersion()) && this.isVerboseMode() == pref.isVerboseMode();
        eq &= this.externalNetlistFileListEquals(pref);
        eq &= this.externalTaskFileListEquals(pref);
        eq &= this.schedulerQueueStrategyEquals(pref);
        eq &= this.schedulerStrategyEquals(pref);
        return eq &= this.monitoringEquals(pref);
    }

    public boolean externalNetlistFileListEquals(FortressPreferences pref) throws JDOMException {
        Vector<String> own = pref.getExternalNetlistFile();
        Vector<String> list = this.getExternalNetlistFile();
        if (list.size() != own.size()) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            String el = list.elementAt(i);
            if (!el.equals(own.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean externalTaskFileListEquals(FortressPreferences pref) throws JDOMException {
        Vector<String> own = pref.getExternalTaskFile();
        Vector<String> list = this.getExternalTaskFile();
        if (list.size() != own.size()) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            String el = list.elementAt(i);
            if (!el.equals(own.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean schedulerStrategyEquals(FortressPreferences pref) throws JDOMException {
        Vector<String> list = pref.getSchedulerStrategyList();
        Vector<String> own = this.getSchedulerStrategyList();
        if (list.size() != own.size()) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            if (!own.elementAt(i).equals(list.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean monitoringEquals(FortressPreferences pref) throws JDOMException {
        Vector<String> list = pref.getMonitoringModuleList();
        Vector<String> own = this.getMonitoringModuleList();
        if (list.size() != own.size()) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            if (!own.elementAt(i).equals(list.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean schedulerQueueStrategyEquals(FortressPreferences pref) throws JDOMException {
        Vector<String> list = pref.getSchedulerQueueStrategyList();
        Vector<String> own = this.getSchedulerQueueStrategyList();
        if (list.size() != own.size()) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            if (!own.elementAt(i).equals(list.elementAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getPlanheadPath() throws JDOMException {
        return this.getValueWithDefaultValue("PlanheadPath", "value", "");
    }

    public String getXilinxVivadoPath() throws JDOMException {
        return this.getValueWithDefaultValue("XilinxVivadoPath", "value", "C:\\Xilinx");
    }

    public String getXilinxVivadoVersion() throws JDOMException {
        return this.getValueWithDefaultValue("XilinxVivadoVersion", "value", XILINX_VIVADO_VERSION_2014_2);
    }

    public String getVivadoPath() throws JDOMException {
        return String.valueOf(this.getXilinxVivadoPath()) + File.separator + "Vivado" + File.separator + this.getXilinxVivadoVersion() + File.separator + "bin" + File.separator;
    }

    public String getVivadoHLSPath() throws JDOMException {
        return String.valueOf(this.getXilinxVivadoPath()) + File.separator + "Vivado_HLS" + File.separator + this.getXilinxVivadoVersion() + File.separator + "bin" + File.separator;
    }

    public String getSystemCPath() throws JDOMException {
        return this.getValueWithDefaultValue("SystemCPath", "value", "");
    }

    public String getSystemCLibPath() throws JDOMException {
        return this.getValueWithDefaultValue("SystemCLibPath", "value", "");
    }

    public String getXercesPath() throws JDOMException {
        return this.getValueWithDefaultValue("XercesPath", "value", "");
    }

    public String getVisualCPPPath() throws JDOMException {
        return this.getValueWithDefaultValue("VisualCPPPath", "value", "");
    }

    public String getModelsimPath() throws JDOMException {
        return this.getValueWithDefaultValue("ModelsimPath", "value", "");
    }

    public String getTextEditorPath() throws JDOMException {
        return this.getValueWithDefaultValue("TextEditorPath", "value", "");
    }

    public String getMsBuildPath() throws JDOMException {
        return this.getValueWithDefaultValue("MsBuildPath", "value", "");
    }

    public void setMsBuildPath(String value) throws JDOMException {
        this.setValue("MsBuildPath", "value", value);
    }

    public void setTargetArchitecture(String value) throws JDOMException {
        this.setValue("TargetArchitecture", "value", value);
    }

    public String getTargetArchitecture() throws JDOMException {
        String s = this.getValue("TargetArchitecture", "value");
        if (s == null) {
            return System.getenv("PROCESSOR_ARCHITECTURE");
        }
        if (s.isEmpty()) {
            return System.getenv("PROCESSOR_ARCHITECTURE");
        }
        return s;
    }

    public Vector<String> getTargetArchitectureList() throws JDOMException {
        Vector<String> v = new Vector<String>(4);
        v.add("linux32");
        v.add("linux64");
        v.add("x86");
        v.add("w86_64");
        return v;
    }

    public String getActiveConfiguration() throws JDOMException {
        return this.getValue("ActiveConfiguration", "value");
    }

    public boolean hasActiveConfiguration() throws JDOMException {
        return this.getValue("ActiveConfiguration", "value") != null;
    }

    public String getXilinxToolVersion() throws JDOMException {
        return this.getValue("XilinxToolVersion", "value");
    }

    public String getVisualStudioVersion() throws JDOMException {
        return this.getValue("VisualStudioVersion", "value");
    }

    public boolean isVerboseMode() throws JDOMException {
        return Boolean.parseBoolean(this.getValueWithDefaultValue("VerboseMode", "value", "false"));
    }

    public void setVerboseMode(boolean value) throws JDOMException {
        this.setValue("VerboseMode", "value", String.valueOf(value));
    }

    public void setPlanheadPath(String value) throws JDOMException {
        this.setValue("PlanheadPath", "value", value);
    }

    public void setXilinxVivadoPath(String value) throws JDOMException {
        this.setValue("XilinxVivadoPath", "value", value);
    }

    public void setXilinxVivadoVersion(String value) throws JDOMException {
        this.setValue("XilinxVivadoVersion", "value", value);
    }

    public void setSystemCPath(String value) throws JDOMException {
        this.setValue("SystemCPath", "value", value);
    }

    public void setSystemCLibPath(String value) throws JDOMException {
        this.setValue("SystemCLibPath", "value", value);
    }

    public void setXercesPath(String value) throws JDOMException {
        this.setValue("XercesPath", "value", value);
    }

    public void setVisualCPPPath(String value) throws JDOMException {
        this.setValue("VisualCPPPath", "value", value);
    }

    public void setModelsimPath(String value) throws JDOMException {
        this.setValue("ModelsimPath", "value", value);
    }

    public void setTextEditorPath(String value) throws JDOMException {
        this.setValue("TextEditorPath", "value", value);
    }

    public void setActiveConfiguration(String value) throws JDOMException {
        this.setValue("ActiveConfiguration", "value", value);
    }

    public void setXilinxToolVersion(String value) throws JDOMException {
        this.setValue("XilinxToolVersion", "value", value);
    }

    public void setVisualStudioVersion(String value) throws JDOMException {
        this.setValue("VisualStudioVersion", "value", value);
    }

    public static Vector<String> getXilinxToolVersionList() {
        Vector<String> v = new Vector<String>(3);
        v.add(XILINX_TOOL_VERSION_v12);
        v.add(XILINX_TOOL_VERSION_v13);
        v.add(XILINX_TOOL_VERSION_v14);
        return v;
    }

    public static Vector<String> getXilinxVivadolVersionList() {
        Vector<String> v = new Vector<String>(1);
        v.add(XILINX_VIVADO_VERSION_2014_2);
        return v;
    }

    public static Vector<String> getVisualStudioVersionList() {
        Vector<String> v = new Vector<String>(2);
        v.add(VISUAL_STUDIO_2010_32bits);
        v.add(VISUAL_STUDIO_2012_32bits);
        return v;
    }

    public Vector<String> getConfigurations() throws JDOMException {
        Vector<String> list = new Vector<String>();
        List config_list = this.root.getChildren("Configurations");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return list;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("CFG");
        for (Element el2 : config_list) {
            String val = el2.getAttributeValue("value");
            list.add(new String(val));
        }
        return list;
    }

    public String createNewConfigurationName() throws JDOMException {
        String nm = "config_";
        int cpt = 0;
        while (this.existsConfiguration(String.valueOf(nm) + cpt)) {
            ++cpt;
        }
        return String.valueOf(nm) + cpt;
    }

    public void addConfiguration(String config) throws JDOMException {
        List config_list = this.root.getChildren("Configurations");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            Element elp = new Element("Configurations");
            config_list.add(elp);
            config_list = this.root.getChildren("Configurations");
            i = config_list.iterator();
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("CFG");
        if (!this.existsConfiguration(config)) {
            config_list.add(new Element("CFG").setAttribute("value", config));
        }
    }

    public boolean removeConfiguration(String config) throws JDOMException {
        List config_list = this.root.getChildren("Configurations");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("CFG");
        i = config_list.iterator();
        int cpt = 0;
        while (i.hasNext()) {
            el = (Element)i.next();
            String val = el.getAttributeValue("value");
            if (val.equals(config)) {
                config_list.remove(cpt);
                return true;
            }
            ++cpt;
        }
        return false;
    }

    public boolean existsConfiguration(String config) throws JDOMException {
        Vector<String> list = this.getConfigurations();
        return list.contains(config);
    }

    public Vector<String> getLocalNGCFileList() {
        String path = FortressEnv.getNetlistPath();
        return this.getFileList(path, ".ngc");
    }

    public Vector<String> getLocalEDFFileList() {
        String path = FortressEnv.getNetlistPath();
        return this.getFileList(path, ".edf");
    }

    public Vector<String> getLocalTaskFileList(String ext) {
        String path = FortressEnv.getTaskReportPath();
        return this.getFileList(path, ext);
    }

    public String getNGCFile(String report_name) throws JDOMException {
        Vector<String> localList = this.getLocalNGCFileList();
        int index = localList.indexOf(String.valueOf(report_name) + ".ngc");
        if (index != -1) {
            return FortressEnv.convertPathForOS(String.valueOf(FortressEnv.getNetlistRelativePath()) + report_name + ".ngc");
        }
        Vector<String> extList = this.getExternalNetlistFile();
        int i = 0;
        while (i < extList.size()) {
            if (FortressPreferences.extractFilename(extList.elementAt(i)).equals(report_name)) {
                return FortressEnv.convertPathForOS(extList.elementAt(i));
            }
            ++i;
        }
        return null;
    }

    public String getEDFFile(String report_name) throws JDOMException {
        Vector<String> localList = this.getLocalEDFFileList();
        int index = localList.indexOf(String.valueOf(report_name) + ".edf");
        if (index != -1) {
            return FortressEnv.convertPathForOS(String.valueOf(FortressEnv.getNetlistRelativePath()) + report_name + ".edf");
        }
        Vector<String> extList = this.getExternalNetlistFile();
        int i = 0;
        while (i < extList.size()) {
            if (FortressPreferences.extractFilename(extList.elementAt(i)).equals(report_name)) {
                return FortressEnv.convertPathForOS(extList.elementAt(i));
            }
            ++i;
        }
        return null;
    }

    public String getRelativeTaskFile(String report_name) throws JDOMException {
        Vector<String> localList = this.getLocalTaskFileList(".tsk");
        int index = localList.indexOf(String.valueOf(report_name) + ".tsk");
        if (index != -1) {
            return FortressEnv.convertPathForOS(String.valueOf(FortressEnv.getTaskReportRelativePath()) + report_name + ".tsk");
        }
        localList = this.getLocalTaskFileList(".syr");
        index = localList.indexOf(String.valueOf(report_name) + ".syr");
        if (index != -1) {
            return FortressEnv.convertPathForOS(String.valueOf(FortressEnv.getTaskReportRelativePath()) + report_name + ".syr");
        }
        Vector<String> extList = this.getExternalTaskFile();
        int i = 0;
        while (i < extList.size()) {
            if (FortressPreferences.extractFilename(extList.elementAt(i)).equals(report_name)) {
                return FortressEnv.convertPathForOS(extList.elementAt(i));
            }
            ++i;
        }
        return null;
    }

    public String getAbsoluteTaskFile(String report_name) throws JDOMException {
        Vector<String> localList = this.getLocalTaskFileList(".tsk");
        int index = localList.indexOf(String.valueOf(report_name) + ".tsk");
        if (index != -1) {
            return FortressEnv.convertPathForOS(String.valueOf(FortressEnv.getTaskReportPath()) + report_name + ".tsk");
        }
        localList = this.getLocalTaskFileList(".syr");
        index = localList.indexOf(String.valueOf(report_name) + ".syr");
        if (index != -1) {
            return FortressEnv.convertPathForOS(String.valueOf(FortressEnv.getTaskReportPath()) + report_name + ".syr");
        }
        Vector<String> extList = this.getExternalTaskFile();
        int i = 0;
        while (i < extList.size()) {
            if (FortressPreferences.extractFilename(extList.elementAt(i)).equals(report_name)) {
                return FortressEnv.convertPathForOS(extList.elementAt(i));
            }
            ++i;
        }
        return null;
    }

    Vector<String> getFileList(String path, String ext) {
        Vector<String> filelist = new Vector<String>();
        File dirpath = new File(path);
        File[] list = dirpath.listFiles();
        if (list == null) {
            return filelist;
        }
        int i = 0;
        while (i < list.length) {
            if (!list[i].isDirectory() && (list[i].getName().endsWith(ext) || list[i].getName().endsWith(ext.toUpperCase()))) {
                filelist.add(list[i].getName());
            }
            ++i;
        }
        return filelist;
    }

    public Vector<String> getExternalNetlistFile() throws JDOMException {
        return this.getExternalFiles("NETLIST");
    }

    public Vector<String> getExternalTaskFile() throws JDOMException {
        return this.getExternalFiles("REPORT");
    }

    public void addExternalNetlistFile(String path) throws JDOMException {
        this.addExternalFile("NETLIST", path);
    }

    public void addExternalTaskFile(String path) throws JDOMException {
        this.addExternalFile("REPORT", path);
    }

    public boolean removeExternalNetlistFile(String path) throws JDOMException {
        return this.removeExternalFile("NETLIST", path);
    }

    public boolean removeExternalTaskFile(String path) throws JDOMException {
        return this.removeExternalFile("REPORT", path);
    }

    public boolean existsExternalNetlistFile(String path) throws JDOMException {
        return this.existsExternalFile("NETLIST", path);
    }

    public boolean existsExternalSYRFile(String path) throws JDOMException {
        return this.existsExternalFile("REPORT", path);
    }

    Vector<String> getExternalFiles(String type) throws JDOMException {
        Vector<String> list = new Vector<String>();
        List config_list = this.root.getChildren(type);
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return list;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("FILE");
        for (Element el2 : config_list) {
            String val = el2.getAttributeValue("path");
            list.add(new String(val));
        }
        return list;
    }

    void addExternalFile(String type, String path) throws JDOMException {
        List config_list = this.root.getChildren(type);
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            Element elp = new Element(type);
            config_list.add(elp);
            config_list = this.root.getChildren(type);
            i = config_list.iterator();
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("FILE");
        if (!FortressPreferences.existsNameOfExternalFile(this.getExternalFiles(type), path)) {
            config_list.add(new Element("FILE").setAttribute("path", path));
        }
    }

    boolean removeExternalFile(String type, String path) throws JDOMException {
        List config_list = this.root.getChildren(type);
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("FILE");
        i = config_list.iterator();
        int cpt = 0;
        while (i.hasNext()) {
            el = (Element)i.next();
            String val = el.getAttributeValue("path");
            if (val.equals(path)) {
                config_list.remove(cpt);
                return true;
            }
            ++cpt;
        }
        return false;
    }

    boolean existsExternalFile(String type, String path) throws JDOMException {
        Vector<String> list = this.getExternalFiles(type);
        return list.contains(path);
    }

    public static String extractFilename(String path) {
        int lastindex = path.lastIndexOf(46);
        if (lastindex == -1) {
            lastindex = path.length();
        }
        int firstindex = path.lastIndexOf(File.separator);
        return path.substring(firstindex + 1, lastindex);
    }

    public static boolean existsNameOfExternalFile(Vector<String> list, String path) throws JDOMException {
        String filename = FortressPreferences.extractFilename(path);
        int i = 0;
        while (i < list.size()) {
            if (FortressPreferences.extractFilename(list.elementAt(i)).equalsIgnoreCase(filename)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector<String> getSchedulerStrategyList() throws JDOMException {
        Vector<String> result = this.getList("SchedulerStrategyList", "LIST", "name");
        return result;
    }

    public void removeSchedulerStrategy(String strategy_name) throws JDOMException {
        this.removeValue("SchedulerStrategyList", "LIST", "name", strategy_name);
    }

    public void addSchedulerStrategy(String strategy_name) throws JDOMException {
        this.addValue("SchedulerStrategyList", "LIST", "name", strategy_name);
    }

    public boolean isSchedulerStrategy(String strategy_name) throws JDOMException {
        Vector<String> list = this.getList("SchedulerStrategyList", "LIST", "name");
        int i = 0;
        while (i < list.size()) {
            String value = list.elementAt(i);
            if (value.equals(strategy_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector<String> getMonitoringModuleList() throws JDOMException {
        Vector<String> result = this.getList("MonitoringModuleList", "LIST", "name");
        return result;
    }

    public void removeMonitoringModule(String strategy_name) throws JDOMException {
        this.removeValue("MonitoringModuleList", "LIST", "name", strategy_name);
    }

    public void addMonitoringModule(String strategy_name) throws JDOMException {
        this.addValue("MonitoringModuleList", "LIST", "name", strategy_name);
    }

    public boolean isMonitoringModule(String strategy_name) throws JDOMException {
        Vector<String> list = this.getList("MonitoringModuleList", "LIST", "name");
        int i = 0;
        while (i < list.size()) {
            String value = list.elementAt(i);
            if (value.equals(strategy_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector<String> getSchedulerQueueStrategyList() throws JDOMException {
        Vector<String> result = this.getList("SchedulerQueueStrategyList", "LIST", "name");
        return result;
    }

    public void removeSchedulerQueueStrategy(String strategy_name) throws JDOMException {
        this.removeValue("SchedulerQueueStrategyList", "LIST", "name", strategy_name);
    }

    public void addSchedulerQueueStrategy(String strategy_name, String classname) throws JDOMException {
        this.addValue("SchedulerQueueStrategyList", "LIST", "name", strategy_name);
    }

    public boolean isSchedulerQueueStrategy(String strategy_name) throws JDOMException {
        Vector<String> list = this.getList("SchedulerQueueStrategyList", "LIST", "name");
        int i = 0;
        while (i < list.size()) {
            String value = list.elementAt(i);
            if (value.equals(strategy_name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector<ConfigProcessorName> getConfigProcessorNameList() throws JDOMException {
        Vector<ConfigProcessorName> list = new Vector<ConfigProcessorName>();
        List config_list = this.root.getChildren("ProcessorNames");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return list;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("LIST");
        for (Element el2 : config_list) {
            String processor_name = el2.getAttributeValue("ProcessorName");
            float static_power_coeff = Float.valueOf(el2.getAttributeValue("StaticPowerCoeff")).floatValue();
            float idle_power_coeff = Float.valueOf(el2.getAttributeValue("IdlePowerCoeff")).floatValue();
            float run_power_coeff = Float.valueOf(el2.getAttributeValue("RunPowerCoeff")).floatValue();
            list.add(new ConfigProcessorName(processor_name, static_power_coeff, idle_power_coeff, run_power_coeff));
        }
        Collections.sort(list);
        return list;
    }

    public boolean existsConfigProcessorName(ConfigProcessorName cp) throws JDOMException {
        Vector<ConfigProcessorName> list = this.getConfigProcessorNameList();
        int i = 0;
        while (i < list.size()) {
            if (cp.equals(list.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addConfigProcessorName(ConfigProcessorName cp) throws JDOMException {
        List config_list = this.root.getChildren("ProcessorNames");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            Element elp = new Element("ProcessorNames");
            config_list.add(elp);
            config_list = this.root.getChildren("ProcessorNames");
            i = config_list.iterator();
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("LIST");
        if (!this.existsConfigProcessorName(cp)) {
            el = new Element("LIST");
            el.setAttribute("ProcessorName", cp.getProcessorName());
            el.setAttribute("StaticPowerCoeff", String.valueOf(cp.getStaticPowerCoeff()));
            el.setAttribute("IdlePowerCoeff", String.valueOf(cp.getIdlePowerCoeff()));
            el.setAttribute("RunPowerCoeff", String.valueOf(cp.getRunPowerCoeff()));
            config_list.add(el);
        }
    }

    public boolean updateConfigProcessorName(String searchInstName, ConfigProcessorName new_cp) throws JDOMException {
        List config_list = this.root.getChildren("ProcessorNames");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("LIST");
        for (Element el2 : config_list) {
            String val = el2.getAttributeValue("ProcessorName");
            if (!searchInstName.equals(val)) continue;
            el2.setAttribute("ProcessorName", new_cp.getProcessorName());
            el2.setAttribute("StaticPowerCoeff", String.valueOf(new_cp.getStaticPowerCoeff()));
            el2.setAttribute("IdlePowerCoeff", String.valueOf(new_cp.getIdlePowerCoeff()));
            el2.setAttribute("RunPowerCoeff", String.valueOf(new_cp.getRunPowerCoeff()));
            return true;
        }
        return false;
    }

    public boolean removeConfigProcessorName(ConfigProcessorName cp) throws JDOMException {
        List config_list = this.root.getChildren("ProcessorNames");
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("LIST");
        i = config_list.iterator();
        int cpt = 0;
        while (i.hasNext()) {
            el = (Element)i.next();
            String val = el.getAttributeValue("ProcessorName");
            if (val.equals(cp.getProcessorName())) {
                config_list.remove(cpt);
                return true;
            }
            ++cpt;
        }
        return false;
    }

    public Vector<ConfigPowerGroup> getProcConfigPowerGroupList() throws JDOMException {
        return this.getConfigPowerGroupList("ProcPowerGroups");
    }

    public Vector<ConfigPowerGroup> getRZConfigPowerGroupList() throws JDOMException {
        return this.getConfigPowerGroupList("RZPowerGroups");
    }

    private Vector<ConfigPowerGroup> getConfigPowerGroupList(String type) throws JDOMException {
        Vector<ConfigPowerGroup> list = new Vector<ConfigPowerGroup>();
        List config_list = this.root.getChildren(type);
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return list;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("LIST");
        for (Element el2 : config_list) {
            String volt;
            String freq;
            String groupName = el2.getAttributeValue("GroupName");
            boolean commonDomain = Boolean.valueOf(el2.getAttributeValue("CommonDomain"));
            float nominalFctPoint_volt = Float.valueOf(el2.getAttributeValue("NominalVolt")).floatValue();
            float nominalFctPoint_freq = Float.valueOf(el2.getAttributeValue("NominalFreq")).floatValue();
            Vector<ConfigPowerFctPoint> powerFctList = new Vector<ConfigPowerFctPoint>();
            int cpt = 0;
            do {
                freq = el2.getAttributeValue("Freq_" + cpt);
                volt = el2.getAttributeValue("Volt_" + cpt);
                if (freq != null && volt != null) {
                    float freq_pt = Float.valueOf(freq).floatValue();
                    float volt_pt = Float.valueOf(volt).floatValue();
                    powerFctList.addElement(new ConfigPowerFctPoint(volt_pt, freq_pt));
                }
                ++cpt;
            } while (freq != null && volt != null);
            list.add(new ConfigPowerGroup(groupName, commonDomain, new ConfigPowerFctPoint(nominalFctPoint_volt, nominalFctPoint_freq), powerFctList));
        }
        Collections.sort(list);
        return list;
    }

    private boolean existsConfigPowerGroup(String type, ConfigPowerGroup cp) throws JDOMException {
        Vector<ConfigPowerGroup> list = this.getConfigPowerGroupList(type);
        int i = 0;
        while (i < list.size()) {
            if (cp.equals(list.elementAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addProcConfigPowerGroup(ConfigPowerGroup cp) throws JDOMException {
        this.addConfigPowerGroup("ProcPowerGroups", cp);
    }

    public void addRZConfigPowerGroup(ConfigPowerGroup cp) throws JDOMException {
        this.addConfigPowerGroup("RZPowerGroups", cp);
    }

    private void addConfigPowerGroup(String type, ConfigPowerGroup cp) throws JDOMException {
        List config_list = this.root.getChildren(type);
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            Element elp = new Element(type);
            config_list.add(elp);
            config_list = this.root.getChildren(type);
            i = config_list.iterator();
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("LIST");
        if (!this.existsConfigPowerGroup(type, cp)) {
            el = new Element("LIST");
            el.setAttribute("GroupName", cp.getGroupName());
            el.setAttribute("CommonDomain", String.valueOf(cp.isCommonDomain()));
            el.setAttribute("NominalVolt", String.valueOf(cp.getNominalFctPoint().getVoltage()));
            el.setAttribute("NominalFreq", String.valueOf(cp.getNominalFctPoint().getFrequency()));
            Vector<ConfigPowerFctPoint> powerFctList = cp.getctPointList();
            int j = 0;
            while (j < powerFctList.size()) {
                el.setAttribute("Freq_" + j, String.valueOf(powerFctList.elementAt(j).getFrequency()));
                el.setAttribute("Volt_" + j, String.valueOf(powerFctList.elementAt(j).getVoltage()));
                ++j;
            }
            config_list.add(el);
        }
    }

    public boolean updateProcConfigPowerGroup(String searchInstName, ConfigPowerGroup new_cp) throws JDOMException {
        return this.updateConfigPowerGroup("ProcPowerGroups", searchInstName, new_cp);
    }

    public boolean updateRZConfigPowerGroup(String searchInstName, ConfigPowerGroup new_cp) throws JDOMException {
        return this.updateConfigPowerGroup("RZPowerGroups", searchInstName, new_cp);
    }

    private boolean updateConfigPowerGroup(String type, String searchInstName, ConfigPowerGroup new_cp) throws JDOMException {
        List config_list = this.root.getChildren(type);
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element el2 = (Element)i.next();
        config_list = el2.getChildren("LIST");
        for (Element el2 : config_list) {
            String val = el2.getAttributeValue("GroupName");
            if (!searchInstName.equals(val)) continue;
            el2.setAttribute("GroupName", new_cp.getGroupName());
            el2.setAttribute("CommonDomain", String.valueOf(new_cp.isCommonDomain()));
            el2.setAttribute("NominalVolt", String.valueOf(new_cp.getNominalFctPoint().getVoltage()));
            el2.setAttribute("NominalFreq", String.valueOf(new_cp.getNominalFctPoint().getFrequency()));
            Vector<ConfigPowerFctPoint> powerFctList = new_cp.getctPointList();
            int j = 0;
            while (j < powerFctList.size()) {
                el2.setAttribute("Freq_" + j, String.valueOf(powerFctList.elementAt(j).getFrequency()));
                el2.setAttribute("Volt_" + j, String.valueOf(powerFctList.elementAt(j).getVoltage()));
                ++j;
            }
            return true;
        }
        return false;
    }

    public boolean removeProcConfigPowerGroup(ConfigPowerGroup cp) throws JDOMException {
        return this.removeConfigPowerGroup("ProcPowerGroups", cp);
    }

    public boolean removeRZConfigPowerGroup(ConfigPowerGroup cp) throws JDOMException {
        return this.removeConfigPowerGroup("RZPowerGroups", cp);
    }

    private boolean removeConfigPowerGroup(String type, ConfigPowerGroup cp) throws JDOMException {
        List config_list = this.root.getChildren(type);
        Iterator i = config_list.iterator();
        if (!i.hasNext()) {
            return false;
        }
        Element el = (Element)i.next();
        config_list = el.getChildren("LIST");
        i = config_list.iterator();
        int cpt = 0;
        while (i.hasNext()) {
            el = (Element)i.next();
            String val = el.getAttributeValue("GroupName");
            if (val.equals(cp.getGroupName())) {
                config_list.remove(cpt);
                return true;
            }
            ++cpt;
        }
        return false;
    }
}

