/*
 * Decompiled with CFR 0.152.
 */
package fortress.generation;

import fortress.env.FortressEnv;
import fortress.env.FortressException;
import fortress.generation.FortressGeneration;
import fortress.generation.ReplaceKeyword;
import fortress.xml.ConfigApplication;
import fortress.xml.ConfigProcessor;
import fortress.xml.DevicePackage;
import fortress.xml.FPGAConstraints;
import fortress.xml.FPGAInterfaceConstraints;
import fortress.xml.FortressBenchModule;
import fortress.xml.FortressConfiguration;
import fortress.xml.FortressConnection;
import fortress.xml.FortressDeviceLibrary;
import fortress.xml.FortressModuleImplementation;
import fortress.xml.FortressNodeModule;
import fortress.xml.FortressPreferences;
import fortress.xml.FortressSchematic;
import fortress.xml.FortressSystem;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import java.util.Vector;

public class ApplicationGeneration {
    public static final String DEVICE_HEADER_FILENAME = "device.h";
    public static final String RECOSIM_PARAMETERS_FILENAME = "recosim_parameters.cpp";
    public static final String RECOSIM_MAIN_FILENAME = "recosim_main.cpp";
    public static final String MIDDLEWARE_RECOSIM_MAIN_FILENAME = "recosim_main.cpp";
    public static final String RECOSIM_TMP_MAIN_FILENAME = "recosim_main.tmp";
    public static final String MIDDLEWARE_RECOSIM_TMP_MAIN_FILENAME = "middleware_recosim_main.tmp";
    public static final String FORTRESS_PARAMETERS_FILENAME = "fortress_parameters.cpp";
    public static final String FORTRESS_MAIN_FILENAME = "fortress_main.cpp";
    public static final String RECOSIM_USER_SCHEDULING_HEADER_FILENAME = "user_scheduling.h";
    public static final String RECOSIM_USER_SCHEDULING_BODY_FILENAME = "user_scheduling.cpp";
    public static final String RECOSIM_USER_TESTBENCH_ALGORITHM_FILENAME = "user_testbench_algorithms.h";
    public static final String RECOSIM_USER_MODULE_ALGORITHM_FILENAME = "user_module_algorithms.h";
    FortressSystem system;
    String configuration;
    boolean middleware_gen;
    int all_application_number;
    int all_dynamic_task_number;
    int all_static_task_number;
    int all_sw_impl_number;
    int all_hw_impl_number;

    public ApplicationGeneration(String configuration) {
        this.configuration = configuration;
        this.system = FortressEnv.getFortressSystem();
        this.middleware_gen = false;
        this.all_application_number = 0;
        this.all_dynamic_task_number = 0;
        this.all_hw_impl_number = 0;
        this.all_sw_impl_number = 0;
        this.all_static_task_number = 0;
    }

    public void printStatistic(PrintStream out) {
        out.println("--- Statistic ---");
        out.println("Application Number    : " + this.all_application_number);
        out.println("Task Number           : " + (this.all_dynamic_task_number + this.all_static_task_number));
        out.println("      Dynamic Task Number : " + this.all_dynamic_task_number);
        out.println("      Static Task Number  : " + this.all_static_task_number);
        out.println("Implementation Number : " + (this.all_sw_impl_number + this.all_hw_impl_number));
        out.println("      Sw Implementation Number : " + this.all_sw_impl_number);
        out.println("      Hw Implementation Number : " + this.all_hw_impl_number);
    }

    public void GenerateRecosim(OutputStream console) throws Exception {
        this.Generate(console, false);
    }

    public void GenerateMiddleware(OutputStream console) throws Exception {
        this.Generate(console, true);
    }

    protected void Generate(OutputStream console, boolean m_gen) throws Exception {
        String offset_hyperperiod_time;
        String user_monitoring_module_file;
        boolean user_monitoring_module_header_found;
        String user_task_priority_comparator_file;
        boolean user_task_priority_comparator_header_found;
        String dest;
        String user_parameters_file;
        boolean user_parameters_header_found;
        boolean copyResult;
        this.middleware_gen = m_gen;
        this.all_application_number = 0;
        this.all_dynamic_task_number = 0;
        this.all_hw_impl_number = 0;
        this.all_sw_impl_number = 0;
        this.all_static_task_number = 0;
        PrintStream out = new PrintStream(console);
        out.print("Loading Preferences ... ");
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        out.println("done");
        if (pref.isVerboseMode()) {
            out.println("----------------------------------");
            out.println("- Application Generation");
            out.println("- " + FortressEnv.getLaboratory());
            out.println("- " + FortressEnv.today());
            out.println("- Configuration : " + this.configuration);
            out.println();
        }
        out.print("Loading Configuration ... ");
        FortressConfiguration conf = new FortressConfiguration();
        conf.loadFile(this.configuration);
        out.println("done");
        out.print("Loading Device Library ... ");
        FortressDeviceLibrary lib = FortressEnv.getFortressDeviceLibrary();
        DevicePackage dp = lib.getDevicePackage(conf.getSelectedDevice());
        if (dp == null) {
            throw new Exception("No Device Found : " + conf.getSelectedDevice());
        }
        out.println("done");
        Vector<ConfigApplication> activeAppList = conf.getActiveConfigApplicationSchematicNameList();
        Vector<FortressSchematic> appList = new Vector<FortressSchematic>();
        int i = 0;
        while (i < activeAppList.size()) {
            ConfigApplication ca = activeAppList.elementAt(i);
            out.print("Loading Application File : " + ca.getFile() + " ... ");
            FortressSchematic fs = new FortressSchematic(ca.getFile());
            fs.loadFile(ca);
            appList.add(fs);
            out.println("done");
            ++i;
        }
        if (appList.size() == 0) {
            FortressException.messageError(out, "Application Gen.", "No application found ! Please, go to the preference menu and add application(s).");
        }
        this.all_application_number = appList.size();
        String template_simulation_path = FortressEnv.getTemplateGenerationDirPath(this.middleware_gen);
        String copy_simulation_path = FortressEnv.getCopyGenerationDirPath(this.configuration, this.middleware_gen);
        if (pref.isVerboseMode()) {
            out.print("Copying Simulation directory ... ");
        }
        if (!(copyResult = FortressEnv.DirectoryCopy(new File(template_simulation_path), copy_simulation_path))) {
            FortressException.messageError(out, "Application Gen.", "Copy Generation directory not possible !");
        }
        if (pref.isVerboseMode()) {
            out.println("done");
        }
        if (user_parameters_header_found = FortressEnv.isExistFile(user_parameters_file = String.valueOf(FortressEnv.getUserSourcePath()) + "user_parameters.h")) {
            if (pref.isVerboseMode()) {
                FortressException.messageInfo(out, "Application Gen.", "Including Header Parameter File (user_parameters.h)");
            }
            FortressEnv.CreateDirectory(FortressEnv.getUserSourcePath());
            if (!this.middleware_gen && !FortressEnv.FileCopy(new File(user_parameters_file), new File(dest = String.valueOf(FortressEnv.getFortressApplicationPath(this.configuration)) + "user_parameters.h"))) {
                FortressException.messageError(out, "Application Gen.", "Copy of user_parameters.h is not possible on " + dest + " !");
            }
            dest = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + "user_parameters.h";
            if (pref.isVerboseMode()) {
                FortressException.messageInfo(out, "Application Gen.", "Source Including Header Parameter File (" + user_parameters_file + ")");
                FortressException.messageInfo(out, "Application Gen.", "Dest Including Header Parameter File (" + dest + ")");
            }
            if (!FortressEnv.FileCopy(new File(user_parameters_file), new File(dest))) {
                FortressException.messageError(out, "Application Gen.", "Copy of user_parameters.h is not possible on " + dest + " !");
            }
        }
        if (user_parameters_header_found = FortressEnv.isExistFile(user_parameters_file = String.valueOf(FortressEnv.getUserSourcePath()) + "user_parameters.cpp")) {
            if (pref.isVerboseMode()) {
                FortressException.messageInfo(out, "Application Gen.", "Including Body Parameter File (user_parameters.cpp)");
            }
            FortressEnv.CreateDirectory(FortressEnv.getUserSourcePath());
            if (!this.middleware_gen && !FortressEnv.FileCopy(new File(user_parameters_file), new File(dest = String.valueOf(FortressEnv.getFortressApplicationPath(this.configuration)) + "user_parameters.cpp"))) {
                FortressException.messageError(out, "Application Gen.", "Copy of user_parameters.cpp is not possible on " + dest + " !");
            }
            if (!FortressEnv.FileCopy(new File(user_parameters_file), new File(dest = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + "user_parameters.cpp"))) {
                FortressException.messageError(out, "Application Gen.", "Copy of user_parameters.cpp is not possible on " + dest + " !");
            }
        }
        if (user_task_priority_comparator_header_found = FortressEnv.isExistFile(user_task_priority_comparator_file = FortressEnv.getUserTaskPriorityFile())) {
            if (pref.isVerboseMode()) {
                FortressException.messageInfo(out, "Application Gen.", "Including Header File (user_task_priority_comparator.h)");
            }
            if (!FortressEnv.FileCopy(new File(user_task_priority_comparator_file), new File(dest = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + "user_task_priority_comparator.h"))) {
                FortressException.messageError(out, "Application Gen.", "Copy of user_task_priority_comparator.h is not possible on " + dest + " !");
            }
        }
        if (!this.middleware_gen && (user_monitoring_module_header_found = FortressEnv.isExistFile(user_monitoring_module_file = FortressEnv.getUserMonitoringModuleFile()))) {
            if (pref.isVerboseMode()) {
                FortressException.messageInfo(out, "Application Gen.", "Including Header File (user_monitoring.h)");
            }
            if (!FortressEnv.FileCopy(new File(user_monitoring_module_file), new File(dest = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + "user_monitoring.h"))) {
                FortressException.messageError(out, "Application Gen.", "Copy of user_monitoring.h is not possible on " + dest + " !");
            }
        }
        String template_recosim_parameters = FortressEnv.getRecosimParametersTemplateFile();
        String template_recosim_main = !this.middleware_gen ? FortressEnv.getRecosimMainTemplateFile() : FortressEnv.getMiddlewareRecosimMainTemplateFile();
        String template_fortress_parameters = FortressEnv.getFortressParametersTemplateFile();
        String template_fortress_main = FortressEnv.getFortressMainTemplateFile();
        String template_user_scheduling_header = FortressEnv.getUserSchedulingHeaderTemplateFile();
        String template_user_scheduling_body = FortressEnv.getUserSchedulingBodyTemplateFile();
        String template_user_testbench_algo = FortressEnv.getUserTestBenchAlgoTemplateFile();
        String template_user_module_algo = FortressEnv.getUserModuleAlgoTemplateFile();
        String generated_recosim_parameters = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + RECOSIM_PARAMETERS_FILENAME;
        String generated_tmp_recosim_main = !this.middleware_gen ? String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + RECOSIM_TMP_MAIN_FILENAME : String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + MIDDLEWARE_RECOSIM_TMP_MAIN_FILENAME;
        String generated_recosim_main = !this.middleware_gen ? String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + "recosim_main.cpp" : String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + "recosim_main.cpp";
        String generated_fortress_parameters = String.valueOf(FortressEnv.getFortressApplicationPath(this.configuration)) + FORTRESS_PARAMETERS_FILENAME;
        String generated_fortress_main = String.valueOf(FortressEnv.getFortressApplicationPath(this.configuration)) + FORTRESS_MAIN_FILENAME;
        String generated_user_scheduling_header = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + RECOSIM_USER_SCHEDULING_HEADER_FILENAME;
        String generated_user_scheduling_body = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + RECOSIM_USER_SCHEDULING_BODY_FILENAME;
        String generated_user_testbench_algo = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + RECOSIM_USER_TESTBENCH_ALGORITHM_FILENAME;
        String generated_user_module_algo = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + RECOSIM_USER_MODULE_ALGORITHM_FILENAME;
        if (pref.isVerboseMode()) {
            out.print("Running generation of UserScheduling : " + generated_user_scheduling_header + " ... ");
        }
        ReplaceKeyword rk = new ReplaceKeyword(template_user_scheduling_header, generated_user_scheduling_header);
        String buf = FortressGeneration.createFortressHeaderForC(RECOSIM_USER_SCHEDULING_HEADER_FILENAME, "User-defined scheduling schemes for config : " + dp.getDeviceName() + " device" + " (" + dp.getCategory() + ")");
        buf = String.valueOf(buf) + "#define FORTRESS_CONFIGURATION " + this.configuration + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_HEADER", buf);
        buf = conf.getSchedulerQueueStrategy();
        rk.addReplaceKeyword("RECOSIM_PRIORITY_QUEUE_STRATEGY", String.valueOf(buf) + "PriorityComparator");
        Vector<String> schedulerStrategyList = pref.getSchedulerStrategyList();
        buf = schedulerStrategyList.isEmpty() ? "/* No User Scheduler Strategy Handler */" + FortressEnv.EOL : "";
        int i2 = 0;
        while (i2 < schedulerStrategyList.size()) {
            buf = String.valueOf(buf) + "WAITING_QUEUE_HANDLER(" + schedulerStrategyList.elementAt(i2) + ");" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "MAPPING_ALGORITHM(" + schedulerStrategyList.elementAt(i2) + ");" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "SCHEDULING_ALGORITHM(" + schedulerStrategyList.elementAt(i2) + ");" + FortressEnv.EOL;
            ++i2;
        }
        rk.addReplaceKeyword("RECOSIM_WAITING_QUEUE_HANDLER_LIST", buf);
        rk.Generate();
        String user_scheduling_file = FortressEnv.getUserSchedulingStrategyFile();
        boolean user_scheduling_found = FortressEnv.isExistFile(user_scheduling_file);
        if (user_scheduling_found && !schedulerStrategyList.isEmpty()) {
            if (pref.isVerboseMode()) {
                FortressException.messageInfo(out, "Application Gen.", "Including File (user_scheduling.cpp)");
            }
            String user_scheduling_buf = String.valueOf(FortressEnv.readTextFile(user_scheduling_file)) + FortressEnv.EOL;
            String template_user_scheduling_buf = FortressEnv.readTextFile(template_user_scheduling_body);
            Properties replaceList = new Properties();
            int i3 = 0;
            while (i3 < schedulerStrategyList.size()) {
                replaceList.setProperty("RECOMIN_WAITING_QUEUE_HANDLER", schedulerStrategyList.elementAt(i3));
                user_scheduling_buf = String.valueOf(user_scheduling_buf) + ReplaceKeyword.replaceKeywords(template_user_scheduling_buf, replaceList) + FortressEnv.EOL;
                replaceList.clear();
                ++i3;
            }
            FortressEnv.saveFile(generated_user_scheduling_body, user_scheduling_buf);
        }
        if (pref.isVerboseMode()) {
            out.println("done");
        }
        if (pref.isVerboseMode()) {
            out.print("Running generation of Recosim Parameters : " + generated_recosim_parameters + " ... ");
        }
        rk = new ReplaceKeyword(template_recosim_parameters, generated_recosim_parameters);
        buf = FortressGeneration.createFortressHeaderForC(RECOSIM_PARAMETERS_FILENAME, "RecoSim parameters for " + dp.getDeviceName() + " device" + " (" + dp.getCategory() + ")");
        buf = String.valueOf(buf) + "#define FORTRESS_CONFIGURATION " + this.configuration + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_HEADER", buf);
        buf = "rs_time(" + conf.getMaximumSimulationTime() + ", RS_SEC)";
        rk.addReplaceKeyword("FORTRESS_MAXIMUM_SIMULATION_TIME", buf);
        buf = "rs_time(" + conf.getSchedulerExecutionTime() + ", RS_US)";
        rk.addReplaceKeyword("FORTRESS_SCHEDULER_EXECUTION_TIME", buf);
        buf = conf.getSchedulerEnergyConsumption();
        rk.addReplaceKeyword("FORTRESS_SCHEDULER_ENERGY_CONSUMPTION", buf);
        buf = conf.getEnergyConsumptionLimit();
        rk.addReplaceKeyword("FORTRESS_ENERGY_CONSUMPTION_LIMIT", buf);
        buf = String.valueOf(conf.getGenerateZeroFilledLineInCSV());
        rk.addReplaceKeyword("FORTRESS_GENERATE_ZERO_FILLED_LINE_IN_CSV", buf);
        buf = String.valueOf(conf.getTraceWindowFunctionLength());
        rk.addReplaceKeyword("FORTRESS_TRACE_WINDOW_FUNCTION_LENGTH", buf);
        buf = String.valueOf(conf.hasAllDependenciesRequiredBeforeRequest());
        rk.addReplaceKeyword("FORTRESS_ALL_DEPENDENCIES_REQUIRED_BEFORE_REQUEST", buf);
        buf = String.valueOf(conf.getSchedulerPerformanceEffort());
        rk.addReplaceKeyword("FORTRESS_SCHEDULER_PERFORMANCE_EFFORT", buf);
        buf = String.valueOf(conf.getSchedulerEnergyEffort());
        rk.addReplaceKeyword("FORTRESS_SCHEDULER_POWER_EFFORT", buf);
        buf = String.valueOf(conf.getSchedulerAreaEffort());
        rk.addReplaceKeyword("FORTRESS_SCHEDULER_AREA_EFFORT", buf);
        buf = String.valueOf(conf.getHwReconfigurationUnits());
        rk.addReplaceKeyword("FORTRESS_NB_HW_RECONFIGURATION_UNITS", buf);
        buf = String.valueOf(conf.getSwReconfigurationUnits());
        rk.addReplaceKeyword("FORTRESS_NB_SW_RECONFIGURATION_UNITS", buf);
        rk.Generate();
        if (pref.isVerboseMode()) {
            out.println("done");
        }
        if (!this.middleware_gen) {
            if (pref.isVerboseMode()) {
                out.print("Running generation of Fortress Parameters : " + generated_fortress_parameters + " ... ");
            }
            rk = new ReplaceKeyword(template_fortress_parameters, generated_fortress_parameters);
            buf = FortressGeneration.createFortressHeaderForC(FORTRESS_PARAMETERS_FILENAME, "Fortress parameters for " + dp.getDeviceName() + " device" + " (" + dp.getCategory() + ")");
            buf = String.valueOf(buf) + "#define FORTRESS_CONFIGURATION " + this.configuration + FortressEnv.EOL;
            rk.addReplaceKeyword("FORTRESS_HEADER", buf);
            buf = String.valueOf(pref.getXilinxToolVersion().replace('.', '_').toUpperCase());
            rk.addReplaceKeyword("FORTRESS_XILINX_VERSION", buf);
            buf = String.valueOf("\"" + pref.getPlanheadPath().replace('\\', '/') + "\"");
            rk.addReplaceKeyword("FORTRESS_PLANAHEAD_PATH", buf);
            buf = String.valueOf(pref.isVerboseMode());
            rk.addReplaceKeyword("FORTRESS_VERBOSE_MODE", buf);
            buf = String.valueOf(conf.useRZSet());
            rk.addReplaceKeyword("FORTRESS_USE_RZ_SET_DESCRIPTION_FILE", buf);
            buf = "\"" + String.valueOf(String.valueOf(FortressEnv.getConstraintsRelativePath()) + conf.getRZSetDescriptionFilename() + ".rrd") + "\"";
            rk.addReplaceKeyword("FORTRESS_RZ_SET_DESCRIPTION_FILENAME", buf);
            buf = String.valueOf(conf.getAllowPurelyReconfigurableRZ());
            rk.addReplaceKeyword("FORTRESS_ALLOW_PURELY_RECONFIGURABLE_RZ", buf);
            buf = String.valueOf(conf.getAllowRectangularRZ());
            rk.addReplaceKeyword("FORTRESS_ALLOW_NON_RECTANGULAR_RZ", buf);
            buf = String.valueOf(conf.getResourcesMargin());
            rk.addReplaceKeyword("FORTRESS_RESOURCES_MARGIN", buf);
            buf = String.valueOf(conf.getIgnoreRzPositionConstraints());
            rk.addReplaceKeyword("FORTRESS_IGNORE_RZ_POSITION_CONSTRAINTS", buf);
            buf = String.valueOf(conf.getOversizedRzTrigger());
            rk.addReplaceKeyword("FORTRESS_OVERSIZED_RZ_TRIGGER", buf);
            buf = String.valueOf(conf.getShapeWeight());
            rk.addReplaceKeyword("FORTRESS_COST_SHAPE_WEIGHT", buf);
            buf = String.valueOf(conf.getComplianceWeight());
            rk.addReplaceKeyword("FORTRESS_COST_COMPLIANCE_WEIGHT", buf);
            buf = String.valueOf(conf.getInternalFragmentationWeight());
            rk.addReplaceKeyword("FORTRESS_INTERNAL_FRAGMENTATION_WEIGHT", buf);
            buf = String.valueOf(conf.getCheckRZRedundancy());
            rk.addReplaceKeyword("FORTRESS_CHECK_RZ_REDUNDANCY", buf);
            buf = conf.getImplementationMetric().replace(' ', '_');
            rk.addReplaceKeyword("FORTRESS_IMPLEMENTATION_METRIC", buf);
            buf = String.valueOf(conf.getTriggerFactorUnacceptable());
            rk.addReplaceKeyword("FORTRESS_TRIGGER_FACTOR_UNACCEPTABLE", buf);
            buf = String.valueOf(conf.getTriggerFactorOptimum());
            rk.addReplaceKeyword("FORTRESS_TRIGGER_FACTOR_OPTIMUM", buf);
            buf = String.valueOf(conf.getMarginBetweenRZ());
            rk.addReplaceKeyword("FORTRESS_MINIMUM_DISTANCE_BETWEEN_RZS", buf);
            buf = conf.getRZAllocationStrategy().replace(' ', '_');
            rk.addReplaceKeyword("FORTRESS_ALLOCATION_STRATEGY", buf);
            buf = conf.getProcessorAllocationStrategy().replace(' ', '_');
            rk.addReplaceKeyword("FORTRESS_PROCESSOR_ALLOCATION_STRATEGY", buf);
            buf = conf.getPlanAheadImplementation().replace(' ', '_').toUpperCase();
            rk.addReplaceKeyword("FORTRESS_PLANAHEAD_IMPLEMENTATION", buf);
            buf = String.valueOf(conf.getCompressionRate());
            rk.addReplaceKeyword("FORTRESS_MEAN_COMPRESSION_RATIO", buf);
            buf = String.valueOf(conf.getTbus());
            rk.addReplaceKeyword("FORTRESS_TBUS", buf);
            buf = String.valueOf(conf.getTicap());
            rk.addReplaceKeyword("FORTRESS_TICAP", buf);
            buf = String.valueOf(conf.getNburst());
            rk.addReplaceKeyword("FORTRESS_NBURST", buf);
            buf = String.valueOf(conf.getTburst());
            rk.addReplaceKeyword("FORTRESS_TBURST", buf);
            buf = String.valueOf(conf.getLatency());
            rk.addReplaceKeyword("FORTRESS_LATENCY", buf);
            buf = String.valueOf(conf.getFIFODepth());
            rk.addReplaceKeyword("FORTRESS_FIFODEPTH", buf);
            buf = String.valueOf(conf.isRunSimulationUntilStaticSolution());
            rk.addReplaceKeyword("FORTRESS_RUN_SIMULATION_UNTIL_STATIC_SOLUTION", buf);
            rk.Generate();
            if (pref.isVerboseMode()) {
                out.println("done");
            }
        }
        String buf_middleware = "";
        if (pref.isVerboseMode()) {
            out.print("Running generation of Recosim application : " + generated_recosim_main + " ... ");
        }
        rk = new ReplaceKeyword(template_recosim_main, generated_tmp_recosim_main);
        buf = "";
        Vector<ConfigApplication> configAppList = conf.getConfigApplicationList();
        int i4 = 0;
        while (i4 < appList.size()) {
            FortressSchematic fs = (FortressSchematic)appList.elementAt(i4);
            Vector<ConfigApplication> instanceConfigAppList = ConfigApplication.getActiveInstanceList(configAppList, fs.getFileName());
            int app_repeat = instanceConfigAppList.size();
            buf = String.valueOf(buf) + "\t/************************************************" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t * Application File : " + fs.getFileName() + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t */" + FortressEnv.EOL + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t/* Config Application Init */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_CONFIG_APPLICATION_INIT" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\tfor(int i = 0; i < " + app_repeat + "; i++) {" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Module Instances */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_MODULE_INSTANCES" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Add TestBench in Manager */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_ADD_TESTBENCH_IN_MANAGER" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Create a sub-modules table */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\tvector<Manager_interface *> modules_table;" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_MODULE_TABLE" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Following Node modules */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\tvector<int> channel_connection_vector;" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_FOLLOWING_MODULE" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Preceding Node modules */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\tvector<int> preceding_modules_list;" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_PRECEDING_MODULE" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Following Bench modules */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_FOLLOWING_BENCH_MODULE" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Module Hw/Sw Implementations */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_MODULE_HW_SW_IMPL" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Module Properties */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_MODULE_ATTRIBUTES" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Connection Properties */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_MODULE_CONNECTION_ATTRIBUTES" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Module Connections */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_MODULE_INITIATOR_SOCKET" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Manager to modules downlink */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_MODULE_DOWNLINK" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Manager to modules uplink */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_MODULE_UPLINK" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Add Application Instance */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_ADD_APPLICATION_INSTANCE" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Set TestBench (Source only) */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_SET_APPLICATION_OFFSET" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Information Module */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_INFO_MODULE" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* Bindings verification before starting simulation */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_BINDING_VERIFICATION" + i4 + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t\t/* CONFIGURATION TRACE */" + FortressEnv.EOL;
            buf = String.valueOf(buf) + "FORTRESS_CONFIGURATION_TRACE" + i4 + FortressEnv.EOL + FortressEnv.EOL;
            buf = String.valueOf(buf) + "\t}" + FortressEnv.EOL;
            if (this.middleware_gen) {
                buf_middleware = String.valueOf(buf_middleware) + "\tfor(int i = 0; i < " + app_repeat + "; i++) {" + FortressEnv.EOL;
                buf_middleware = String.valueOf(buf_middleware) + "\t\tcout << \"open TB out\" << rs_time_stamp() << endl;" + FortressEnv.EOL;
                buf_middleware = String.valueOf(buf_middleware) + "FORTRESS_MIDDLEWARE_START_APP" + i4 + FortressEnv.EOL;
                buf_middleware = String.valueOf(buf_middleware) + "\t}" + FortressEnv.EOL + FortressEnv.EOL;
            }
            ++i4;
        }
        rk.addReplaceKeyword("FORTRESS_APPLICATIONS_LIST", buf);
        rk.addReplaceKeyword("FORTRESS_MIDDLEWARE_START_APPS", buf_middleware);
        rk.Generate();
        rk = new ReplaceKeyword(generated_tmp_recosim_main, generated_recosim_main);
        buf = FortressGeneration.createFortressHeaderForC("recosim_main.cpp", new String[]{"Main class for " + dp.getDeviceName() + " device" + " (" + dp.getCategory() + ")", "Instantiates the transcoder and launches the simulation.", "The simulation produces a log file and a VCD file."});
        buf = String.valueOf(buf) + "#define FORTRESS_CONFIGURATION " + this.configuration + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_HEADER", buf);
        String strategy_name = conf.getSchedulerStrategy();
        rk.addReplaceKeyword("FORTRESS_WAITING_QUEUE_HANDLER", strategy_name);
        String buf_log = "";
        String buf_trace = "";
        buf_log = String.valueOf(buf_log) + "\tstring logname(\"" + FortressEnv.getRelativeRecosimLogFileWithoutExtension() + "\");" + FortressEnv.EOL;
        buf_log = String.valueOf(buf_log) + "\tif(argc == 3) logname.append(\"_\");" + FortressEnv.EOL;
        buf_log = String.valueOf(buf_log) + "\tlogname.append(simulationName);" + FortressEnv.EOL;
        if (!this.middleware_gen) {
            buf_log = String.valueOf(buf_log) + "\tif(argc == 3) logname.append(\".log\");" + FortressEnv.EOL;
            buf_log = String.valueOf(buf_log) + "\tofstream fout(logname.c_str());" + FortressEnv.EOL;
            buf_log = String.valueOf(buf_log) + "\tcout << \"Log file: \" << logname << endl;" + FortressEnv.EOL;
        }
        buf_trace = String.valueOf(buf_trace) + "\tstring tracename(\"" + FortressEnv.getRelativeRecosimTraceFileWithoutExtension() + "\");" + FortressEnv.EOL;
        buf_trace = String.valueOf(buf_trace) + "\tif(argc == 3) tracename.append(\"_\");" + FortressEnv.EOL;
        buf_trace = String.valueOf(buf_trace) + "\ttracename.append(simulationName);" + FortressEnv.EOL;
        if (!this.middleware_gen) {
            buf_trace = String.valueOf(buf_trace) + "\tsc_trace_file *tf = sc_create_vcd_trace_file(tracename.c_str());" + FortressEnv.EOL;
            buf_trace = String.valueOf(buf_trace) + "\tSimulation_controller::setOutputStreamPtr(&fout);" + FortressEnv.EOL;
        }
        String buf_instance_decl = "";
        StringList stringList = new StringList();
        String buf_user_testbench_algo_list = "";
        int i5 = 0;
        while (i5 < appList.size()) {
            FortressSchematic fs = (FortressSchematic)appList.elementAt(i5);
            String appPrefix = appList.size() == 1 ? "" : String.valueOf(fs.getApplicationName()) + "__";
            buf_instance_decl = String.valueOf(buf_instance_decl) + this.generateRecosimBeforeApplication(out, conf, fs, rk, appPrefix);
            stringList = this.generateRecosimApplication(out, pref, conf, fs, rk, appPrefix, i5, stringList);
            buf_user_testbench_algo_list = String.valueOf(buf_user_testbench_algo_list) + this.generateUserTestBenchAlgoAndCopyHeaderFile(out, pref, fs, buf_user_testbench_algo_list);
            ++i5;
        }
        if (!conf.hasHyperperiodAutomaticComputation()) {
            offset_hyperperiod_time = "\t/* Offset & Hyperperiod */" + FortressEnv.EOL;
            offset_hyperperiod_time = String.valueOf(offset_hyperperiod_time) + "\tApplication::setOffset(rs_time(" + conf.getOffsetTime() + ", RS_US));" + FortressEnv.EOL;
            if (conf.getHyperperiodTime() == 0.0) {
                FortressException.messageError(out, "Application Gen.", "The Hyperperiod is 0 us !");
            } else {
                offset_hyperperiod_time = String.valueOf(offset_hyperperiod_time) + "\tApplication::setHyperperiod(rs_time(" + conf.getHyperperiodTime() + ", RS_US));" + FortressEnv.EOL;
            }
        } else {
            offset_hyperperiod_time = "";
        }
        String buf_monitoring = "";
        Vector<String> monitoring_module_list = pref.getMonitoringModuleList();
        if (monitoring_module_list.size() > 0) {
            buf_monitoring = String.valueOf(buf_monitoring) + "\t/* Monitoring */" + FortressEnv.EOL;
        }
        int i6 = 0;
        while (i6 < monitoring_module_list.size()) {
            String monitoring_classname = String.valueOf(monitoring_module_list.elementAt(i6)) + "_trace_packet";
            buf_monitoring = String.valueOf(buf_monitoring) + "\t" + monitoring_classname + " " + monitoring_classname + "_inst(\"" + monitoring_module_list.elementAt(i6) + "\", manager);" + FortressEnv.EOL;
            buf_monitoring = String.valueOf(buf_monitoring) + "\t" + monitoring_classname + "_inst.activate_trace();" + FortressEnv.EOL;
            ++i6;
        }
        if (monitoring_module_list.size() > 0) {
            buf_monitoring = String.valueOf(buf_monitoring) + FortressEnv.EOL + "\tmanager.setMonitoringEvent(Monitoring::get_thread_number());" + FortressEnv.EOL;
        }
        String buf_max_simulation_time = conf.getMaximumSimulationTime();
        String buf_debug_trace = "";
        buf_debug_trace = conf.isDebugTrace() ? "\tmanager.enable_debug_signals_trace();" + FortressEnv.EOL : "\t// Disabled" + FortressEnv.EOL;
        String buf_manager_attr = "";
        if (!this.middleware_gen) {
            buf_manager_attr = String.valueOf(buf_manager_attr) + "\tmanager.set_scheduler_execution_time(sc_time(" + conf.getSchedulerExecutionTime() + ", SC_US));" + FortressEnv.EOL;
            buf_manager_attr = String.valueOf(buf_manager_attr) + "\tmanager.set_generate_zeros_in_csv(" + conf.getGenerateZeroFilledLineInCSV() + ");" + FortressEnv.EOL;
        } else {
            buf_manager_attr = String.valueOf(buf_manager_attr) + "\tmanager.set_scheduler_execution_time(rs_time(" + conf.getSchedulerExecutionTime() + "));" + FortressEnv.EOL;
        }
        String buf_generate_result_files = "";
        buf_generate_result_files = String.valueOf(buf_generate_result_files) + "\tstring CSVname(\"" + FortressEnv.getRelativeRecosimCSVFileWithoutExtension() + "\");" + FortressEnv.EOL;
        buf_generate_result_files = String.valueOf(buf_generate_result_files) + "\tif(argc == 3) CSVname.append(\"_\");" + FortressEnv.EOL;
        buf_generate_result_files = String.valueOf(buf_generate_result_files) + "\tCSVname.append(simulationName);" + FortressEnv.EOL;
        buf_generate_result_files = String.valueOf(buf_generate_result_files) + "\tCSVname.append(\".csv\");" + FortressEnv.EOL;
        buf_generate_result_files = String.valueOf(buf_generate_result_files) + "\tmanager.generateCSVResultFile(CSVname.c_str());" + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_MODULE_DECL", buf_instance_decl);
        rk.addReplaceKeyword("FORTRESS_LOGFILE", buf_log);
        rk.addReplaceKeyword("FORTRESS_TRACEFILE", buf_trace);
        if (!this.middleware_gen) {
            rk.addReplaceKeyword("FORTRESS_GENERATE_RESULT_FILES", buf_generate_result_files);
        }
        rk.addReplaceKeyword("FORTRESS_MANAGER_ATTRIBUTES", buf_manager_attr);
        rk.addReplaceKeyword("FORTRESS_DEBUG_TRACE", buf_debug_trace);
        if (!this.middleware_gen) {
            rk.addReplaceKeyword("FORTRESS_DELETE_APPLICATIONS_LIST", stringList.buf_delete_app_list);
        }
        rk.addReplaceKeyword("FORTRESS_MONITORING", buf_monitoring);
        if (!this.middleware_gen) {
            rk.addReplaceKeyword("FORTRESS_MAX_SIMULATION_TIME", buf_max_simulation_time);
        }
        rk.addReplaceKeyword("FORTRESS_ALGO_DECLARATION", stringList.buf_algo_decl_list);
        rk.addReplaceKeyword("FORTRESS_OFFSET_HYPERPERIOD", offset_hyperperiod_time);
        rk.addReplaceKeyword("FORTRESS_VERBOSE_MODE", String.valueOf(pref.isVerboseMode()));
        rk.Generate();
        FortressEnv.deleteDir(new File(generated_tmp_recosim_main));
        if (pref.isVerboseMode()) {
            out.println("done");
        }
        if (pref.isVerboseMode()) {
            out.print("Running generation of Module Algorithm Header : " + generated_user_module_algo + " ... ");
        }
        rk = new ReplaceKeyword(template_user_module_algo, generated_user_module_algo);
        buf = FortressGeneration.createFortressHeaderForC(RECOSIM_USER_MODULE_ALGORITHM_FILENAME, "All user-defined module algorithms");
        rk.addReplaceKeyword("FORTRESS_HEADER", buf);
        rk.addReplaceKeyword("RECOSIM_USER_MODULE_ALGORITHM", stringList.buf_user_module_algo_list);
        rk.Generate();
        if (pref.isVerboseMode()) {
            out.println("done");
        }
        if (pref.isVerboseMode()) {
            out.print("Running generation of TestBench Header : " + generated_user_testbench_algo + " ... ");
        }
        rk = new ReplaceKeyword(template_user_testbench_algo, generated_user_testbench_algo);
        buf = FortressGeneration.createFortressHeaderForC(RECOSIM_USER_TESTBENCH_ALGORITHM_FILENAME, "User Testbench algorithms files to be included");
        rk.addReplaceKeyword("FORTRESS_HEADER", buf);
        rk.addReplaceKeyword("RECOSIM_USER_TESTBENCH_ALGORITHM", buf_user_testbench_algo_list);
        rk.Generate();
        if (pref.isVerboseMode()) {
            out.println("done");
        }
        if (!this.middleware_gen) {
            if (pref.isVerboseMode()) {
                out.print("Running generation of FoRTReSS application : " + generated_fortress_main + " ... ");
            }
            rk = new ReplaceKeyword(template_fortress_main, generated_fortress_main);
            buf = FortressGeneration.createFortressHeaderForC(FORTRESS_MAIN_FILENAME, "Main class for the RZ Generator (" + dp.getDeviceName() + " device" + " ," + dp.getCategory() + ")");
            buf = String.valueOf(buf) + "#define FORTRESS_CONFIGURATION " + this.configuration + FortressEnv.EOL;
            rk.addReplaceKeyword("FORTRESS_HEADER", buf);
            this.generateFortressApplication(out, pref, conf, appList, rk);
            rk.Generate();
            if (pref.isVerboseMode()) {
                out.println("done");
            }
        }
    }

    String generateRecosimBeforeApplication(PrintStream out, FortressConfiguration conf, FortressSchematic fs, ReplaceKeyword rk, String appPrefix) throws Exception {
        String buf_instance = "";
        buf_instance = String.valueOf(buf_instance) + "\t// Application : " + fs.getFileName() + FortressEnv.EOL;
        Vector<ConfigApplication> instanceConfigAppList = ConfigApplication.getActiveInstanceList(conf.getConfigApplicationList(), fs.getFileName());
        int app_repeat = instanceConfigAppList.size();
        Vector<FortressNodeModule> nodeList = fs.getNodeModuleList();
        int j = 0;
        while (j < nodeList.size()) {
            FortressNodeModule node = nodeList.elementAt(j);
            String inst = "inst_" + appPrefix + FortressEnv.transformToId(node.getModuleName()) + "[" + app_repeat + "]";
            buf_instance = String.valueOf(buf_instance) + "\tModule<" + node.getInputConnectionNumber() + ", " + node.getOutputConnectionNumber() + ">* " + inst + ";" + FortressEnv.EOL;
            ++j;
        }
        Vector<FortressBenchModule> testbenchList = fs.getTestbenchList();
        int j2 = 0;
        while (j2 < testbenchList.size()) {
            FortressBenchModule node = testbenchList.elementAt(j2);
            String inst = "inst_" + appPrefix + FortressEnv.transformToId(node.getModuleName()) + "[" + app_repeat + "]";
            if (node.getInputConnectionNumber() > 0 && node.getOutputConnectionNumber() == 0) {
                buf_instance = String.valueOf(buf_instance) + "\tTestbenchIn<" + node.getInputConnectionNumber() + ">* " + inst + ";" + FortressEnv.EOL;
            } else if (node.getInputConnectionNumber() == 0 && node.getOutputConnectionNumber() > 0) {
                buf_instance = String.valueOf(buf_instance) + "\tTestbenchOut<" + node.getOutputConnectionNumber() + ">* " + inst + ";" + FortressEnv.EOL;
            } else {
                FortressException.messageError(out, "Application Gen.", "The testbench of " + node.getModuleName() + " has in/out connection(s) ! A testbench can only have In or Out connection.");
            }
            ++j2;
        }
        return buf_instance;
    }

    String generateUserTestBenchAlgoAndCopyHeaderFile(PrintStream out, FortressPreferences pref, FortressSchematic fs, String buf) throws Exception {
        Vector<FortressBenchModule> testbenchList = fs.getTestbenchList();
        int j = 0;
        while (j < testbenchList.size()) {
            FortressBenchModule node = testbenchList.elementAt(j);
            String testbench_thread = node.getTestBenchThread();
            if (testbench_thread.isEmpty()) {
                FortressException.messageWarning(out, "Application Gen.", "The testbench of " + node.getModuleName() + " is empty !. Please, select a testbench in the <testbench_thread> property.");
            } else if (!buf.contains(testbench_thread = String.valueOf(testbench_thread) + ".h")) {
                String dest;
                String benchPath = FortressEnv.getUserBenchesSourcePath();
                if (!FortressEnv.isExistFile(benchPath = String.valueOf(benchPath) + testbench_thread)) {
                    FortressException.messageError(out, "Application Gen.", "The testbench of " + node.getModuleName() + " is not found ! (file: " + testbench_thread + ")");
                }
                if (pref.isVerboseMode()) {
                    out.println("Copy File to Recosim directory  : " + testbench_thread + " ... ");
                }
                if (!FortressEnv.FileCopy(new File(benchPath), new File(dest = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + testbench_thread))) {
                    FortressException.messageError(out, "Application Gen.", "Copy of " + testbench_thread + " is not possible on " + dest + " !");
                }
                buf = String.valueOf(buf) + "#include \"" + testbench_thread + "\"" + FortressEnv.EOL;
            }
            ++j;
        }
        return buf;
    }

    StringList generateRecosimApplication(PrintStream out, FortressPreferences pref, FortressConfiguration conf, FortressSchematic fs, ReplaceKeyword rk, String appPrefix, int appId, StringList stringList) throws Exception {
        String inst;
        String buf_config_app_init = "";
        String buf_instance = "";
        String buf_mod_impl = "";
        String buf_mod_attr = "";
        String buf_mod_table = "";
        String buf_binding_verif = "";
        String buf_config_trace = "";
        String buf_info_module = "";
        String buf_initiator_socket = "";
        String buf_module_downlink = "";
        String buf_module_uplink = "";
        String buf_add_testbench_in_manager = "";
        String buf_mod_con_attr = "";
        String buf_following_module = "";
        String buf_preceding_module = "";
        String buf_set_app_offset = "";
        String buf_bench_following_module = "";
        String buf_add_app_instance = "";
        String buf_middleware_start_app = "";
        String buf_delete_app_list = stringList.buf_delete_app_list;
        String buf_user_module_algo_list = stringList.buf_user_module_algo_list;
        String buf_algo_decl_list = stringList.buf_algo_decl_list;
        String add_reference = "";
        if (this.middleware_gen) {
            add_reference = "&";
        }
        Vector<ConfigApplication> instanceConfigAppList = ConfigApplication.getActiveInstanceList(conf.getConfigApplicationList(), fs.getFileName());
        int app_repeat = instanceConfigAppList.size();
        String modulePrefix = appPrefix.length() == 0 ? "" : String.valueOf(FortressEnv.transformToId(fs.getApplicationName())) + "__";
        Vector<FortressNodeModule> nodeList = fs.getNodeModuleList();
        if (app_repeat > 1) {
            buf_instance = String.valueOf(buf_instance) + "\t\tostringstream out;" + FortressEnv.EOL;
            buf_instance = String.valueOf(buf_instance) + "\t\tout << i;" + FortressEnv.EOL;
            buf_instance = String.valueOf(buf_instance) + "\t\tstring module_name;" + FortressEnv.EOL;
        }
        String config_app_table = String.valueOf(modulePrefix) + "config_app_";
        String config_app_name = String.valueOf(config_app_table) + "inst_name[i]";
        String config_app_QoS = String.valueOf(config_app_table) + "QoS[i]";
        buf_config_app_init = String.valueOf(buf_config_app_init) + "\tstring " + config_app_table + "inst_name[" + app_repeat + "];" + FortressEnv.EOL;
        buf_config_app_init = String.valueOf(buf_config_app_init) + "\tint " + config_app_table + "QoS[" + app_repeat + "];" + FortressEnv.EOL;
        int i = 0;
        while (i < app_repeat) {
            ConfigApplication ca = instanceConfigAppList.elementAt(i);
            buf_config_app_init = String.valueOf(buf_config_app_init) + "\t" + config_app_table + "inst_name[" + i + "] = \"" + FortressEnv.transformToId(fs.getApplicationName()) + "/" + FortressEnv.transformToId(ca.getInstanceName()) + "\";" + FortressEnv.EOL;
            buf_config_app_init = String.valueOf(buf_config_app_init) + "\t" + config_app_table + "QoS[" + i + "] = " + ca.getQoS() + ";" + FortressEnv.EOL;
            ++i;
        }
        buf_delete_app_list = String.valueOf(buf_delete_app_list) + "\tfor(int i = 0; i < " + app_repeat + "; i++) {" + FortressEnv.EOL;
        int j = 0;
        while (j < nodeList.size()) {
            FortressConnection connection;
            FortressNodeModule node = nodeList.elementAt(j);
            if (node.isStaticModule()) {
                ++this.all_static_task_number;
            } else {
                ++this.all_dynamic_task_number;
            }
            boolean hasSuccessor = node.hasSuccessor();
            inst = "inst_" + appPrefix + FortressEnv.transformToId(node.getModuleName()) + "[i]";
            if (app_repeat == 1) {
                buf_instance = !this.middleware_gen ? String.valueOf(buf_instance) + "\t\t" + inst + " = new Module<" + node.getInputConnectionNumber() + ", " + node.getOutputConnectionNumber() + "> (\"" + modulePrefix + FortressEnv.transformToId(node.getModuleName()) + "\", reconf_thread_standard, fout, tf, " + config_app_name + ");" + FortressEnv.EOL : String.valueOf(buf_instance) + "\t\t" + inst + " = new Module<" + node.getInputConnectionNumber() + ", " + node.getOutputConnectionNumber() + "> (\"" + modulePrefix + FortressEnv.transformToId(node.getModuleName()) + "\", reconf_thread_standard, cout, " + config_app_name + ");" + FortressEnv.EOL;
            } else {
                buf_instance = String.valueOf(buf_instance) + "\t\tmodule_name = string(\"" + modulePrefix + FortressEnv.transformToId(node.getModuleName()) + "_\");" + FortressEnv.EOL;
                buf_instance = String.valueOf(buf_instance) + "\t\tmodule_name.append(out.str());" + FortressEnv.EOL;
                buf_instance = !this.middleware_gen ? String.valueOf(buf_instance) + "\t\t" + inst + " = new Module<" + node.getInputConnectionNumber() + ", " + node.getOutputConnectionNumber() + "> (module_name.c_str(), reconf_thread_standard, fout, tf, " + config_app_name + ");" + FortressEnv.EOL : String.valueOf(buf_instance) + "\t\t" + inst + " = new Module<" + node.getInputConnectionNumber() + ", " + node.getOutputConnectionNumber() + "> (module_name.c_str(), reconf_thread_standard, cout, " + config_app_name + ");" + FortressEnv.EOL;
            }
            buf_delete_app_list = String.valueOf(buf_delete_app_list) + "\t\tdelete " + inst + ";" + FortressEnv.EOL;
            String node_hw_sw_impl = "impl_" + FortressEnv.transformToId(node.getModuleName());
            buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\tvector<ModuleImplementation> " + node_hw_sw_impl + ";" + FortressEnv.EOL;
            Vector<FortressModuleImplementation> implList = node.getHwImplementationList();
            this.all_hw_impl_number += implList.size();
            int k = 0;
            while (k < implList.size()) {
                String algoName;
                FortressModuleImplementation fmi = implList.elementAt(k);
                if (fmi.hasUseAlgorithm()) {
                    algoName = fmi.getAlgorithmName();
                    if (algoName.isEmpty()) {
                        FortressException.messageError(out, "Application Gen.", "No Algorithm name for Hw Implementation " + fmi.getImplementationName() + " for node " + node.getModuleName());
                    }
                    if (!buf_user_module_algo_list.contains(algoName)) {
                        String dest;
                        String algoNameFile = String.valueOf(algoName) + ".h";
                        String benchPath = FortressEnv.getUserAlgorithmsSourcePath();
                        if (!FortressEnv.isExistFile(benchPath = String.valueOf(benchPath) + algoNameFile)) {
                            FortressException.messageError(out, "Application Gen.", "The algorithm name of " + node.getModuleName() + " is not found ! (file: " + algoNameFile + ")");
                        }
                        if (pref.isVerboseMode()) {
                            out.println("Copy File to Recosim directory  : " + algoNameFile + " ... ");
                        }
                        if (!FortressEnv.FileCopy(new File(benchPath), new File(dest = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + algoNameFile))) {
                            FortressException.messageError(out, "Application Gen.", "Copy of " + algoNameFile + " is not possible on " + dest + " !");
                        }
                        buf_user_module_algo_list = String.valueOf(buf_user_module_algo_list) + "#include \"" + algoNameFile + "\"" + FortressEnv.EOL;
                    }
                } else {
                    algoName = FortressModuleImplementation.getDefaultHwAlgorithmName();
                }
                String user_algo = String.valueOf(algoName) + "<" + node.getInputConnectionNumber() + ", " + node.getOutputConnectionNumber() + ">";
                buf_mod_impl = !this.middleware_gen ? String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".push_back(ModuleImplementation(\"" + FortressEnv.transformToId(fmi.getImplementationName()) + "\", HARD, (algorithm_thread_type)" + user_algo + ", sc_time(" + fmi.getWCET() + ", SC_US)" + ", sc_time(" + fmi.getBCET() + ", SC_US)));" + FortressEnv.EOL : String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".push_back(ModuleImplementation(\"" + FortressEnv.transformToId(fmi.getImplementationName()) + "\", HARD, (algorithm_thread_type)" + user_algo + ", rs_time(" + fmi.getWCET() + ")" + ", rs_time(" + fmi.getBCET() + ")));" + FortressEnv.EOL;
                if (!buf_algo_decl_list.contains(user_algo)) {
                    buf_algo_decl_list = String.valueOf(buf_algo_decl_list) + "template void " + user_algo + "(User_algorithm_interface<" + node.getInputConnectionNumber() + ", " + node.getOutputConnectionNumber() + ">&);" + FortressEnv.EOL;
                }
                buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().set_use_context_switch_mode(" + fmi.hasUseContextSwitchTime() + ");" + FortressEnv.EOL;
                buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().set_nb_preemption_points(" + fmi.getNbPreemptionPoints() + ");" + FortressEnv.EOL;
                buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().set_frequency(" + fmi.getNbPreemptionPoints() + ");" + FortressEnv.EOL;
                buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().set_p_idle(" + fmi.getPidle() + ");" + FortressEnv.EOL;
                buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().set_p_run(" + fmi.getPrun() + ");" + FortressEnv.EOL;
                buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().set_netlist_name(\"" + fmi.getNetlist() + "\");" + FortressEnv.EOL;
                buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().set_algorithm_name(\"" + fmi.getAlgorithmName() + "\");" + FortressEnv.EOL;
                String type_if = fmi.getInterfaceTypes();
                Vector<String> type_if_list = FortressConfiguration.parseFPGAInterfaceType(type_if);
                if (type_if_list == null) {
                    FortressException.messageError(out, "Application Gen.", "Syntax Error on Interface Type for Hw Implementation " + fmi.getImplementationName() + " for node " + node.getModuleName() + " : " + type_if);
                }
                int cpt_if = 0;
                while (cpt_if < type_if_list.size()) {
                    buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().add_physical_channels(\"" + type_if_list.elementAt(cpt_if) + "\", 1);" + FortressEnv.EOL;
                    ++cpt_if;
                }
                ++k;
            }
            int hw_impl_number = implList.size();
            implList = node.getSwImplementationList();
            int sw_impl_number = implList.size();
            if (conf.getActiveConfigProcessorList().size() == 0 && hw_impl_number == 0 && sw_impl_number > 0) {
                FortressException.messageError(out, "Application Gen.", "You have " + sw_impl_number + " Sw Implementation(s) and no Hw implementation for node " + node.getModuleName() + " but you have not added/activated Processor(s). Add processor to Preference menu.");
            }
            this.all_sw_impl_number += implList.size();
            int k2 = 0;
            while (k2 < implList.size()) {
                String algoName;
                FortressModuleImplementation fmi = implList.elementAt(k2);
                if (fmi.hasUseAlgorithm()) {
                    algoName = fmi.getAlgorithmName();
                    if (algoName.isEmpty()) {
                        FortressException.messageError(out, "Application Gen.", "No Algorithm name for Sw Implementation " + fmi.getImplementationName() + " for node " + node.getModuleName());
                    }
                    if (!buf_user_module_algo_list.contains(algoName)) {
                        String algoNameFile = String.valueOf(algoName) + ".h";
                        String benchPath = FortressEnv.getUserAlgorithmsSourcePath();
                        if (!FortressEnv.isExistFile(benchPath = String.valueOf(benchPath) + algoNameFile)) {
                            FortressException.messageError(out, "Application Gen.", "The algorithm name of " + node.getModuleName() + " is not found ! (file: " + algoNameFile + ")");
                        }
                        out.println("Copy File to Recosim directory  : " + algoNameFile + " ... ");
                        String dest = String.valueOf(FortressEnv.getRecosimApplicationPath(this.configuration, this.middleware_gen)) + algoNameFile;
                        if (!FortressEnv.FileCopy(new File(benchPath), new File(dest))) {
                            FortressException.messageError(out, "Application Gen.", "Copy of " + algoNameFile + " is not possible on " + dest + " !");
                        }
                        buf_user_module_algo_list = String.valueOf(buf_user_module_algo_list) + "#include \"" + algoNameFile + "\"" + FortressEnv.EOL;
                    }
                } else {
                    algoName = FortressModuleImplementation.getDefaultSwAlgorithmName();
                }
                String user_algo = String.valueOf(algoName) + "<" + node.getInputConnectionNumber() + ", " + node.getOutputConnectionNumber() + ">";
                buf_mod_impl = !this.middleware_gen ? String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".push_back(ModuleImplementation(\"" + FortressEnv.transformToId(fmi.getImplementationName()) + "\", SOFT, (algorithm_thread_type)" + user_algo + ", sc_time(" + fmi.getWCET() + ", SC_US)" + ", sc_time(" + fmi.getBCET() + ", SC_US)));" + FortressEnv.EOL : String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".push_back(ModuleImplementation(\"" + FortressEnv.transformToId(fmi.getImplementationName()) + "\", SOFT, (algorithm_thread_type)" + user_algo + ", rs_time(" + fmi.getWCET() + ")" + ", rs_time(" + fmi.getBCET() + ")));" + FortressEnv.EOL;
                if (!buf_algo_decl_list.contains(user_algo)) {
                    buf_algo_decl_list = String.valueOf(buf_algo_decl_list) + "template void " + user_algo + "(User_algorithm_interface<" + node.getInputConnectionNumber() + ", " + node.getOutputConnectionNumber() + ">&);" + FortressEnv.EOL;
                }
                buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().set_use_context_switch_mode(" + fmi.hasUseContextSwitchTime() + ");" + FortressEnv.EOL;
                buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().set_nb_preemption_points(" + fmi.getNbPreemptionPoints() + ");" + FortressEnv.EOL;
                buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().set_algorithm_name(\"" + fmi.getAlgorithmName() + "\");" + FortressEnv.EOL;
                String type_if = fmi.getInterfaceTypes();
                Vector<String> type_if_list = FortressConfiguration.parseFPGAInterfaceType(type_if);
                if (type_if_list == null) {
                    FortressException.messageError(out, "Application Gen.", "Syntax Error on Interface Type for Hw Implementation " + fmi.getImplementationName() + " for node " + node.getModuleName() + " : " + type_if);
                }
                int cpt_if = 0;
                while (cpt_if < type_if_list.size()) {
                    buf_mod_impl = String.valueOf(buf_mod_impl) + "\t\t" + node_hw_sw_impl + ".back().add_physical_channels(\"" + type_if_list.elementAt(cpt_if) + "\", 1);" + FortressEnv.EOL;
                    ++cpt_if;
                }
                ++k2;
            }
            if (node.isStaticModule()) {
                buf_mod_attr = String.valueOf(buf_mod_attr) + "\t\t" + inst + "->set_static_module();" + FortressEnv.EOL;
            }
            if (!this.middleware_gen) {
                buf_mod_attr = String.valueOf(buf_mod_attr) + "\t\t" + inst + "->set_deadline_time(sc_time(" + node.getDeadline() + ", SC_US));" + FortressEnv.EOL;
                buf_mod_attr = String.valueOf(buf_mod_attr) + "\t\t" + inst + "->set_task_period(sc_time(" + node.getPeriod() + ", SC_US));" + FortressEnv.EOL;
                buf_mod_attr = String.valueOf(buf_mod_attr) + "\t\t" + inst + "->set_task_offset(sc_time(" + node.getBeginTime() + ", SC_US));" + FortressEnv.EOL;
            } else {
                buf_mod_attr = String.valueOf(buf_mod_attr) + "\t\t" + inst + "->set_deadline_time(rs_time(" + node.getDeadline() + "));" + FortressEnv.EOL;
                buf_mod_attr = String.valueOf(buf_mod_attr) + "\t\t" + inst + "->set_task_period(rs_time(" + node.getPeriod() + "));" + FortressEnv.EOL;
                buf_mod_attr = String.valueOf(buf_mod_attr) + "\t\t" + inst + "->set_task_offset(rs_time(" + node.getBeginTime() + "));" + FortressEnv.EOL;
            }
            buf_mod_attr = String.valueOf(buf_mod_attr) + "\t\t" + inst + "->set_priority(" + node.getPriority() + ");" + FortressEnv.EOL;
            buf_mod_attr = String.valueOf(buf_mod_attr) + "\t\t" + inst + "->set_implementation_vector(" + node_hw_sw_impl + ");" + FortressEnv.EOL;
            buf_mod_table = String.valueOf(buf_mod_table) + "\t\tmodules_table.push_back(" + inst + ");" + FortressEnv.EOL;
            if (!this.middleware_gen) {
                buf_binding_verif = String.valueOf(buf_binding_verif) + "\t\t" + inst + "->verify_bindings();" + FortressEnv.EOL;
            }
            if (conf.isModuleModeSignalTrace() || node.isEnableExecutionModeSignalsTrace()) {
                buf_config_trace = String.valueOf(buf_config_trace) + "\t\t" + inst + "->enable_configuration_signals_trace();   // Trace Algo Execution Mode" + FortressEnv.EOL;
            }
            if (node.isActivatedTrace() && !this.middleware_gen) {
                buf_config_trace = String.valueOf(buf_config_trace) + "\t\t" + inst + "->activate_trace();" + FortressEnv.EOL;
            }
            buf_info_module = String.valueOf(buf_info_module) + "\t\t" + inst + "->info();" + FortressEnv.EOL;
            buf_following_module = j != 0 && hasSuccessor ? String.valueOf(buf_following_module) + FortressEnv.EOL + "\t\tchannel_connection_vector.clear();" + FortressEnv.EOL : String.valueOf(buf_following_module) + FortressEnv.EOL;
            Vector<FortressConnection> outConnection = node.getOutConnections();
            int k3 = 0;
            while (k3 < outConnection.size()) {
                connection = outConnection.elementAt(k3);
                String target_inst = "inst_" + appPrefix + FortressEnv.transformToId(connection.getTargetModule()) + "[i]";
                buf_initiator_socket = connection.isNodeModule() ? String.valueOf(buf_initiator_socket) + "\t\t" + inst + "->initiator_socket.bind(" + add_reference + target_inst + "->target_socket);" + FortressEnv.EOL : String.valueOf(buf_initiator_socket) + "\t\t" + inst + "->initiator_socket.bind(" + add_reference + target_inst + "->input_target_socket);" + FortressEnv.EOL;
                buf_following_module = !connection.isNodeModule() ? String.valueOf(buf_following_module) + "\t\tchannel_connection_vector.push_back(-1);" + FortressEnv.EOL : String.valueOf(buf_following_module) + "\t\tchannel_connection_vector.push_back(get_module_position_in_vector(" + target_inst + ", modules_table));" + FortressEnv.EOL;
                if (!this.middleware_gen) {
                    buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_begin_req_time(\"" + connection.getConnectionName() + "\", sc_time(" + connection.getBeginReq() + ", SC_US));" + FortressEnv.EOL;
                    buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_end_resp_time(\"" + connection.getConnectionName() + "\", sc_time(" + connection.getEndResp() + ", SC_US));" + FortressEnv.EOL;
                }
                buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_packet_size(\"" + connection.getConnectionName() + "\", " + connection.getPacketSize() + ");" + FortressEnv.EOL;
                buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->add_interface(ModuleInterface(\"" + connection.getConnectionName() + "\", \"" + connection.getOutputCommunicationType() + "\", " + connection.isOutputPriorityChannel() + "));" + FortressEnv.EOL;
                ++k3;
            }
            k3 = 0;
            while (k3 < outConnection.size()) {
                connection = outConnection.elementAt(k3);
                if (k3 == 0 && hasSuccessor) {
                    buf_following_module = String.valueOf(buf_following_module) + "\t\t" + inst + "->set_following_modules_list(channel_connection_vector);" + FortressEnv.EOL;
                }
                buf_following_module = String.valueOf(buf_following_module) + "\t\t" + inst + "->add_following_module_connection_name(\"" + connection.getConnectionName() + "\");" + FortressEnv.EOL;
                ++k3;
            }
            buf_module_downlink = String.valueOf(buf_module_downlink) + "\t\tmanager.module_initiator_socket.bind(" + add_reference + inst + "->manager_target_socket);" + FortressEnv.EOL;
            buf_module_uplink = String.valueOf(buf_module_uplink) + "\t\t" + inst + "->manager_initiator_socket.bind(" + add_reference + "manager.module_target_socket);" + FortressEnv.EOL;
            if (j != 0) {
                buf_preceding_module = String.valueOf(buf_preceding_module) + FortressEnv.EOL + "\t\tpreceding_modules_list.clear();" + FortressEnv.EOL;
            }
            Vector<FortressConnection> inConnection = node.getInConnections();
            boolean entry_point_found = false;
            int k4 = 0;
            while (k4 < inConnection.size()) {
                FortressConnection connection2 = inConnection.elementAt(k4);
                String inout_inst = "inst_" + appPrefix + FortressEnv.transformToId(connection2.getInOutModuleName()) + "[i]";
                if (connection2.isNodeModule()) {
                    buf_preceding_module = String.valueOf(buf_preceding_module) + "\t\tpreceding_modules_list.push_back(get_module_position_in_vector(" + inout_inst + ", modules_table));" + FortressEnv.EOL;
                } else if (!entry_point_found) {
                    entry_point_found = true;
                    buf_preceding_module = String.valueOf(buf_preceding_module) + "\t\tpreceding_modules_list.push_back(-1); // Entry point" + FortressEnv.EOL;
                }
                if (!this.middleware_gen) {
                    buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_end_req_time(\"" + connection2.getConnectionName() + "\", sc_time(" + connection2.getEndReq() + ", SC_US));" + FortressEnv.EOL;
                    buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_begin_resp_time(\"" + connection2.getConnectionName() + "\", sc_time(" + connection2.getBeginResp() + ", SC_US));" + FortressEnv.EOL;
                }
                buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_packet_size(\"" + connection2.getConnectionName() + "\", " + connection2.getPacketSize() + ");" + FortressEnv.EOL;
                buf_mod_con_attr = connection2.isTransientChannel() ? String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->add_interface(ModuleInterface(\"" + connection2.getConnectionName() + "\", \"" + connection2.getInputCommunicationType() + "\", " + connection2.isInputPriorityChannel() + ", true)); // Transient" + FortressEnv.EOL : String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->add_interface(ModuleInterface(\"" + connection2.getConnectionName() + "\", \"" + connection2.getInputCommunicationType() + "\", " + connection2.isInputPriorityChannel() + "));" + FortressEnv.EOL;
                ++k4;
            }
            buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + FortressEnv.EOL;
            k4 = 0;
            while (k4 < inConnection.size()) {
                if (k4 == 0) {
                    buf_preceding_module = String.valueOf(buf_preceding_module) + "\t\t" + inst + "->set_preceding_modules_list(preceding_modules_list);" + FortressEnv.EOL;
                }
                FortressConnection connection3 = inConnection.elementAt(k4);
                buf_preceding_module = String.valueOf(buf_preceding_module) + "\t\t" + inst + "->add_preceding_module_connection_name(\"" + connection3.getConnectionName() + "\");" + FortressEnv.EOL;
                ++k4;
            }
            ++j;
        }
        Vector<FortressBenchModule> testbenchList = fs.getTestbenchList();
        int j2 = 0;
        while (j2 < testbenchList.size()) {
            FortressConnection connection;
            FortressBenchModule node = testbenchList.elementAt(j2);
            inst = "inst_" + appPrefix + FortressEnv.transformToId(node.getModuleName()) + "[i]";
            String benchThread = node.getTestBenchThread();
            if (benchThread.isEmpty()) {
                if (node.getInputConnectionNumber() == 0 && node.getOutputConnectionNumber() > 0) {
                    benchThread = "testbench_out_thread<" + node.getOutputConnectionNumber() + ">";
                } else if (node.getInputConnectionNumber() > 0 && node.getOutputConnectionNumber() == 0) {
                    benchThread = "testbench_in_thread<" + node.getInputConnectionNumber() + ">";
                } else {
                    FortressException.messageError(out, "Application Gen.", "The testbench of " + node.getModuleName() + " has in/out connection(s) ! A testbench can only have In or Out connection.");
                }
            } else if (node.getInputConnectionNumber() == 0 && node.getOutputConnectionNumber() > 0) {
                benchThread = String.valueOf(benchThread) + "<" + node.getOutputConnectionNumber() + ">";
            } else if (node.getInputConnectionNumber() > 0 && node.getOutputConnectionNumber() == 0) {
                benchThread = String.valueOf(benchThread) + "<" + node.getInputConnectionNumber() + ">";
            } else {
                FortressException.messageError(out, "Application Gen.", "The testbench of " + node.getModuleName() + " has in/out connection(s) ! A testbench can only have In or Out connection.");
            }
            if (app_repeat == 1) {
                if (node.getInputConnectionNumber() == 0 && node.getOutputConnectionNumber() > 0) {
                    if (!this.middleware_gen) {
                        buf_instance = String.valueOf(buf_instance) + "\t\t" + inst + " = new TestbenchOut<" + node.getOutputConnectionNumber() + "> (\"" + modulePrefix + FortressEnv.transformToId(node.getModuleName()) + "\", " + benchThread + ", fout, tf);" + FortressEnv.EOL;
                    } else {
                        buf_instance = String.valueOf(buf_instance) + "\t\t" + inst + " = new TestbenchOut<" + node.getOutputConnectionNumber() + "> (\"" + modulePrefix + FortressEnv.transformToId(node.getModuleName()) + "\", " + benchThread + ", cout);" + FortressEnv.EOL;
                        buf_middleware_start_app = String.valueOf(buf_middleware_start_app) + "\t\t" + inst + "->start_tb();";
                    }
                } else if (node.getInputConnectionNumber() > 0 && node.getOutputConnectionNumber() == 0) {
                    buf_instance = !this.middleware_gen ? String.valueOf(buf_instance) + "\t\t" + inst + " = new TestbenchIn<" + node.getInputConnectionNumber() + "> (\"" + modulePrefix + FortressEnv.transformToId(node.getModuleName()) + "\", " + benchThread + ", fout, tf);" + FortressEnv.EOL : String.valueOf(buf_instance) + "\t\t" + inst + " = new TestbenchIn<" + node.getInputConnectionNumber() + "> (\"" + modulePrefix + FortressEnv.transformToId(node.getModuleName()) + "\", " + benchThread + ", cout);" + FortressEnv.EOL;
                } else {
                    FortressException.messageError(out, "Application Gen.", "The testbench of " + node.getModuleName() + " has in/out connection(s) ! A testbench can only have In or Out connection.");
                }
            } else {
                buf_instance = String.valueOf(buf_instance) + "\t\tmodule_name = string(\"" + modulePrefix + FortressEnv.transformToId(node.getModuleName()) + "_\");" + FortressEnv.EOL;
                buf_instance = String.valueOf(buf_instance) + "\t\tmodule_name.append(out.str());" + FortressEnv.EOL;
                if (node.getInputConnectionNumber() == 0 && node.getOutputConnectionNumber() > 0) {
                    if (!this.middleware_gen) {
                        buf_instance = String.valueOf(buf_instance) + "\t\t" + inst + " = new TestbenchOut<" + node.getOutputConnectionNumber() + "> (module_name.c_str(), " + benchThread + ", fout, tf);" + FortressEnv.EOL;
                    } else {
                        buf_instance = String.valueOf(buf_instance) + "\t\t" + inst + " = new TestbenchOut<" + node.getOutputConnectionNumber() + "> (module_name.c_str(), " + benchThread + ", cout);" + FortressEnv.EOL;
                        buf_middleware_start_app = String.valueOf(buf_middleware_start_app) + "\t\t" + inst + "->start_tb();";
                    }
                } else if (node.getInputConnectionNumber() > 0 && node.getOutputConnectionNumber() == 0) {
                    buf_instance = !this.middleware_gen ? String.valueOf(buf_instance) + "\t\t" + inst + " = new TestbenchIn<" + node.getInputConnectionNumber() + "> (module_name.c_str(), " + benchThread + ", fout, tf);" + FortressEnv.EOL : String.valueOf(buf_instance) + "\t\t" + inst + " = new TestbenchIn<" + node.getInputConnectionNumber() + "> (module_name.c_str(), " + benchThread + ", cout);" + FortressEnv.EOL;
                } else {
                    FortressException.messageError(out, "Application Gen.", "The testbench of " + node.getModuleName() + " has in/out connection(s) ! A testbench can only have In or Out connection.");
                }
            }
            buf_delete_app_list = String.valueOf(buf_delete_app_list) + "\t\tdelete " + inst + ";" + FortressEnv.EOL;
            if (!this.middleware_gen) {
                buf_binding_verif = String.valueOf(buf_binding_verif) + "\t\t" + inst + "->verify_bindings();" + FortressEnv.EOL;
            }
            buf_bench_following_module = String.valueOf(buf_bench_following_module) + "\t\tchannel_connection_vector.clear();" + FortressEnv.EOL;
            Vector<FortressConnection> outConnection = node.getOutConnections();
            boolean toNode = false;
            int k = 0;
            while (k < outConnection.size()) {
                FortressConnection connection4 = outConnection.elementAt(k);
                String target_inst = "inst_" + appPrefix + FortressEnv.transformToId(connection4.getTargetModule()) + "[i]";
                toNode |= connection4.isNodeModule();
                buf_initiator_socket = String.valueOf(buf_initiator_socket) + "\t\t" + inst + "->output_initiator_socket.bind(" + add_reference + target_inst + "->target_socket);" + FortressEnv.EOL;
                buf_bench_following_module = String.valueOf(buf_bench_following_module) + "\t\tchannel_connection_vector.push_back(get_module_position_in_vector(" + target_inst + ", modules_table));" + FortressEnv.EOL;
                if (!this.middleware_gen) {
                    buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_begin_req_time(\"" + connection4.getConnectionName() + "\",  sc_time(" + connection4.getBeginReq() + ", SC_US));" + FortressEnv.EOL;
                    buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_end_resp_time(\"" + connection4.getConnectionName() + "\",  sc_time(" + connection4.getEndResp() + ", SC_US));" + FortressEnv.EOL;
                }
                buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_packet_size(\"" + connection4.getConnectionName() + "\", " + connection4.getPacketSize() + ");" + FortressEnv.EOL;
                ++k;
            }
            if (!outConnection.isEmpty()) {
                buf_initiator_socket = String.valueOf(buf_initiator_socket) + "\t\t" + inst + "->manager_initiator_socket.bind(" + add_reference + "manager.testbench_target_socket);" + FortressEnv.EOL;
                buf_initiator_socket = String.valueOf(buf_initiator_socket) + "\t\tmanager.testbench_initiator_socket.bind(" + add_reference + inst + "->manager_target_socket);" + FortressEnv.EOL;
                buf_instance = !this.middleware_gen ? String.valueOf(buf_instance) + "\t\t" + inst + "->set_period(sc_time(" + node.getPeriod() + ", SC_US));" + FortressEnv.EOL : String.valueOf(buf_instance) + "\t\t" + inst + "->set_period(rs_time(" + node.getPeriod() + "));" + FortressEnv.EOL;
            }
            k = 0;
            while (k < outConnection.size()) {
                if (k == 0) {
                    buf_bench_following_module = String.valueOf(buf_bench_following_module) + "\t\t" + inst + "->set_following_modules_list(channel_connection_vector);" + FortressEnv.EOL;
                }
                FortressConnection connection5 = outConnection.elementAt(k);
                buf_bench_following_module = String.valueOf(buf_bench_following_module) + "\t\t" + inst + "->add_following_module_connection_name(\"" + connection5.getConnectionName() + "\");" + FortressEnv.EOL;
                ++k;
            }
            if (j2 != 0) {
                buf_preceding_module = String.valueOf(buf_preceding_module) + FortressEnv.EOL;
            }
            Vector<FortressConnection> inConnection = node.getInConnections();
            int k5 = 0;
            while (k5 < inConnection.size()) {
                connection = inConnection.elementAt(k5);
                if (!this.middleware_gen) {
                    buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_end_req_time(\"" + connection.getConnectionName() + "\", sc_time(" + connection.getEndReq() + ", SC_US));" + FortressEnv.EOL;
                    buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_begin_resp_time(\"" + connection.getConnectionName() + "\", sc_time(" + connection.getBeginResp() + ", SC_US));" + FortressEnv.EOL;
                }
                buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + "\t\t" + inst + "->set_packet_size(\"" + connection.getConnectionName() + "\", " + connection.getPacketSize() + ");" + FortressEnv.EOL;
                ++k5;
            }
            buf_mod_con_attr = String.valueOf(buf_mod_con_attr) + FortressEnv.EOL;
            k5 = 0;
            while (k5 < inConnection.size()) {
                connection = inConnection.elementAt(k5);
                buf_preceding_module = String.valueOf(buf_preceding_module) + "\t\t" + inst + "->add_preceding_module_connection_name(\"" + connection.getConnectionName() + "\");" + FortressEnv.EOL;
                ++k5;
            }
            if (toNode) {
                buf_add_app_instance = app_repeat > 1 ? String.valueOf(buf_add_app_instance) + "\t\tint offset_" + appId + " = manager.addApplication(" + config_app_name + ", \"" + modulePrefix + "\", modules_table, " + config_app_QoS + ", i);" + FortressEnv.EOL : String.valueOf(buf_add_app_instance) + "\t\tint offset_" + appId + " = manager.addApplication(" + config_app_name + ", \"" + modulePrefix + "\", modules_table, " + config_app_QoS + ");" + FortressEnv.EOL;
                buf_set_app_offset = String.valueOf(buf_set_app_offset) + "\t\t" + inst + "->set_application_offset(offset_" + appId + ");" + FortressEnv.EOL;
            }
            buf_set_app_offset = String.valueOf(buf_set_app_offset) + "\t\t" + inst + "->set_application_name(" + config_app_name + ");" + FortressEnv.EOL;
            buf_info_module = String.valueOf(buf_info_module) + "\t\t" + inst + "->info();" + FortressEnv.EOL;
            ++j2;
        }
        buf_delete_app_list = String.valueOf(buf_delete_app_list) + "\t}" + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_CONFIG_APPLICATION_INIT" + appId, buf_config_app_init);
        rk.addReplaceKeyword("FORTRESS_MODULE_INSTANCES" + appId, buf_instance);
        rk.addReplaceKeyword("FORTRESS_MODULE_ATTRIBUTES" + appId, buf_mod_attr);
        rk.addReplaceKeyword("FORTRESS_MODULE_CONNECTION_ATTRIBUTES" + appId, buf_mod_con_attr);
        rk.addReplaceKeyword("FORTRESS_MODULE_HW_SW_IMPL" + appId, buf_mod_impl);
        rk.addReplaceKeyword("FORTRESS_MODULE_TABLE" + appId, buf_mod_table);
        rk.addReplaceKeyword("FORTRESS_BINDING_VERIFICATION" + appId, buf_binding_verif);
        rk.addReplaceKeyword("FORTRESS_CONFIGURATION_TRACE" + appId, buf_config_trace);
        rk.addReplaceKeyword("FORTRESS_INFO_MODULE" + appId, buf_info_module);
        rk.addReplaceKeyword("FORTRESS_MODULE_INITIATOR_SOCKET" + appId, buf_initiator_socket);
        rk.addReplaceKeyword("FORTRESS_MODULE_DOWNLINK" + appId, buf_module_downlink);
        rk.addReplaceKeyword("FORTRESS_MODULE_UPLINK" + appId, buf_module_uplink);
        rk.addReplaceKeyword("FORTRESS_ADD_TESTBENCH_IN_MANAGER" + appId, buf_add_testbench_in_manager);
        rk.addReplaceKeyword("FORTRESS_FOLLOWING_MODULE" + appId, buf_following_module);
        rk.addReplaceKeyword("FORTRESS_FOLLOWING_BENCH_MODULE" + appId, buf_bench_following_module);
        rk.addReplaceKeyword("FORTRESS_PRECEDING_MODULE" + appId, buf_preceding_module);
        rk.addReplaceKeyword("FORTRESS_SET_APPLICATION_OFFSET" + appId, buf_set_app_offset);
        rk.addReplaceKeyword("FORTRESS_ADD_APPLICATION_INSTANCE" + appId, buf_add_app_instance);
        if (this.middleware_gen) {
            rk.addReplaceKeyword("FORTRESS_MIDDLEWARE_START_APP" + appId, buf_middleware_start_app);
        }
        stringList.buf_delete_app_list = buf_delete_app_list;
        stringList.buf_user_module_algo_list = buf_user_module_algo_list;
        stringList.buf_algo_decl_list = buf_algo_decl_list;
        return stringList;
    }

    void generateFortressApplication(PrintStream out, FortressPreferences pref, FortressConfiguration conf, Vector<FortressSchematic> appList, ReplaceKeyword rk) throws Exception {
        String buf_add_node = "";
        String buf_add_sw_node = "";
        String buf_add_path = "";
        String buf_interface_types = "";
        String buf_add_processors = "";
        String buf_add_module = "";
        Vector<FPGAConstraints> interface_list = conf.getFPGAInterfaceConstraints();
        int i = 0;
        while (i < interface_list.size()) {
            FPGAInterfaceConstraints fic = (FPGAInterfaceConstraints)interface_list.elementAt(i);
            if (fic.isRB()) {
                buf_interface_types = String.valueOf(buf_interface_types) + "\tinterfacesVector.push_back(InterfaceLocation(\"" + fic.getInterfaceType() + "\", Coordinates(" + fic.getColumn() + ", " + fic.getRow() + "), " + fic.getPosition() + "));" + FortressEnv.EOL;
            } else {
                int j = fic.getColumn();
                while (j < fic.getColumnMax()) {
                    buf_interface_types = String.valueOf(buf_interface_types) + "\tinterfacesVector.push_back(InterfaceLocation(\"" + fic.getInterfaceType() + "\", Coordinates(" + j + ", " + fic.getRow() + "), " + fic.getPosition() + "));" + FortressEnv.EOL;
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < appList.size()) {
            FortressSchematic fs = appList.elementAt(i);
            String appPrefix = appList.size() == 1 ? "" : String.valueOf(fs.getApplicationName()) + "__";
            Vector<ConfigApplication> configAppList = conf.getConfigApplicationList();
            Vector<ConfigApplication> instanceConfigAppList = ConfigApplication.getActiveInstanceList(configAppList, fs.getFileName());
            int app_repeat = instanceConfigAppList.size();
            buf_add_node = String.valueOf(buf_add_node) + "\t/* Application : " + fs.getApplicationName() + ", repeat : " + app_repeat + " */" + FortressEnv.EOL;
            int repeat = 0;
            while (repeat < app_repeat) {
                Vector<FortressNodeModule> nodeList = fs.getNodeModuleList();
                String iter = app_repeat == 1 ? "" : "_" + String.valueOf(repeat);
                int j = 0;
                while (j < nodeList.size()) {
                    String implName;
                    FortressNodeModule node = nodeList.elementAt(j);
                    String moduleName = String.valueOf(appPrefix) + FortressEnv.transformToId(node.getModuleName()) + iter;
                    buf_add_module = String.valueOf(buf_add_module) + "\tmodules.insert(\"" + moduleName + "\");" + FortressEnv.EOL;
                    Vector<FortressModuleImplementation> implList = node.getHwImplementationList();
                    if (implList.size() == 0) {
                        FortressException.messageWarning(out, "Application Gen.", "No Hw Implementation for " + node.getModuleName());
                    }
                    int k = 0;
                    while (k < implList.size()) {
                        String type_if;
                        Vector<String> type_if_list;
                        double margin;
                        String task_report;
                        String task_report_file;
                        FortressModuleImplementation fmi = implList.elementAt(k);
                        String netlist = fmi.getNetlist();
                        implName = String.valueOf(moduleName) + "." + FortressEnv.transformToId(fmi.getImplementationName());
                        String netlistFile = pref.getNGCFile(netlist);
                        if (netlistFile == null) {
                            netlistFile = pref.getEDFFile(netlist);
                        }
                        if (netlistFile == null) {
                            netlistFile = "";
                            FortressException.messageWarning(out, "Application Gen.", "No Netlist Synthesis File found (" + netlist + ") for Implementation " + fmi.getImplementationName() + " for node " + moduleName);
                        }
                        if ((task_report_file = pref.getRelativeTaskFile(task_report = fmi.getTaskReport())) == null) {
                            FortressException.messageError(out, "Application Gen.", "No Task Report File found (" + task_report + ") for Implementation " + fmi.getImplementationName() + " for node " + moduleName);
                        }
                        netlistFile = FortressEnv.convertPathForLinux(netlistFile);
                        task_report_file = FortressEnv.convertPathForLinux(task_report_file);
                        buf_add_node = String.valueOf(buf_add_node) + "\thwTasks.push_back(HwTask(\"" + implName + "\", \"" + netlistFile + "\", \"" + task_report_file + "\", " + fmi.getContextSwitchTime() + ", " + node.isStaticModule() + "));" + FortressEnv.EOL;
                        String margin_s = fmi.getResourceMargin().trim();
                        if (!margin_s.isEmpty() && (margin = Double.parseDouble(margin_s)) != 0.0) {
                            buf_add_node = String.valueOf(buf_add_node) + "\thwTasks.back().setResourceMargin(" + margin + ");" + FortressEnv.EOL;
                        }
                        if ((type_if_list = FortressConfiguration.parseFPGAInterfaceType(type_if = fmi.getInterfaceTypes())) == null) {
                            FortressException.messageError(out, "Application Gen.", "Syntax Error on Interface Type for Hw Implementation " + fmi.getImplementationName() + " for node " + moduleName + " : " + type_if);
                        }
                        int cpt_if = 0;
                        while (cpt_if < type_if_list.size()) {
                            buf_add_node = String.valueOf(buf_add_node) + "\thwTasks.back().addInterface(TaskInterface(\"" + type_if_list.elementAt(cpt_if) + "\"));" + FortressEnv.EOL;
                            ++cpt_if;
                        }
                        buf_add_node = String.valueOf(buf_add_node) + "\thwTasks.back().setPossibleInterfaceLocations(interfacesVector);" + FortressEnv.EOL;
                        ++k;
                    }
                    int hwImplListSize = implList.size();
                    implList = node.getSwImplementationList();
                    if (hwImplListSize == 0 && implList.size() == 0) {
                        FortressException.messageError(out, "Application Gen.", "No Sw or Sw Implementation for " + node.getModuleName() + " ! Please, add one or more implemntation.");
                    }
                    if (implList.size() == 0) {
                        FortressException.messageWarning(out, "Application Gen.", "No Sw Implementation for " + node.getModuleName());
                    }
                    int k2 = 0;
                    while (k2 < implList.size()) {
                        FortressModuleImplementation fmi = implList.elementAt(k2);
                        implName = String.valueOf(moduleName) + "." + FortressEnv.transformToId(fmi.getImplementationName());
                        String procType = fmi.getProcessorType().trim();
                        buf_add_sw_node = procType.isEmpty() ? String.valueOf(buf_add_sw_node) + "\tswTasks.push_back(SwTask(\"" + implName + "\", " + fmi.getBinaryLoadingTime() + ", " + node.isStaticModule() + "));" + FortressEnv.EOL : String.valueOf(buf_add_sw_node) + "\tswTasks.push_back(SwTask(\"" + implName + "\", " + fmi.getBinaryLoadingTime() + ", " + node.isStaticModule() + ", \"" + procType + "\"));" + FortressEnv.EOL;
                        String type_if = fmi.getInterfaceTypes();
                        Vector<String> type_if_list = FortressConfiguration.parseFPGAInterfaceType(type_if);
                        if (type_if_list == null) {
                            FortressException.messageError(out, "Application Gen.", "Syntax Error on Interface Type for Sw Implementation " + fmi.getImplementationName() + " for node " + moduleName + " : " + type_if);
                        }
                        int cpt_if = 0;
                        while (cpt_if < type_if_list.size()) {
                            buf_add_sw_node = String.valueOf(buf_add_sw_node) + "\tswTasks.back().addInterface(TaskInterface(\"" + type_if_list.elementAt(cpt_if) + "\"));" + FortressEnv.EOL;
                            ++cpt_if;
                        }
                        ++k2;
                    }
                    ++j;
                }
                ++repeat;
            }
            ++i;
        }
        Vector<ConfigProcessor> procList = conf.getActiveConfigProcessorList();
        if (procList.size() > 0) {
            int i2 = 0;
            while (i2 < procList.size()) {
                ConfigProcessor cp = procList.elementAt(i2);
                buf_add_processors = String.valueOf(buf_add_processors) + "\tprocessors.push_back(Processor(\"" + cp.getInstanceName() + "\", \"" + cp.getType() + "\", " + cp.getContextSwitchTime() + "));" + FortressEnv.EOL;
                String type_if = cp.getInterfaces();
                Vector<String> type_if_list = FortressConfiguration.parseFPGAInterfaceType(type_if);
                if (type_if_list == null) {
                    FortressException.messageError(out, "Application Gen.", "Syntax Error on Interface Type for Processor " + cp.getInstanceName() + " with type " + cp.getType() + " : " + type_if);
                }
                int cpt_if = 0;
                while (cpt_if < type_if_list.size()) {
                    buf_add_processors = String.valueOf(buf_add_processors) + "\t\tprocessors.back().addInterface(\"" + type_if_list.elementAt(cpt_if) + "\");" + FortressEnv.EOL;
                    ++cpt_if;
                }
                ++i2;
            }
        }
        buf_add_path = String.valueOf(buf_add_path) + "\tsimulation.setLogDirectory(\"" + FortressEnv.getResultFortressSimulationRelativePath() + "\");" + FortressEnv.EOL;
        buf_add_path = String.valueOf(buf_add_path) + "\tsimulation.setTraceDirectory(\"" + FortressEnv.getResultFortressSimulationRelativePath() + "\");" + FortressEnv.EOL;
        buf_add_path = String.valueOf(buf_add_path) + "\tsimulation.setCSVDirectory(\"" + FortressEnv.getResultFortressSimulationRelativePath() + "\");" + FortressEnv.EOL;
        buf_add_path = String.valueOf(buf_add_path) + "\tsimulation.setUCFDirectory(\"" + FortressEnv.getResultFortressSimulationRelativePath() + "\");" + FortressEnv.EOL;
        buf_add_path = String.valueOf(buf_add_path) + "\tsimulation.setXMLDirectory(\"" + FortressEnv.getResultFortressSimulationRelativePath() + "\");" + FortressEnv.EOL;
        rk.addReplaceKeyword("FORTRESS_ADD_MODULE", buf_add_module);
        rk.addReplaceKeyword("FORTRESS_INTERFACE_TYPES", buf_interface_types);
        rk.addReplaceKeyword("FORTRESS_ADD_PATH", buf_add_path);
        rk.addReplaceKeyword("FORTRESS_ADD_HW_NODE", buf_add_node);
        rk.addReplaceKeyword("FORTRESS_ADD_SW_NODE", buf_add_sw_node);
        rk.addReplaceKeyword("FORTRESS_ADD_PROCESSORS", buf_add_processors);
    }

    class StringList {
        String buf_user_module_algo_list = "";
        String buf_delete_app_list = "";
        String buf_algo_decl_list = "";

        StringList() {
        }
    }
}

