/*
 * Decompiled with CFR 0.152.
 */
package fortress.env;

import fortress.env.FortressEnv;
import fortress.xml.FortressPreferences;
import fortress.xml.FortressProject;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class FortressConsole {
    static MessageConsole myConsole;
    static MessageConsoleStream stream;

    static void searchConsole() {
        try {
            myConsole = null;
            String name = "FoRTReSS Transcript";
            ConsolePlugin plugin = ConsolePlugin.getDefault();
            IConsoleManager conMan = plugin.getConsoleManager();
            IConsole[] existing = conMan.getConsoles();
            int i = 0;
            while (i < existing.length) {
                if (name.equals(existing[i].getName())) {
                    myConsole = (MessageConsole)existing[i];
                    stream = myConsole.newMessageStream();
                }
                ++i;
            }
            if (myConsole == null) {
                myConsole = new MessageConsole(name, null);
                conMan.addConsoles(new IConsole[]{myConsole});
                stream = myConsole.newMessageStream();
                if (PlatformUI.isWorkbenchRunning()) {
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    IConsoleView consoleView = (IConsoleView)page.showView("org.eclipse.ui.console.ConsoleView");
                    consoleView.display((IConsole)myConsole);
                    FortressPreferences pref = new FortressPreferences();
                    pref.loadFile();
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell().setText(FortressEnv.getTitle(new FortressProject().getCurrentProjectPath(), pref.getActiveConfiguration()));
                }
            }
        }
        catch (Exception exception) {}
    }

    public static MessageConsoleStream getMessageConsoleStream() {
        FortressConsole.searchConsole();
        return stream;
    }

    public static void clear() {
        FortressConsole.searchConsole();
        myConsole.clearConsole();
    }

    public static void loadLogFile(String configuration) throws IOException {
        FortressConsole.searchConsole();
        myConsole.clearConsole();
        try {
            String logFile = FortressEnv.getConfigurationLogFile(configuration);
            FortressEnv.readTextFile(logFile, (OutputStream)stream);
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public static void defaultColor() {
        FortressConsole.searchConsole();
        stream = myConsole.newMessageStream();
        stream.setColor(new Color(null, new RGB(0, 0, 255)));
        PrintStream out = new PrintStream((OutputStream)stream);
        out.println("TEST BLEU");
        stream = myConsole.newMessageStream();
        stream.setColor(new Color(null, new RGB(255, 0, 0)));
        out = new PrintStream((OutputStream)stream);
        out.println("TEST ROUGE");
    }

    public static void warningColor() {
        FortressConsole.searchConsole();
        stream.setColor(new Color(null, new RGB(0, 0, 255)));
    }

    public static void errorColor() {
        FortressConsole.searchConsole();
        stream.setColor(new Color(null, new RGB(255, 0, 0)));
    }
}

