/*
 * Decompiled with CFR 0.152.
 */
package fortress.env;

import fortress.env.CommandExecListener;
import fortress.env.DoubleOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;

public class CommandExec {
    ProcessBuilder pb;
    DoubleOutputStream doubleStream;
    Process process;
    ProcessRead pr;

    public CommandExec(OutputStream consoleStream, OutputStream logStream, String dir, String cmd, CommandExecListener commandExecListener) throws IOException {
        this(new DoubleOutputStream(consoleStream, logStream), dir, cmd, commandExecListener);
    }

    public CommandExec(DoubleOutputStream doubleOutputStream, String dir, String cmd, CommandExecListener commandExecListener) throws IOException {
        this.doubleStream = doubleOutputStream;
        this.pb = new ProcessBuilder(cmd);
        this.pb.redirectErrorStream(true);
        this.pb.directory(new File(dir));
    }

    public CommandExec(OutputStream consoleStream, OutputStream logStream, String dir, String[] cmd, CommandExecListener commandExecListener) throws IOException {
        this(new DoubleOutputStream(consoleStream, logStream), dir, cmd, commandExecListener);
    }

    public CommandExec(DoubleOutputStream doubleOutputStream, String dir, String[] cmd, CommandExecListener commandExecListener) throws IOException {
        this.doubleStream = doubleOutputStream;
        this.pb = new ProcessBuilder(cmd);
        this.pb.redirectErrorStream(true);
        this.pb.directory(new File(dir));
    }

    public void start() throws IOException {
        this.process = this.pb.start();
        InputStream in = this.process.getInputStream();
        this.pr = new ProcessRead(in, this.doubleStream);
        this.pr.start();
    }

    public int waitFor() throws InterruptedException {
        return this.process.waitFor();
    }

    public void interrupt() {
        this.process.destroy();
        this.pr.interrupt();
    }

    public void close() throws IOException {
        this.pr.interrupt();
    }

    class ProcessRead
    extends Thread {
        InputStream in;
        OutputStream out;

        public ProcessRead(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(this.in));
                String line = "";
                PrintStream outprint = null;
                if (this.out != null) {
                    outprint = new PrintStream(this.out);
                }
                try {
                    while ((line = reader.readLine()) != null) {
                        if (outprint == null) continue;
                        outprint.println(line);
                    }
                }
                finally {
                    reader.close();
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }
}

