/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands.ViewTrace;

import Modulesystem.diagram.commands.ResultInputDialog;
import fortress.env.DoubleOutputStream;
import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import fortress.xml.FortressPreferences;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Vector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;

public class ViewSimplifiedTraceOthersHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            FortressPreferences pref = FortressEnv.getFortressPreferences();
            pref.loadFile();
            Display display = PlatformUI.createDisplay();
            Vector<String> configurationList = pref.getConfigurations();
            Vector<Object[]> solValues = new Vector<Object[]>();
            int i = 0;
            while (i < configurationList.size()) {
                String placementPath = FortressEnv.getUCFFilePath(configurationList.elementAt(i));
                Vector<String> list = FortressEnv.getFileListWithoutExtension(placementPath, ".vcd");
                solValues.add(list.toArray());
                ++i;
            }
            ResultInputDialog inputDiag = new ResultInputDialog(display, "View Simplified Trace", configurationList.toArray(), solValues);
            boolean result = inputDiag.open();
            if (result) {
                MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
                DoubleOutputStream doubleStream = new DoubleOutputStream((OutputStream)console, null);
                PrintStream out = new PrintStream(doubleStream);
                String cfgFile = (String)inputDiag.getCfgSelectedValue();
                String vcdFile = (String)inputDiag.getSolSelectedValue();
                out.println("Open PDF File : " + FortressEnv.getPDFSimplifiedTrace(cfgFile, vcdFile));
                Program.launch((String)FortressEnv.getPDFSimplifiedTrace(cfgFile, vcdFile));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return pref.hasActiveConfiguration() && FortressEnv.hasOpenedProject() && !pref.getModelsimPath().isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

