/*
 * Decompiled with CFR 0.152.
 */
package Modulesystem.diagram.commands.ViewPlacement;

import Modulesystem.diagram.commands.ResultInputDialog;
import fortress.env.ConsoleCommandExecListener;
import fortress.env.FortressConsole;
import fortress.env.FortressEnv;
import fortress.env.FortressFlow;
import fortress.xml.FortressPreferences;
import java.io.OutputStream;
import java.util.Vector;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.MessageConsoleStream;

public class ViewPlacementOthersHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        block5: {
            try {
                FortressPreferences pref = FortressEnv.getFortressPreferences();
                pref.loadFile();
                Display display = PlatformUI.createDisplay();
                Vector<String> configurationList = pref.getConfigurations();
                Vector<Object[]> solValues = new Vector<Object[]>();
                int i = 0;
                while (i < configurationList.size()) {
                    String placementPath = FortressEnv.getUCFFilePath(configurationList.elementAt(i));
                    Vector<String> list = FortressEnv.getFileListWithoutExtension(placementPath, ".ucf");
                    solValues.add(list.toArray());
                    ++i;
                }
                ResultInputDialog inputDiag = new ResultInputDialog(display, "View Placement", configurationList.toArray(), solValues);
                boolean result = inputDiag.open();
                MessageConsoleStream console = FortressConsole.getMessageConsoleStream();
                if (!result) break block5;
                String cfgFile = (String)inputDiag.getCfgSelectedValue();
                String ucfFile = (String)inputDiag.getSolSelectedValue();
                FortressFlow flow = FortressFlow.createFortressFlow(cfgFile, (OutputStream)console, false);
                flow.setCommandExecListener(new ConsoleCommandExecListener(console));
                try {
                    flow.viewPlacement(ucfFile);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    throw new Exception(ex.getMessage());
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public boolean isEnabled() {
        FortressPreferences pref = FortressEnv.getFortressPreferences();
        try {
            pref.loadFile();
            return pref.hasActiveConfiguration() && FortressEnv.hasOpenedProject() && !pref.getPlanheadPath().isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }
}

